{- This module was generated from data in the Kate syntax
   highlighting file opencl.xml, version 1.44, by  -}

module Text.Highlighting.Kate.Syntax.Opencl
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "OpenCL"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.cl"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("OpenCL","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("OpenCL","Normal") -> return ()
      ("OpenCL","String") -> (popContext) >> pEndLine
      ("OpenCL","Region Marker") -> (popContext) >> pEndLine
      ("OpenCL","Commentar 1") -> (popContext) >> pEndLine
      ("OpenCL","Commentar 2") -> return ()
      ("OpenCL","AfterHash") -> (popContext) >> pEndLine
      ("OpenCL","Preprocessor") -> (popContext) >> pEndLine
      ("OpenCL","Define") -> (popContext) >> pEndLine
      ("OpenCL","Commentar/Preprocessor") -> return ()
      ("OpenCL","Outscoped") -> return ()
      ("OpenCL","Outscoped intern") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "__constant __global __local __private __kernel __read_only __write_only constant global local private kernel read_only write_only break case continue default do else enum for goto if inline return sizeof struct switch typedef union while"
list_types = Set.fromList $ words $ "bool uchar uchar2 uchar3 uchar4 uchar8 uchar16 char char2 char3 char4 char8 char16 const double double2 double3 double4 double8 double16 event_t float float2 float3 float4 float8 float16 half half2 half3 half4 half8 half16 image1d_t image2d_t image3d_t uint uint2 uint3 uint4 uint8 uint16 int int2 int3 int4 int8 int16 ulong ulong2 ulong3 ulong4 ulong8 ulong16 long long2 long3 long4 long8 long16 restrict sampler_t ushort ushort2 ushort3 ushort4 ushort8 ushort16 short short2 short3 short4 short8 short16 signed static unsigned void volatile"

regex_'23'5cs'2aif'5cs'2b0'5cs'2a'24 = compileRegex True "#\\s*if\\s+0\\s*$"
regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 = compileRegex True "#\\s*if(?:def|ndef)?(?=\\s+\\S)"
regex_'23'5cs'2aendif = compileRegex True "#\\s*endif"
regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 = compileRegex True "#\\s*define.*((?=\\\\))"
regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cinclude'28'3f'3a'5fnext'29'3f'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 = compileRegex True "#\\s*(?:el(?:se|if)|include(?:_next)?|define|undef|line|error|warning|pragma)"
regex_'23'5cs'2b'5b0'2d9'5d'2b = compileRegex True "#\\s+[0-9]+"
regex_'23'5cs'2aif = compileRegex True "#\\s*if"
regex_'23'5cs'2ael'28'3f'3ase'7cif'29 = compileRegex True "#\\s*el(?:se|if)"

parseRules ("OpenCL","Normal") =
  (((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0'5cs'2a'24 >>= withAttribute OtherTok) >>~ pushContext ("OpenCL","Outscoped"))
   <|>
   ((pFirstNonSpace >> lookAhead (pDetectChar False '#') >> pushContext ("OpenCL","AfterHash") >> currentContext >>= parseRules))
   <|>
   ((pFirstNonSpace >> pString False "//BEGIN" >>= withAttribute RegionMarkerTok) >>~ pushContext ("OpenCL","Region Marker"))
   <|>
   ((pFirstNonSpace >> pString False "//END" >>= withAttribute RegionMarkerTok) >>~ pushContext ("OpenCL","Region Marker"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\'\"" list_types >>= withAttribute DataTypeTok))
   <|>
   ((pDetectIdentifier >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok))
   <|>
   (withChildren (pFloat >>= withAttribute FloatTok) ((pAnyChar "fF" >>= withAttribute FloatTok)))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   (withChildren (pInt >>= withAttribute DecValTok) (((pString False "ULL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LUL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LLU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "UL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LU" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "LL" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "U" >>= withAttribute DecValTok))
                                                     <|>
                                                     ((pString False "L" >>= withAttribute DecValTok))))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("OpenCL","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen",""))))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Commentar 2"))
   <|>
   ((pAnyChar ":!%&()+,-/.*<=>?[]|~^;" >>= withAttribute NormalTok))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("OpenCL","String") =
  (((pLineContinue >>= withAttribute StringTok))
   <|>
   ((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("OpenCL","Region Marker") =
  (currentContext >>= \x -> guard (x == ("OpenCL","Region Marker")) >> pDefault >>= withAttribute RegionMarkerTok)

parseRules ("OpenCL","Commentar 1") =
  (((pLineContinue >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","Commentar 1")) >> pDefault >>= withAttribute CommentTok))

parseRules ("OpenCL","Commentar 2") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","Commentar 2")) >> pDefault >>= withAttribute CommentTok))

parseRules ("OpenCL","AfterHash") =
  (((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 >>= withAttribute OtherTok) >>~ pushContext ("OpenCL","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute OtherTok) >>~ pushContext ("OpenCL","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 >>= withAttribute OtherTok) >>~ pushContext ("OpenCL","Define"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cinclude'28'3f'3a'5fnext'29'3f'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 >>= withAttribute OtherTok) >>~ pushContext ("OpenCL","Preprocessor"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2b'5b0'2d9'5d'2b >>= withAttribute OtherTok) >>~ pushContext ("OpenCL","Preprocessor"))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","AfterHash")) >> pDefault >>= withAttribute ErrorTok))

parseRules ("OpenCL","Preprocessor") =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '"' '"' >>= withAttribute OtherTok))
   <|>
   ((pRangeDetect '<' '>' >>= withAttribute OtherTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute OtherTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Commentar/Preprocessor"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Commentar 1"))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","Preprocessor")) >> pDefault >>= withAttribute OtherTok))

parseRules ("OpenCL","Define") =
  (((pLineContinue >>= withAttribute OtherTok))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","Define")) >> pDefault >>= withAttribute OtherTok))

parseRules ("OpenCL","Commentar/Preprocessor") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","Commentar/Preprocessor")) >> pDefault >>= withAttribute CommentTok))

parseRules ("OpenCL","Outscoped") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("OpenCL","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Commentar 2"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2ael'28'3f'3ase'7cif'29 >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","Outscoped")) >> pDefault >>= withAttribute CommentTok))

parseRules ("OpenCL","Outscoped intern") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetectIdentifier >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("OpenCL","String"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression (Just ("Doxygen","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Commentar 1"))
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Commentar 2"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute CommentTok) >>~ pushContext ("OpenCL","Outscoped intern"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("OpenCL","Outscoped intern")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Doxygen", _) = Text.Highlighting.Kate.Syntax.Doxygen.parseExpression Nothing
parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("OpenCL","Normal") <|> fail ("Unknown context" ++ show x)
