// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iotdeviceadvisor

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateSuiteDefinition = "CreateSuiteDefinition"

// CreateSuiteDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSuiteDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSuiteDefinition for more information on using the CreateSuiteDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSuiteDefinitionRequest method.
//    req, resp := client.CreateSuiteDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/CreateSuiteDefinition
func (c *IoTDeviceAdvisor) CreateSuiteDefinitionRequest(input *CreateSuiteDefinitionInput) (req *request.Request, output *CreateSuiteDefinitionOutput) {
	op := &request.Operation{
		Name:       opCreateSuiteDefinition,
		HTTPMethod: "POST",
		HTTPPath:   "/suiteDefinitions",
	}

	if input == nil {
		input = &CreateSuiteDefinitionInput{}
	}

	output = &CreateSuiteDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSuiteDefinition API operation for AWS IoT Core Device Advisor.
//
// Creates a Device Advisor test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation CreateSuiteDefinition for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/CreateSuiteDefinition
func (c *IoTDeviceAdvisor) CreateSuiteDefinition(input *CreateSuiteDefinitionInput) (*CreateSuiteDefinitionOutput, error) {
	req, out := c.CreateSuiteDefinitionRequest(input)
	return out, req.Send()
}

// CreateSuiteDefinitionWithContext is the same as CreateSuiteDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSuiteDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) CreateSuiteDefinitionWithContext(ctx aws.Context, input *CreateSuiteDefinitionInput, opts ...request.Option) (*CreateSuiteDefinitionOutput, error) {
	req, out := c.CreateSuiteDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSuiteDefinition = "DeleteSuiteDefinition"

// DeleteSuiteDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSuiteDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSuiteDefinition for more information on using the DeleteSuiteDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSuiteDefinitionRequest method.
//    req, resp := client.DeleteSuiteDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/DeleteSuiteDefinition
func (c *IoTDeviceAdvisor) DeleteSuiteDefinitionRequest(input *DeleteSuiteDefinitionInput) (req *request.Request, output *DeleteSuiteDefinitionOutput) {
	op := &request.Operation{
		Name:       opDeleteSuiteDefinition,
		HTTPMethod: "DELETE",
		HTTPPath:   "/suiteDefinitions/{suiteDefinitionId}",
	}

	if input == nil {
		input = &DeleteSuiteDefinitionInput{}
	}

	output = &DeleteSuiteDefinitionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSuiteDefinition API operation for AWS IoT Core Device Advisor.
//
// Deletes a Device Advisor test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation DeleteSuiteDefinition for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/DeleteSuiteDefinition
func (c *IoTDeviceAdvisor) DeleteSuiteDefinition(input *DeleteSuiteDefinitionInput) (*DeleteSuiteDefinitionOutput, error) {
	req, out := c.DeleteSuiteDefinitionRequest(input)
	return out, req.Send()
}

// DeleteSuiteDefinitionWithContext is the same as DeleteSuiteDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSuiteDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) DeleteSuiteDefinitionWithContext(ctx aws.Context, input *DeleteSuiteDefinitionInput, opts ...request.Option) (*DeleteSuiteDefinitionOutput, error) {
	req, out := c.DeleteSuiteDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSuiteDefinition = "GetSuiteDefinition"

// GetSuiteDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the GetSuiteDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSuiteDefinition for more information on using the GetSuiteDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSuiteDefinitionRequest method.
//    req, resp := client.GetSuiteDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteDefinition
func (c *IoTDeviceAdvisor) GetSuiteDefinitionRequest(input *GetSuiteDefinitionInput) (req *request.Request, output *GetSuiteDefinitionOutput) {
	op := &request.Operation{
		Name:       opGetSuiteDefinition,
		HTTPMethod: "GET",
		HTTPPath:   "/suiteDefinitions/{suiteDefinitionId}",
	}

	if input == nil {
		input = &GetSuiteDefinitionInput{}
	}

	output = &GetSuiteDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSuiteDefinition API operation for AWS IoT Core Device Advisor.
//
// Gets information about a Device Advisor test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation GetSuiteDefinition for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
//   * ResourceNotFoundException
//   Sends Resource Not Found Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteDefinition
func (c *IoTDeviceAdvisor) GetSuiteDefinition(input *GetSuiteDefinitionInput) (*GetSuiteDefinitionOutput, error) {
	req, out := c.GetSuiteDefinitionRequest(input)
	return out, req.Send()
}

// GetSuiteDefinitionWithContext is the same as GetSuiteDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See GetSuiteDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) GetSuiteDefinitionWithContext(ctx aws.Context, input *GetSuiteDefinitionInput, opts ...request.Option) (*GetSuiteDefinitionOutput, error) {
	req, out := c.GetSuiteDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSuiteRun = "GetSuiteRun"

// GetSuiteRunRequest generates a "aws/request.Request" representing the
// client's request for the GetSuiteRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSuiteRun for more information on using the GetSuiteRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSuiteRunRequest method.
//    req, resp := client.GetSuiteRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRun
func (c *IoTDeviceAdvisor) GetSuiteRunRequest(input *GetSuiteRunInput) (req *request.Request, output *GetSuiteRunOutput) {
	op := &request.Operation{
		Name:       opGetSuiteRun,
		HTTPMethod: "GET",
		HTTPPath:   "/suiteDefinitions/{suiteDefinitionId}/suiteRuns/{suiteRunId}",
	}

	if input == nil {
		input = &GetSuiteRunInput{}
	}

	output = &GetSuiteRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSuiteRun API operation for AWS IoT Core Device Advisor.
//
// Gets information about a Device Advisor test suite run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation GetSuiteRun for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
//   * ResourceNotFoundException
//   Sends Resource Not Found Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRun
func (c *IoTDeviceAdvisor) GetSuiteRun(input *GetSuiteRunInput) (*GetSuiteRunOutput, error) {
	req, out := c.GetSuiteRunRequest(input)
	return out, req.Send()
}

// GetSuiteRunWithContext is the same as GetSuiteRun with the addition of
// the ability to pass a context and additional request options.
//
// See GetSuiteRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) GetSuiteRunWithContext(ctx aws.Context, input *GetSuiteRunInput, opts ...request.Option) (*GetSuiteRunOutput, error) {
	req, out := c.GetSuiteRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSuiteRunReport = "GetSuiteRunReport"

// GetSuiteRunReportRequest generates a "aws/request.Request" representing the
// client's request for the GetSuiteRunReport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSuiteRunReport for more information on using the GetSuiteRunReport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSuiteRunReportRequest method.
//    req, resp := client.GetSuiteRunReportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRunReport
func (c *IoTDeviceAdvisor) GetSuiteRunReportRequest(input *GetSuiteRunReportInput) (req *request.Request, output *GetSuiteRunReportOutput) {
	op := &request.Operation{
		Name:       opGetSuiteRunReport,
		HTTPMethod: "GET",
		HTTPPath:   "/suiteDefinitions/{suiteDefinitionId}/suiteRuns/{suiteRunId}/report",
	}

	if input == nil {
		input = &GetSuiteRunReportInput{}
	}

	output = &GetSuiteRunReportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSuiteRunReport API operation for AWS IoT Core Device Advisor.
//
// Gets a report download link for a successful Device Advisor qualifying test
// suite run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation GetSuiteRunReport for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
//   * ResourceNotFoundException
//   Sends Resource Not Found Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/GetSuiteRunReport
func (c *IoTDeviceAdvisor) GetSuiteRunReport(input *GetSuiteRunReportInput) (*GetSuiteRunReportOutput, error) {
	req, out := c.GetSuiteRunReportRequest(input)
	return out, req.Send()
}

// GetSuiteRunReportWithContext is the same as GetSuiteRunReport with the addition of
// the ability to pass a context and additional request options.
//
// See GetSuiteRunReport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) GetSuiteRunReportWithContext(ctx aws.Context, input *GetSuiteRunReportInput, opts ...request.Option) (*GetSuiteRunReportOutput, error) {
	req, out := c.GetSuiteRunReportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSuiteDefinitions = "ListSuiteDefinitions"

// ListSuiteDefinitionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSuiteDefinitions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSuiteDefinitions for more information on using the ListSuiteDefinitions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSuiteDefinitionsRequest method.
//    req, resp := client.ListSuiteDefinitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions
func (c *IoTDeviceAdvisor) ListSuiteDefinitionsRequest(input *ListSuiteDefinitionsInput) (req *request.Request, output *ListSuiteDefinitionsOutput) {
	op := &request.Operation{
		Name:       opListSuiteDefinitions,
		HTTPMethod: "GET",
		HTTPPath:   "/suiteDefinitions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSuiteDefinitionsInput{}
	}

	output = &ListSuiteDefinitionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSuiteDefinitions API operation for AWS IoT Core Device Advisor.
//
// Lists the Device Advisor test suites you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation ListSuiteDefinitions for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteDefinitions
func (c *IoTDeviceAdvisor) ListSuiteDefinitions(input *ListSuiteDefinitionsInput) (*ListSuiteDefinitionsOutput, error) {
	req, out := c.ListSuiteDefinitionsRequest(input)
	return out, req.Send()
}

// ListSuiteDefinitionsWithContext is the same as ListSuiteDefinitions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSuiteDefinitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) ListSuiteDefinitionsWithContext(ctx aws.Context, input *ListSuiteDefinitionsInput, opts ...request.Option) (*ListSuiteDefinitionsOutput, error) {
	req, out := c.ListSuiteDefinitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSuiteDefinitionsPages iterates over the pages of a ListSuiteDefinitions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSuiteDefinitions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSuiteDefinitions operation.
//    pageNum := 0
//    err := client.ListSuiteDefinitionsPages(params,
//        func(page *iotdeviceadvisor.ListSuiteDefinitionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTDeviceAdvisor) ListSuiteDefinitionsPages(input *ListSuiteDefinitionsInput, fn func(*ListSuiteDefinitionsOutput, bool) bool) error {
	return c.ListSuiteDefinitionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSuiteDefinitionsPagesWithContext same as ListSuiteDefinitionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) ListSuiteDefinitionsPagesWithContext(ctx aws.Context, input *ListSuiteDefinitionsInput, fn func(*ListSuiteDefinitionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSuiteDefinitionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSuiteDefinitionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSuiteDefinitionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSuiteRuns = "ListSuiteRuns"

// ListSuiteRunsRequest generates a "aws/request.Request" representing the
// client's request for the ListSuiteRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSuiteRuns for more information on using the ListSuiteRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSuiteRunsRequest method.
//    req, resp := client.ListSuiteRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns
func (c *IoTDeviceAdvisor) ListSuiteRunsRequest(input *ListSuiteRunsInput) (req *request.Request, output *ListSuiteRunsOutput) {
	op := &request.Operation{
		Name:       opListSuiteRuns,
		HTTPMethod: "GET",
		HTTPPath:   "/suiteRuns",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSuiteRunsInput{}
	}

	output = &ListSuiteRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSuiteRuns API operation for AWS IoT Core Device Advisor.
//
// Lists the runs of the specified Device Advisor test suite. You can list all
// runs of the test suite, or the runs of a specific version of the test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation ListSuiteRuns for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListSuiteRuns
func (c *IoTDeviceAdvisor) ListSuiteRuns(input *ListSuiteRunsInput) (*ListSuiteRunsOutput, error) {
	req, out := c.ListSuiteRunsRequest(input)
	return out, req.Send()
}

// ListSuiteRunsWithContext is the same as ListSuiteRuns with the addition of
// the ability to pass a context and additional request options.
//
// See ListSuiteRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) ListSuiteRunsWithContext(ctx aws.Context, input *ListSuiteRunsInput, opts ...request.Option) (*ListSuiteRunsOutput, error) {
	req, out := c.ListSuiteRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSuiteRunsPages iterates over the pages of a ListSuiteRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSuiteRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSuiteRuns operation.
//    pageNum := 0
//    err := client.ListSuiteRunsPages(params,
//        func(page *iotdeviceadvisor.ListSuiteRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *IoTDeviceAdvisor) ListSuiteRunsPages(input *ListSuiteRunsInput, fn func(*ListSuiteRunsOutput, bool) bool) error {
	return c.ListSuiteRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSuiteRunsPagesWithContext same as ListSuiteRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) ListSuiteRunsPagesWithContext(ctx aws.Context, input *ListSuiteRunsInput, fn func(*ListSuiteRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSuiteRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSuiteRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSuiteRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListTagsForResource
func (c *IoTDeviceAdvisor) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS IoT Core Device Advisor.
//
// Lists the tags attached to an IoT Device Advisor resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Sends Internal Failure Exception.
//
//   * ValidationException
//   Sends invalid request exception.
//
//   * ResourceNotFoundException
//   Sends Resource Not Found Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/ListTagsForResource
func (c *IoTDeviceAdvisor) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSuiteRun = "StartSuiteRun"

// StartSuiteRunRequest generates a "aws/request.Request" representing the
// client's request for the StartSuiteRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSuiteRun for more information on using the StartSuiteRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSuiteRunRequest method.
//    req, resp := client.StartSuiteRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StartSuiteRun
func (c *IoTDeviceAdvisor) StartSuiteRunRequest(input *StartSuiteRunInput) (req *request.Request, output *StartSuiteRunOutput) {
	op := &request.Operation{
		Name:       opStartSuiteRun,
		HTTPMethod: "POST",
		HTTPPath:   "/suiteDefinitions/{suiteDefinitionId}/suiteRuns",
	}

	if input == nil {
		input = &StartSuiteRunInput{}
	}

	output = &StartSuiteRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSuiteRun API operation for AWS IoT Core Device Advisor.
//
// Starts a Device Advisor test suite run.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation StartSuiteRun for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
//   * ConflictException
//   Sends Conflict Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StartSuiteRun
func (c *IoTDeviceAdvisor) StartSuiteRun(input *StartSuiteRunInput) (*StartSuiteRunOutput, error) {
	req, out := c.StartSuiteRunRequest(input)
	return out, req.Send()
}

// StartSuiteRunWithContext is the same as StartSuiteRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartSuiteRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) StartSuiteRunWithContext(ctx aws.Context, input *StartSuiteRunInput, opts ...request.Option) (*StartSuiteRunOutput, error) {
	req, out := c.StartSuiteRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopSuiteRun = "StopSuiteRun"

// StopSuiteRunRequest generates a "aws/request.Request" representing the
// client's request for the StopSuiteRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopSuiteRun for more information on using the StopSuiteRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopSuiteRunRequest method.
//    req, resp := client.StopSuiteRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StopSuiteRun
func (c *IoTDeviceAdvisor) StopSuiteRunRequest(input *StopSuiteRunInput) (req *request.Request, output *StopSuiteRunOutput) {
	op := &request.Operation{
		Name:       opStopSuiteRun,
		HTTPMethod: "POST",
		HTTPPath:   "/suiteDefinitions/{suiteDefinitionId}/suiteRuns/{suiteRunId}/stop",
	}

	if input == nil {
		input = &StopSuiteRunInput{}
	}

	output = &StopSuiteRunOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopSuiteRun API operation for AWS IoT Core Device Advisor.
//
// Stops a Device Advisor test suite run that is currently running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation StopSuiteRun for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * ResourceNotFoundException
//   Sends Resource Not Found Exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/StopSuiteRun
func (c *IoTDeviceAdvisor) StopSuiteRun(input *StopSuiteRunInput) (*StopSuiteRunOutput, error) {
	req, out := c.StopSuiteRunRequest(input)
	return out, req.Send()
}

// StopSuiteRunWithContext is the same as StopSuiteRun with the addition of
// the ability to pass a context and additional request options.
//
// See StopSuiteRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) StopSuiteRunWithContext(ctx aws.Context, input *StopSuiteRunInput, opts ...request.Option) (*StopSuiteRunOutput, error) {
	req, out := c.StopSuiteRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/TagResource
func (c *IoTDeviceAdvisor) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS IoT Core Device Advisor.
//
// Adds to and modifies existing tags of an IoT Device Advisor resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Sends Internal Failure Exception.
//
//   * ValidationException
//   Sends invalid request exception.
//
//   * ResourceNotFoundException
//   Sends Resource Not Found Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/TagResource
func (c *IoTDeviceAdvisor) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UntagResource
func (c *IoTDeviceAdvisor) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS IoT Core Device Advisor.
//
// Removes tags from an IoT Device Advisor resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   Sends Internal Failure Exception.
//
//   * ValidationException
//   Sends invalid request exception.
//
//   * ResourceNotFoundException
//   Sends Resource Not Found Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UntagResource
func (c *IoTDeviceAdvisor) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSuiteDefinition = "UpdateSuiteDefinition"

// UpdateSuiteDefinitionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSuiteDefinition operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSuiteDefinition for more information on using the UpdateSuiteDefinition
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSuiteDefinitionRequest method.
//    req, resp := client.UpdateSuiteDefinitionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UpdateSuiteDefinition
func (c *IoTDeviceAdvisor) UpdateSuiteDefinitionRequest(input *UpdateSuiteDefinitionInput) (req *request.Request, output *UpdateSuiteDefinitionOutput) {
	op := &request.Operation{
		Name:       opUpdateSuiteDefinition,
		HTTPMethod: "PATCH",
		HTTPPath:   "/suiteDefinitions/{suiteDefinitionId}",
	}

	if input == nil {
		input = &UpdateSuiteDefinitionInput{}
	}

	output = &UpdateSuiteDefinitionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSuiteDefinition API operation for AWS IoT Core Device Advisor.
//
// Updates a Device Advisor test suite.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS IoT Core Device Advisor's
// API operation UpdateSuiteDefinition for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   Sends invalid request exception.
//
//   * InternalServerException
//   Sends Internal Failure Exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/iotdeviceadvisor-2020-09-18/UpdateSuiteDefinition
func (c *IoTDeviceAdvisor) UpdateSuiteDefinition(input *UpdateSuiteDefinitionInput) (*UpdateSuiteDefinitionOutput, error) {
	req, out := c.UpdateSuiteDefinitionRequest(input)
	return out, req.Send()
}

// UpdateSuiteDefinitionWithContext is the same as UpdateSuiteDefinition with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSuiteDefinition for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *IoTDeviceAdvisor) UpdateSuiteDefinitionWithContext(ctx aws.Context, input *UpdateSuiteDefinitionInput, opts ...request.Option) (*UpdateSuiteDefinitionOutput, error) {
	req, out := c.UpdateSuiteDefinitionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Sends Conflict Exception.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Sends Conflict Exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateSuiteDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Creates a Device Advisor test suite with suite definition configuration.
	SuiteDefinitionConfiguration *SuiteDefinitionConfiguration `locationName:"suiteDefinitionConfiguration" type:"structure"`

	// The tags to be attached to the suite definition.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSuiteDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSuiteDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSuiteDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSuiteDefinitionInput"}
	if s.SuiteDefinitionConfiguration != nil {
		if err := s.SuiteDefinitionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SuiteDefinitionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuiteDefinitionConfiguration sets the SuiteDefinitionConfiguration field's value.
func (s *CreateSuiteDefinitionInput) SetSuiteDefinitionConfiguration(v *SuiteDefinitionConfiguration) *CreateSuiteDefinitionInput {
	s.SuiteDefinitionConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSuiteDefinitionInput) SetTags(v map[string]*string) *CreateSuiteDefinitionInput {
	s.Tags = v
	return s
}

type CreateSuiteDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Creates a Device Advisor test suite with TimeStamp of when it was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Creates a Device Advisor test suite with Amazon Resource name.
	SuiteDefinitionArn *string `locationName:"suiteDefinitionArn" min:"20" type:"string"`

	// Creates a Device Advisor test suite with suite UUID.
	SuiteDefinitionId *string `locationName:"suiteDefinitionId" min:"12" type:"string"`

	// Creates a Device Advisor test suite with suite definition name.
	SuiteDefinitionName *string `locationName:"suiteDefinitionName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSuiteDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSuiteDefinitionOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateSuiteDefinitionOutput) SetCreatedAt(v time.Time) *CreateSuiteDefinitionOutput {
	s.CreatedAt = &v
	return s
}

// SetSuiteDefinitionArn sets the SuiteDefinitionArn field's value.
func (s *CreateSuiteDefinitionOutput) SetSuiteDefinitionArn(v string) *CreateSuiteDefinitionOutput {
	s.SuiteDefinitionArn = &v
	return s
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *CreateSuiteDefinitionOutput) SetSuiteDefinitionId(v string) *CreateSuiteDefinitionOutput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionName sets the SuiteDefinitionName field's value.
func (s *CreateSuiteDefinitionOutput) SetSuiteDefinitionName(v string) *CreateSuiteDefinitionOutput {
	s.SuiteDefinitionName = &v
	return s
}

type DeleteSuiteDefinitionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Suite definition Id of the test suite to be deleted.
	//
	// SuiteDefinitionId is a required field
	SuiteDefinitionId *string `location:"uri" locationName:"suiteDefinitionId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSuiteDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSuiteDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSuiteDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSuiteDefinitionInput"}
	if s.SuiteDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteDefinitionId"))
	}
	if s.SuiteDefinitionId != nil && len(*s.SuiteDefinitionId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *DeleteSuiteDefinitionInput) SetSuiteDefinitionId(v string) *DeleteSuiteDefinitionInput {
	s.SuiteDefinitionId = &v
	return s
}

type DeleteSuiteDefinitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSuiteDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSuiteDefinitionOutput) GoString() string {
	return s.String()
}

// Lists all the devices under test
type DeviceUnderTest struct {
	_ struct{} `type:"structure"`

	// Lists devices certificate arn
	CertificateArn *string `locationName:"certificateArn" min:"20" type:"string"`

	// Lists devices thing arn
	ThingArn *string `locationName:"thingArn" min:"20" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceUnderTest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeviceUnderTest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeviceUnderTest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeviceUnderTest"}
	if s.CertificateArn != nil && len(*s.CertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CertificateArn", 20))
	}
	if s.ThingArn != nil && len(*s.ThingArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ThingArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DeviceUnderTest) SetCertificateArn(v string) *DeviceUnderTest {
	s.CertificateArn = &v
	return s
}

// SetThingArn sets the ThingArn field's value.
func (s *DeviceUnderTest) SetThingArn(v string) *DeviceUnderTest {
	s.ThingArn = &v
	return s
}

type GetSuiteDefinitionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Suite definition Id of the test suite to get.
	//
	// SuiteDefinitionId is a required field
	SuiteDefinitionId *string `location:"uri" locationName:"suiteDefinitionId" min:"12" type:"string" required:"true"`

	// Suite definition version of the test suite to get.
	SuiteDefinitionVersion *string `location:"querystring" locationName:"suiteDefinitionVersion" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSuiteDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSuiteDefinitionInput"}
	if s.SuiteDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteDefinitionId"))
	}
	if s.SuiteDefinitionId != nil && len(*s.SuiteDefinitionId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionId", 12))
	}
	if s.SuiteDefinitionVersion != nil && len(*s.SuiteDefinitionVersion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionVersion", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *GetSuiteDefinitionInput) SetSuiteDefinitionId(v string) *GetSuiteDefinitionInput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionVersion sets the SuiteDefinitionVersion field's value.
func (s *GetSuiteDefinitionInput) SetSuiteDefinitionVersion(v string) *GetSuiteDefinitionInput {
	s.SuiteDefinitionVersion = &v
	return s
}

type GetSuiteDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Date (in Unix epoch time) when the suite definition was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Date (in Unix epoch time) when the suite definition was last modified.
	LastModifiedAt *time.Time `locationName:"lastModifiedAt" type:"timestamp"`

	// Latest suite definition version of the suite definition.
	LatestVersion *string `locationName:"latestVersion" min:"2" type:"string"`

	// The ARN of the suite definition.
	SuiteDefinitionArn *string `locationName:"suiteDefinitionArn" min:"20" type:"string"`

	// Suite configuration of the suite definition.
	SuiteDefinitionConfiguration *SuiteDefinitionConfiguration `locationName:"suiteDefinitionConfiguration" type:"structure"`

	// Suite definition Id of the suite definition.
	SuiteDefinitionId *string `locationName:"suiteDefinitionId" min:"12" type:"string"`

	// Suite definition version of the suite definition.
	SuiteDefinitionVersion *string `locationName:"suiteDefinitionVersion" min:"2" type:"string"`

	// Tags attached to the suite definition.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteDefinitionOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *GetSuiteDefinitionOutput) SetCreatedAt(v time.Time) *GetSuiteDefinitionOutput {
	s.CreatedAt = &v
	return s
}

// SetLastModifiedAt sets the LastModifiedAt field's value.
func (s *GetSuiteDefinitionOutput) SetLastModifiedAt(v time.Time) *GetSuiteDefinitionOutput {
	s.LastModifiedAt = &v
	return s
}

// SetLatestVersion sets the LatestVersion field's value.
func (s *GetSuiteDefinitionOutput) SetLatestVersion(v string) *GetSuiteDefinitionOutput {
	s.LatestVersion = &v
	return s
}

// SetSuiteDefinitionArn sets the SuiteDefinitionArn field's value.
func (s *GetSuiteDefinitionOutput) SetSuiteDefinitionArn(v string) *GetSuiteDefinitionOutput {
	s.SuiteDefinitionArn = &v
	return s
}

// SetSuiteDefinitionConfiguration sets the SuiteDefinitionConfiguration field's value.
func (s *GetSuiteDefinitionOutput) SetSuiteDefinitionConfiguration(v *SuiteDefinitionConfiguration) *GetSuiteDefinitionOutput {
	s.SuiteDefinitionConfiguration = v
	return s
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *GetSuiteDefinitionOutput) SetSuiteDefinitionId(v string) *GetSuiteDefinitionOutput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionVersion sets the SuiteDefinitionVersion field's value.
func (s *GetSuiteDefinitionOutput) SetSuiteDefinitionVersion(v string) *GetSuiteDefinitionOutput {
	s.SuiteDefinitionVersion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSuiteDefinitionOutput) SetTags(v map[string]*string) *GetSuiteDefinitionOutput {
	s.Tags = v
	return s
}

type GetSuiteRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Suite definition Id for the test suite run.
	//
	// SuiteDefinitionId is a required field
	SuiteDefinitionId *string `location:"uri" locationName:"suiteDefinitionId" min:"12" type:"string" required:"true"`

	// Suite run Id for the test suite run.
	//
	// SuiteRunId is a required field
	SuiteRunId *string `location:"uri" locationName:"suiteRunId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSuiteRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSuiteRunInput"}
	if s.SuiteDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteDefinitionId"))
	}
	if s.SuiteDefinitionId != nil && len(*s.SuiteDefinitionId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionId", 12))
	}
	if s.SuiteRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteRunId"))
	}
	if s.SuiteRunId != nil && len(*s.SuiteRunId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteRunId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *GetSuiteRunInput) SetSuiteDefinitionId(v string) *GetSuiteRunInput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteRunId sets the SuiteRunId field's value.
func (s *GetSuiteRunInput) SetSuiteRunId(v string) *GetSuiteRunInput {
	s.SuiteRunId = &v
	return s
}

type GetSuiteRunOutput struct {
	_ struct{} `type:"structure"`

	// Date (in Unix epoch time) when the test suite run ended.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Error reason for any test suite run failure.
	ErrorReason *string `locationName:"errorReason" type:"string"`

	// Date (in Unix epoch time) when the test suite run was started.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Status for the test suite run.
	Status *string `locationName:"status" type:"string" enum:"SuiteRunStatus"`

	// Suite definition Id for the test suite run.
	SuiteDefinitionId *string `locationName:"suiteDefinitionId" min:"12" type:"string"`

	// Suite definition version for the test suite run.
	SuiteDefinitionVersion *string `locationName:"suiteDefinitionVersion" min:"2" type:"string"`

	// The ARN of the suite run.
	SuiteRunArn *string `locationName:"suiteRunArn" min:"20" type:"string"`

	// Suite run configuration for the test suite run.
	SuiteRunConfiguration *SuiteRunConfiguration `locationName:"suiteRunConfiguration" type:"structure"`

	// Suite run Id for the test suite run.
	SuiteRunId *string `locationName:"suiteRunId" min:"12" type:"string"`

	// The tags attached to the suite run.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Test results for the test suite run.
	TestResult *TestResult `locationName:"testResult" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteRunOutput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *GetSuiteRunOutput) SetEndTime(v time.Time) *GetSuiteRunOutput {
	s.EndTime = &v
	return s
}

// SetErrorReason sets the ErrorReason field's value.
func (s *GetSuiteRunOutput) SetErrorReason(v string) *GetSuiteRunOutput {
	s.ErrorReason = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *GetSuiteRunOutput) SetStartTime(v time.Time) *GetSuiteRunOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetSuiteRunOutput) SetStatus(v string) *GetSuiteRunOutput {
	s.Status = &v
	return s
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *GetSuiteRunOutput) SetSuiteDefinitionId(v string) *GetSuiteRunOutput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionVersion sets the SuiteDefinitionVersion field's value.
func (s *GetSuiteRunOutput) SetSuiteDefinitionVersion(v string) *GetSuiteRunOutput {
	s.SuiteDefinitionVersion = &v
	return s
}

// SetSuiteRunArn sets the SuiteRunArn field's value.
func (s *GetSuiteRunOutput) SetSuiteRunArn(v string) *GetSuiteRunOutput {
	s.SuiteRunArn = &v
	return s
}

// SetSuiteRunConfiguration sets the SuiteRunConfiguration field's value.
func (s *GetSuiteRunOutput) SetSuiteRunConfiguration(v *SuiteRunConfiguration) *GetSuiteRunOutput {
	s.SuiteRunConfiguration = v
	return s
}

// SetSuiteRunId sets the SuiteRunId field's value.
func (s *GetSuiteRunOutput) SetSuiteRunId(v string) *GetSuiteRunOutput {
	s.SuiteRunId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetSuiteRunOutput) SetTags(v map[string]*string) *GetSuiteRunOutput {
	s.Tags = v
	return s
}

// SetTestResult sets the TestResult field's value.
func (s *GetSuiteRunOutput) SetTestResult(v *TestResult) *GetSuiteRunOutput {
	s.TestResult = v
	return s
}

type GetSuiteRunReportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Suite definition Id of the test suite.
	//
	// SuiteDefinitionId is a required field
	SuiteDefinitionId *string `location:"uri" locationName:"suiteDefinitionId" min:"12" type:"string" required:"true"`

	// Suite run Id of the test suite run.
	//
	// SuiteRunId is a required field
	SuiteRunId *string `location:"uri" locationName:"suiteRunId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteRunReportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteRunReportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSuiteRunReportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSuiteRunReportInput"}
	if s.SuiteDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteDefinitionId"))
	}
	if s.SuiteDefinitionId != nil && len(*s.SuiteDefinitionId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionId", 12))
	}
	if s.SuiteRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteRunId"))
	}
	if s.SuiteRunId != nil && len(*s.SuiteRunId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteRunId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *GetSuiteRunReportInput) SetSuiteDefinitionId(v string) *GetSuiteRunReportInput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteRunId sets the SuiteRunId field's value.
func (s *GetSuiteRunReportInput) SetSuiteRunId(v string) *GetSuiteRunReportInput {
	s.SuiteRunId = &v
	return s
}

type GetSuiteRunReportOutput struct {
	_ struct{} `type:"structure"`

	// Download URL of the qualification report.
	QualificationReportDownloadUrl *string `locationName:"qualificationReportDownloadUrl" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteRunReportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSuiteRunReportOutput) GoString() string {
	return s.String()
}

// SetQualificationReportDownloadUrl sets the QualificationReportDownloadUrl field's value.
func (s *GetSuiteRunReportOutput) SetQualificationReportDownloadUrl(v string) *GetSuiteRunReportOutput {
	s.QualificationReportDownloadUrl = &v
	return s
}

// Show Group Result.
type GroupResult struct {
	_ struct{} `type:"structure"`

	// Group result Id.
	GroupId *string `locationName:"groupId" min:"12" type:"string"`

	// Group Result Name.
	GroupName *string `locationName:"groupName" type:"string"`

	// Tests under Group Result.
	Tests []*TestCaseRun `locationName:"tests" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GroupResult) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *GroupResult) SetGroupId(v string) *GroupResult {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *GroupResult) SetGroupName(v string) *GroupResult {
	s.GroupName = &v
	return s
}

// SetTests sets the Tests field's value.
func (s *GroupResult) SetTests(v []*TestCaseRun) *GroupResult {
	s.Tests = v
	return s
}

// Sends Internal Failure Exception.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Sends Internal Failure Exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListSuiteDefinitionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return at once.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token used to get the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuiteDefinitionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuiteDefinitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSuiteDefinitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSuiteDefinitionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSuiteDefinitionsInput) SetMaxResults(v int64) *ListSuiteDefinitionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuiteDefinitionsInput) SetNextToken(v string) *ListSuiteDefinitionsInput {
	s.NextToken = &v
	return s
}

type ListSuiteDefinitionsOutput struct {
	_ struct{} `type:"structure"`

	// A token used to get the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that provide summaries of information about the suite
	// definitions in the list.
	SuiteDefinitionInformationList []*SuiteDefinitionInformation `locationName:"suiteDefinitionInformationList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuiteDefinitionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuiteDefinitionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuiteDefinitionsOutput) SetNextToken(v string) *ListSuiteDefinitionsOutput {
	s.NextToken = &v
	return s
}

// SetSuiteDefinitionInformationList sets the SuiteDefinitionInformationList field's value.
func (s *ListSuiteDefinitionsOutput) SetSuiteDefinitionInformationList(v []*SuiteDefinitionInformation) *ListSuiteDefinitionsOutput {
	s.SuiteDefinitionInformationList = v
	return s
}

type ListSuiteRunsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return at once.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// A token to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Lists the test suite runs of the specified test suite based on suite definition
	// Id.
	SuiteDefinitionId *string `location:"querystring" locationName:"suiteDefinitionId" min:"12" type:"string"`

	// Must be passed along with suiteDefinitionId. Lists the test suite runs of
	// the specified test suite based on suite definition version.
	SuiteDefinitionVersion *string `location:"querystring" locationName:"suiteDefinitionVersion" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuiteRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuiteRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSuiteRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSuiteRunsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.SuiteDefinitionId != nil && len(*s.SuiteDefinitionId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionId", 12))
	}
	if s.SuiteDefinitionVersion != nil && len(*s.SuiteDefinitionVersion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionVersion", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSuiteRunsInput) SetMaxResults(v int64) *ListSuiteRunsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuiteRunsInput) SetNextToken(v string) *ListSuiteRunsInput {
	s.NextToken = &v
	return s
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *ListSuiteRunsInput) SetSuiteDefinitionId(v string) *ListSuiteRunsInput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionVersion sets the SuiteDefinitionVersion field's value.
func (s *ListSuiteRunsInput) SetSuiteDefinitionVersion(v string) *ListSuiteRunsInput {
	s.SuiteDefinitionVersion = &v
	return s
}

type ListSuiteRunsOutput struct {
	_ struct{} `type:"structure"`

	// A token to retrieve the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// An array of objects that provide summaries of information about the suite
	// runs in the list.
	SuiteRunsList []*SuiteRunInformation `locationName:"suiteRunsList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuiteRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSuiteRunsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSuiteRunsOutput) SetNextToken(v string) *ListSuiteRunsOutput {
	s.NextToken = &v
	return s
}

// SetSuiteRunsList sets the SuiteRunsList field's value.
func (s *ListSuiteRunsOutput) SetSuiteRunsList(v []*SuiteRunInformation) *ListSuiteRunsOutput {
	s.SuiteRunsList = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the IoT Device Advisor resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags attached to the IoT Device Advisor resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Sends Resource Not Found Exception.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Sends Resource Not Found Exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartSuiteRunInput struct {
	_ struct{} `type:"structure"`

	// Suite definition Id of the test suite.
	//
	// SuiteDefinitionId is a required field
	SuiteDefinitionId *string `location:"uri" locationName:"suiteDefinitionId" min:"12" type:"string" required:"true"`

	// Suite definition version of the test suite.
	SuiteDefinitionVersion *string `locationName:"suiteDefinitionVersion" min:"2" type:"string"`

	// Suite run configuration.
	SuiteRunConfiguration *SuiteRunConfiguration `locationName:"suiteRunConfiguration" type:"structure"`

	// The tags to be attached to the suite run.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSuiteRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSuiteRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSuiteRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSuiteRunInput"}
	if s.SuiteDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteDefinitionId"))
	}
	if s.SuiteDefinitionId != nil && len(*s.SuiteDefinitionId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionId", 12))
	}
	if s.SuiteDefinitionVersion != nil && len(*s.SuiteDefinitionVersion) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionVersion", 2))
	}
	if s.SuiteRunConfiguration != nil {
		if err := s.SuiteRunConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SuiteRunConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *StartSuiteRunInput) SetSuiteDefinitionId(v string) *StartSuiteRunInput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionVersion sets the SuiteDefinitionVersion field's value.
func (s *StartSuiteRunInput) SetSuiteDefinitionVersion(v string) *StartSuiteRunInput {
	s.SuiteDefinitionVersion = &v
	return s
}

// SetSuiteRunConfiguration sets the SuiteRunConfiguration field's value.
func (s *StartSuiteRunInput) SetSuiteRunConfiguration(v *SuiteRunConfiguration) *StartSuiteRunInput {
	s.SuiteRunConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartSuiteRunInput) SetTags(v map[string]*string) *StartSuiteRunInput {
	s.Tags = v
	return s
}

type StartSuiteRunOutput struct {
	_ struct{} `type:"structure"`

	// Date (in Unix epoch time) when the suite run was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Amazon resource name of the started suite run.
	SuiteRunArn *string `locationName:"suiteRunArn" min:"20" type:"string"`

	// Suite Run Id of the started suite run.
	SuiteRunId *string `locationName:"suiteRunId" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSuiteRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartSuiteRunOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StartSuiteRunOutput) SetCreatedAt(v time.Time) *StartSuiteRunOutput {
	s.CreatedAt = &v
	return s
}

// SetSuiteRunArn sets the SuiteRunArn field's value.
func (s *StartSuiteRunOutput) SetSuiteRunArn(v string) *StartSuiteRunOutput {
	s.SuiteRunArn = &v
	return s
}

// SetSuiteRunId sets the SuiteRunId field's value.
func (s *StartSuiteRunOutput) SetSuiteRunId(v string) *StartSuiteRunOutput {
	s.SuiteRunId = &v
	return s
}

type StopSuiteRunInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Suite definition Id of the test suite run to be stopped.
	//
	// SuiteDefinitionId is a required field
	SuiteDefinitionId *string `location:"uri" locationName:"suiteDefinitionId" min:"12" type:"string" required:"true"`

	// Suite run Id of the test suite run to be stopped.
	//
	// SuiteRunId is a required field
	SuiteRunId *string `location:"uri" locationName:"suiteRunId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSuiteRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSuiteRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopSuiteRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopSuiteRunInput"}
	if s.SuiteDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteDefinitionId"))
	}
	if s.SuiteDefinitionId != nil && len(*s.SuiteDefinitionId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionId", 12))
	}
	if s.SuiteRunId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteRunId"))
	}
	if s.SuiteRunId != nil && len(*s.SuiteRunId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteRunId", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *StopSuiteRunInput) SetSuiteDefinitionId(v string) *StopSuiteRunInput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteRunId sets the SuiteRunId field's value.
func (s *StopSuiteRunInput) SetSuiteRunId(v string) *StopSuiteRunInput {
	s.SuiteRunId = &v
	return s
}

type StopSuiteRunOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSuiteRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopSuiteRunOutput) GoString() string {
	return s.String()
}

// Gets Suite Definition Configuration.
type SuiteDefinitionConfiguration struct {
	_ struct{} `type:"structure"`

	// Gets device permission arn.
	DevicePermissionRoleArn *string `locationName:"devicePermissionRoleArn" min:"20" type:"string"`

	// Gets the devices configured.
	Devices []*DeviceUnderTest `locationName:"devices" type:"list"`

	// Gets the tests intended for qualification in a suite.
	IntendedForQualification *bool `locationName:"intendedForQualification" type:"boolean"`

	// Gets test suite root group.
	RootGroup *string `locationName:"rootGroup" min:"1" type:"string"`

	// Gets Suite Definition Configuration name.
	SuiteDefinitionName *string `locationName:"suiteDefinitionName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuiteDefinitionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuiteDefinitionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SuiteDefinitionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SuiteDefinitionConfiguration"}
	if s.DevicePermissionRoleArn != nil && len(*s.DevicePermissionRoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("DevicePermissionRoleArn", 20))
	}
	if s.RootGroup != nil && len(*s.RootGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RootGroup", 1))
	}
	if s.SuiteDefinitionName != nil && len(*s.SuiteDefinitionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionName", 1))
	}
	if s.Devices != nil {
		for i, v := range s.Devices {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Devices", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDevicePermissionRoleArn sets the DevicePermissionRoleArn field's value.
func (s *SuiteDefinitionConfiguration) SetDevicePermissionRoleArn(v string) *SuiteDefinitionConfiguration {
	s.DevicePermissionRoleArn = &v
	return s
}

// SetDevices sets the Devices field's value.
func (s *SuiteDefinitionConfiguration) SetDevices(v []*DeviceUnderTest) *SuiteDefinitionConfiguration {
	s.Devices = v
	return s
}

// SetIntendedForQualification sets the IntendedForQualification field's value.
func (s *SuiteDefinitionConfiguration) SetIntendedForQualification(v bool) *SuiteDefinitionConfiguration {
	s.IntendedForQualification = &v
	return s
}

// SetRootGroup sets the RootGroup field's value.
func (s *SuiteDefinitionConfiguration) SetRootGroup(v string) *SuiteDefinitionConfiguration {
	s.RootGroup = &v
	return s
}

// SetSuiteDefinitionName sets the SuiteDefinitionName field's value.
func (s *SuiteDefinitionConfiguration) SetSuiteDefinitionName(v string) *SuiteDefinitionConfiguration {
	s.SuiteDefinitionName = &v
	return s
}

// Information about the suite definition.
type SuiteDefinitionInformation struct {
	_ struct{} `type:"structure"`

	// Date (in Unix epoch time) when the test suite was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Specifies the devices under test for the test suite.
	DefaultDevices []*DeviceUnderTest `locationName:"defaultDevices" type:"list"`

	// Specifies if the test suite is intended for qualification.
	IntendedForQualification *bool `locationName:"intendedForQualification" type:"boolean"`

	// Suite definition Id of the test suite.
	SuiteDefinitionId *string `locationName:"suiteDefinitionId" min:"12" type:"string"`

	// Suite name of the test suite.
	SuiteDefinitionName *string `locationName:"suiteDefinitionName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuiteDefinitionInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuiteDefinitionInformation) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SuiteDefinitionInformation) SetCreatedAt(v time.Time) *SuiteDefinitionInformation {
	s.CreatedAt = &v
	return s
}

// SetDefaultDevices sets the DefaultDevices field's value.
func (s *SuiteDefinitionInformation) SetDefaultDevices(v []*DeviceUnderTest) *SuiteDefinitionInformation {
	s.DefaultDevices = v
	return s
}

// SetIntendedForQualification sets the IntendedForQualification field's value.
func (s *SuiteDefinitionInformation) SetIntendedForQualification(v bool) *SuiteDefinitionInformation {
	s.IntendedForQualification = &v
	return s
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *SuiteDefinitionInformation) SetSuiteDefinitionId(v string) *SuiteDefinitionInformation {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionName sets the SuiteDefinitionName field's value.
func (s *SuiteDefinitionInformation) SetSuiteDefinitionName(v string) *SuiteDefinitionInformation {
	s.SuiteDefinitionName = &v
	return s
}

// Gets suite run configuration.
type SuiteRunConfiguration struct {
	_ struct{} `type:"structure"`

	// Gets the primary device for suite run.
	PrimaryDevice *DeviceUnderTest `locationName:"primaryDevice" type:"structure"`

	// Gets test case list.
	SelectedTestList []*string `locationName:"selectedTestList" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuiteRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuiteRunConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SuiteRunConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SuiteRunConfiguration"}
	if s.PrimaryDevice != nil {
		if err := s.PrimaryDevice.Validate(); err != nil {
			invalidParams.AddNested("PrimaryDevice", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPrimaryDevice sets the PrimaryDevice field's value.
func (s *SuiteRunConfiguration) SetPrimaryDevice(v *DeviceUnderTest) *SuiteRunConfiguration {
	s.PrimaryDevice = v
	return s
}

// SetSelectedTestList sets the SelectedTestList field's value.
func (s *SuiteRunConfiguration) SetSelectedTestList(v []*string) *SuiteRunConfiguration {
	s.SelectedTestList = v
	return s
}

// Information about the suite run.
type SuiteRunInformation struct {
	_ struct{} `type:"structure"`

	// Date (in Unix epoch time) when the suite run was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Date (in Unix epoch time) when the suite run ended.
	EndAt *time.Time `locationName:"endAt" type:"timestamp"`

	// Number of test cases that failed in the suite run.
	Failed *int64 `locationName:"failed" type:"integer"`

	// Number of test cases that passed in the suite run.
	Passed *int64 `locationName:"passed" type:"integer"`

	// Date (in Unix epoch time) when the suite run was started.
	StartedAt *time.Time `locationName:"startedAt" type:"timestamp"`

	// Status of the suite run.
	Status *string `locationName:"status" type:"string" enum:"SuiteRunStatus"`

	// Suite definition Id of the suite run.
	SuiteDefinitionId *string `locationName:"suiteDefinitionId" min:"12" type:"string"`

	// Suite definition name of the suite run.
	SuiteDefinitionName *string `locationName:"suiteDefinitionName" min:"1" type:"string"`

	// Suite definition version of the suite run.
	SuiteDefinitionVersion *string `locationName:"suiteDefinitionVersion" min:"2" type:"string"`

	// Suite run Id of the suite run.
	SuiteRunId *string `locationName:"suiteRunId" min:"12" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuiteRunInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SuiteRunInformation) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SuiteRunInformation) SetCreatedAt(v time.Time) *SuiteRunInformation {
	s.CreatedAt = &v
	return s
}

// SetEndAt sets the EndAt field's value.
func (s *SuiteRunInformation) SetEndAt(v time.Time) *SuiteRunInformation {
	s.EndAt = &v
	return s
}

// SetFailed sets the Failed field's value.
func (s *SuiteRunInformation) SetFailed(v int64) *SuiteRunInformation {
	s.Failed = &v
	return s
}

// SetPassed sets the Passed field's value.
func (s *SuiteRunInformation) SetPassed(v int64) *SuiteRunInformation {
	s.Passed = &v
	return s
}

// SetStartedAt sets the StartedAt field's value.
func (s *SuiteRunInformation) SetStartedAt(v time.Time) *SuiteRunInformation {
	s.StartedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SuiteRunInformation) SetStatus(v string) *SuiteRunInformation {
	s.Status = &v
	return s
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *SuiteRunInformation) SetSuiteDefinitionId(v string) *SuiteRunInformation {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionName sets the SuiteDefinitionName field's value.
func (s *SuiteRunInformation) SetSuiteDefinitionName(v string) *SuiteRunInformation {
	s.SuiteDefinitionName = &v
	return s
}

// SetSuiteDefinitionVersion sets the SuiteDefinitionVersion field's value.
func (s *SuiteRunInformation) SetSuiteDefinitionVersion(v string) *SuiteRunInformation {
	s.SuiteDefinitionVersion = &v
	return s
}

// SetSuiteRunId sets the SuiteRunId field's value.
func (s *SuiteRunInformation) SetSuiteRunId(v string) *SuiteRunInformation {
	s.SuiteRunId = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The resource ARN of an IoT Device Advisor resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// The tags to be attached to the IoT Device Advisor resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Provides test case run.
type TestCaseRun struct {
	_ struct{} `type:"structure"`

	// Provides test case run end time.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// Provides test case run failure result.
	Failure *string `locationName:"failure" type:"string"`

	// Provides test case run log Url.
	LogUrl *string `locationName:"logUrl" type:"string"`

	// Provides test case run start time.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// Provides test case run status.
	Status *string `locationName:"status" type:"string" enum:"Status"`

	// Provides test case run definition Id.
	TestCaseDefinitionId *string `locationName:"testCaseDefinitionId" min:"12" type:"string"`

	// Provides test case run definition Name.
	TestCaseDefinitionName *string `locationName:"testCaseDefinitionName" type:"string"`

	// Provides test case run Id.
	TestCaseRunId *string `locationName:"testCaseRunId" min:"12" type:"string"`

	// Provides test case run warnings.
	Warnings *string `locationName:"warnings" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCaseRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestCaseRun) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TestCaseRun) SetEndTime(v time.Time) *TestCaseRun {
	s.EndTime = &v
	return s
}

// SetFailure sets the Failure field's value.
func (s *TestCaseRun) SetFailure(v string) *TestCaseRun {
	s.Failure = &v
	return s
}

// SetLogUrl sets the LogUrl field's value.
func (s *TestCaseRun) SetLogUrl(v string) *TestCaseRun {
	s.LogUrl = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TestCaseRun) SetStartTime(v time.Time) *TestCaseRun {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestCaseRun) SetStatus(v string) *TestCaseRun {
	s.Status = &v
	return s
}

// SetTestCaseDefinitionId sets the TestCaseDefinitionId field's value.
func (s *TestCaseRun) SetTestCaseDefinitionId(v string) *TestCaseRun {
	s.TestCaseDefinitionId = &v
	return s
}

// SetTestCaseDefinitionName sets the TestCaseDefinitionName field's value.
func (s *TestCaseRun) SetTestCaseDefinitionName(v string) *TestCaseRun {
	s.TestCaseDefinitionName = &v
	return s
}

// SetTestCaseRunId sets the TestCaseRunId field's value.
func (s *TestCaseRun) SetTestCaseRunId(v string) *TestCaseRun {
	s.TestCaseRunId = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *TestCaseRun) SetWarnings(v string) *TestCaseRun {
	s.Warnings = &v
	return s
}

// Show each group result.
type TestResult struct {
	_ struct{} `type:"structure"`

	// Show each group of test results.
	Groups []*GroupResult `locationName:"groups" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestResult) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *TestResult) SetGroups(v []*GroupResult) *TestResult {
	s.Groups = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The resource ARN of an IoT Device Advisor resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"20" type:"string" required:"true"`

	// List of tag keys to remove from the IoT Device Advisor resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 20))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateSuiteDefinitionInput struct {
	_ struct{} `type:"structure"`

	// Updates a Device Advisor test suite with suite definition configuration.
	SuiteDefinitionConfiguration *SuiteDefinitionConfiguration `locationName:"suiteDefinitionConfiguration" type:"structure"`

	// Suite definition Id of the test suite to be updated.
	//
	// SuiteDefinitionId is a required field
	SuiteDefinitionId *string `location:"uri" locationName:"suiteDefinitionId" min:"12" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSuiteDefinitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSuiteDefinitionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSuiteDefinitionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSuiteDefinitionInput"}
	if s.SuiteDefinitionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SuiteDefinitionId"))
	}
	if s.SuiteDefinitionId != nil && len(*s.SuiteDefinitionId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("SuiteDefinitionId", 12))
	}
	if s.SuiteDefinitionConfiguration != nil {
		if err := s.SuiteDefinitionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SuiteDefinitionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSuiteDefinitionConfiguration sets the SuiteDefinitionConfiguration field's value.
func (s *UpdateSuiteDefinitionInput) SetSuiteDefinitionConfiguration(v *SuiteDefinitionConfiguration) *UpdateSuiteDefinitionInput {
	s.SuiteDefinitionConfiguration = v
	return s
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *UpdateSuiteDefinitionInput) SetSuiteDefinitionId(v string) *UpdateSuiteDefinitionInput {
	s.SuiteDefinitionId = &v
	return s
}

type UpdateSuiteDefinitionOutput struct {
	_ struct{} `type:"structure"`

	// Timestamp of when the test suite was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Timestamp of when the test suite was updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// Amazon Resource name of the updated test suite.
	SuiteDefinitionArn *string `locationName:"suiteDefinitionArn" min:"20" type:"string"`

	// Suite definition Id of the updated test suite.
	SuiteDefinitionId *string `locationName:"suiteDefinitionId" min:"12" type:"string"`

	// Suite definition name of the updated test suite.
	SuiteDefinitionName *string `locationName:"suiteDefinitionName" min:"1" type:"string"`

	// Suite definition version of the updated test suite.
	SuiteDefinitionVersion *string `locationName:"suiteDefinitionVersion" min:"2" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSuiteDefinitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSuiteDefinitionOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateSuiteDefinitionOutput) SetCreatedAt(v time.Time) *UpdateSuiteDefinitionOutput {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *UpdateSuiteDefinitionOutput) SetLastUpdatedAt(v time.Time) *UpdateSuiteDefinitionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetSuiteDefinitionArn sets the SuiteDefinitionArn field's value.
func (s *UpdateSuiteDefinitionOutput) SetSuiteDefinitionArn(v string) *UpdateSuiteDefinitionOutput {
	s.SuiteDefinitionArn = &v
	return s
}

// SetSuiteDefinitionId sets the SuiteDefinitionId field's value.
func (s *UpdateSuiteDefinitionOutput) SetSuiteDefinitionId(v string) *UpdateSuiteDefinitionOutput {
	s.SuiteDefinitionId = &v
	return s
}

// SetSuiteDefinitionName sets the SuiteDefinitionName field's value.
func (s *UpdateSuiteDefinitionOutput) SetSuiteDefinitionName(v string) *UpdateSuiteDefinitionOutput {
	s.SuiteDefinitionName = &v
	return s
}

// SetSuiteDefinitionVersion sets the SuiteDefinitionVersion field's value.
func (s *UpdateSuiteDefinitionOutput) SetSuiteDefinitionVersion(v string) *UpdateSuiteDefinitionOutput {
	s.SuiteDefinitionVersion = &v
	return s
}

// Sends invalid request exception.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Sends invalid request exception message.
	Message_ *string `locationName:"message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// StatusPass is a Status enum value
	StatusPass = "PASS"

	// StatusFail is a Status enum value
	StatusFail = "FAIL"

	// StatusCanceled is a Status enum value
	StatusCanceled = "CANCELED"

	// StatusPending is a Status enum value
	StatusPending = "PENDING"

	// StatusRunning is a Status enum value
	StatusRunning = "RUNNING"

	// StatusStopping is a Status enum value
	StatusStopping = "STOPPING"

	// StatusStopped is a Status enum value
	StatusStopped = "STOPPED"

	// StatusPassWithWarnings is a Status enum value
	StatusPassWithWarnings = "PASS_WITH_WARNINGS"

	// StatusError is a Status enum value
	StatusError = "ERROR"
)

// Status_Values returns all elements of the Status enum
func Status_Values() []string {
	return []string{
		StatusPass,
		StatusFail,
		StatusCanceled,
		StatusPending,
		StatusRunning,
		StatusStopping,
		StatusStopped,
		StatusPassWithWarnings,
		StatusError,
	}
}

const (
	// SuiteRunStatusPass is a SuiteRunStatus enum value
	SuiteRunStatusPass = "PASS"

	// SuiteRunStatusFail is a SuiteRunStatus enum value
	SuiteRunStatusFail = "FAIL"

	// SuiteRunStatusCanceled is a SuiteRunStatus enum value
	SuiteRunStatusCanceled = "CANCELED"

	// SuiteRunStatusPending is a SuiteRunStatus enum value
	SuiteRunStatusPending = "PENDING"

	// SuiteRunStatusRunning is a SuiteRunStatus enum value
	SuiteRunStatusRunning = "RUNNING"

	// SuiteRunStatusStopping is a SuiteRunStatus enum value
	SuiteRunStatusStopping = "STOPPING"

	// SuiteRunStatusStopped is a SuiteRunStatus enum value
	SuiteRunStatusStopped = "STOPPED"

	// SuiteRunStatusPassWithWarnings is a SuiteRunStatus enum value
	SuiteRunStatusPassWithWarnings = "PASS_WITH_WARNINGS"

	// SuiteRunStatusError is a SuiteRunStatus enum value
	SuiteRunStatusError = "ERROR"
)

// SuiteRunStatus_Values returns all elements of the SuiteRunStatus enum
func SuiteRunStatus_Values() []string {
	return []string{
		SuiteRunStatusPass,
		SuiteRunStatusFail,
		SuiteRunStatusCanceled,
		SuiteRunStatusPending,
		SuiteRunStatusRunning,
		SuiteRunStatusStopping,
		SuiteRunStatusStopped,
		SuiteRunStatusPassWithWarnings,
		SuiteRunStatusError,
	}
}
