// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dax

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateClusterRequest method.
//    req, resp := client.CreateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateCluster
func (c *DAX) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon DynamoDB Accelerator (DAX).
//
// Creates a DAX cluster. All nodes in the cluster run the same DAX caching
// software.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation CreateCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterAlreadyExistsFault "ClusterAlreadyExistsFault"
//   You already have a DAX cluster with the given identifier.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeInsufficientClusterCapacityFault "InsufficientClusterCapacityFault"
//   There are not enough system resources to create the cluster you requested
//   (or to resize an already-existing cluster).
//
//   * ErrCodeSubnetGroupNotFoundFault "SubnetGroupNotFoundFault"
//   The requested subnet group name does not refer to an existing subnet group.
//
//   * ErrCodeInvalidParameterGroupStateFault "InvalidParameterGroupStateFault"
//   One or more parameters in a parameter group are in an invalid state.
//
//   * ErrCodeParameterGroupNotFoundFault "ParameterGroupNotFoundFault"
//   The specified parameter group does not exist.
//
//   * ErrCodeClusterQuotaForCustomerExceededFault "ClusterQuotaForCustomerExceededFault"
//   You have attempted to exceed the maximum number of DAX clusters for your
//   AWS account.
//
//   * ErrCodeNodeQuotaForClusterExceededFault "NodeQuotaForClusterExceededFault"
//   You have attempted to exceed the maximum number of nodes for a DAX cluster.
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceededFault"
//   You have attempted to exceed the maximum number of nodes for your AWS account.
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeTagQuotaPerResourceExceeded "TagQuotaPerResourceExceeded"
//   You have exceeded the maximum number of tags for this DAX cluster.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateCluster
func (c *DAX) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateParameterGroup = "CreateParameterGroup"

// CreateParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParameterGroup for more information on using the CreateParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateParameterGroupRequest method.
//    req, resp := client.CreateParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateParameterGroup
func (c *DAX) CreateParameterGroupRequest(input *CreateParameterGroupInput) (req *request.Request, output *CreateParameterGroupOutput) {
	op := &request.Operation{
		Name:       opCreateParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateParameterGroupInput{}
	}

	output = &CreateParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParameterGroup API operation for Amazon DynamoDB Accelerator (DAX).
//
// Creates a new parameter group. A parameter group is a collection of parameters
// that you apply to all of the nodes in a DAX cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation CreateParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeParameterGroupQuotaExceededFault "ParameterGroupQuotaExceededFault"
//   You have attempted to exceed the maximum number of parameter groups.
//
//   * ErrCodeParameterGroupAlreadyExistsFault "ParameterGroupAlreadyExistsFault"
//   The specified parameter group already exists.
//
//   * ErrCodeInvalidParameterGroupStateFault "InvalidParameterGroupStateFault"
//   One or more parameters in a parameter group are in an invalid state.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateParameterGroup
func (c *DAX) CreateParameterGroup(input *CreateParameterGroupInput) (*CreateParameterGroupOutput, error) {
	req, out := c.CreateParameterGroupRequest(input)
	return out, req.Send()
}

// CreateParameterGroupWithContext is the same as CreateParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) CreateParameterGroupWithContext(ctx aws.Context, input *CreateParameterGroupInput, opts ...request.Option) (*CreateParameterGroupOutput, error) {
	req, out := c.CreateParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSubnetGroup = "CreateSubnetGroup"

// CreateSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSubnetGroup for more information on using the CreateSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSubnetGroupRequest method.
//    req, resp := client.CreateSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateSubnetGroup
func (c *DAX) CreateSubnetGroupRequest(input *CreateSubnetGroupInput) (req *request.Request, output *CreateSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSubnetGroupInput{}
	}

	output = &CreateSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSubnetGroup API operation for Amazon DynamoDB Accelerator (DAX).
//
// Creates a new subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation CreateSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubnetGroupAlreadyExistsFault "SubnetGroupAlreadyExistsFault"
//   The specified subnet group already exists.
//
//   * ErrCodeSubnetGroupQuotaExceededFault "SubnetGroupQuotaExceededFault"
//   The request cannot be processed because it would exceed the allowed number
//   of subnets in a subnet group.
//
//   * ErrCodeSubnetQuotaExceededFault "SubnetQuotaExceededFault"
//   The request cannot be processed because it would exceed the allowed number
//   of subnets in a subnet group.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   An invalid subnet identifier was specified.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/CreateSubnetGroup
func (c *DAX) CreateSubnetGroup(input *CreateSubnetGroupInput) (*CreateSubnetGroupOutput, error) {
	req, out := c.CreateSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateSubnetGroupWithContext is the same as CreateSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) CreateSubnetGroupWithContext(ctx aws.Context, input *CreateSubnetGroupInput, opts ...request.Option) (*CreateSubnetGroupOutput, error) {
	req, out := c.CreateSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDecreaseReplicationFactor = "DecreaseReplicationFactor"

// DecreaseReplicationFactorRequest generates a "aws/request.Request" representing the
// client's request for the DecreaseReplicationFactor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DecreaseReplicationFactor for more information on using the DecreaseReplicationFactor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DecreaseReplicationFactorRequest method.
//    req, resp := client.DecreaseReplicationFactorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DecreaseReplicationFactor
func (c *DAX) DecreaseReplicationFactorRequest(input *DecreaseReplicationFactorInput) (req *request.Request, output *DecreaseReplicationFactorOutput) {
	op := &request.Operation{
		Name:       opDecreaseReplicationFactor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecreaseReplicationFactorInput{}
	}

	output = &DecreaseReplicationFactorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DecreaseReplicationFactor API operation for Amazon DynamoDB Accelerator (DAX).
//
// Removes one or more nodes from a DAX cluster.
//
// You cannot use DecreaseReplicationFactor to remove the last node in a DAX
// cluster. If you need to do this, use DeleteCluster instead.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DecreaseReplicationFactor for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeNodeNotFoundFault "NodeNotFoundFault"
//   None of the nodes in the cluster have the given node ID.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DecreaseReplicationFactor
func (c *DAX) DecreaseReplicationFactor(input *DecreaseReplicationFactorInput) (*DecreaseReplicationFactorOutput, error) {
	req, out := c.DecreaseReplicationFactorRequest(input)
	return out, req.Send()
}

// DecreaseReplicationFactorWithContext is the same as DecreaseReplicationFactor with the addition of
// the ability to pass a context and additional request options.
//
// See DecreaseReplicationFactor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DecreaseReplicationFactorWithContext(ctx aws.Context, input *DecreaseReplicationFactorInput, opts ...request.Option) (*DecreaseReplicationFactorOutput, error) {
	req, out := c.DecreaseReplicationFactorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClusterRequest method.
//    req, resp := client.DeleteClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteCluster
func (c *DAX) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon DynamoDB Accelerator (DAX).
//
// Deletes a previously provisioned DAX cluster. DeleteCluster deletes all associated
// nodes, node endpoints and the DAX cluster itself. When you receive a successful
// response from this action, DAX immediately begins deleting the cluster; you
// cannot cancel or revert this action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DeleteCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteCluster
func (c *DAX) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteParameterGroup = "DeleteParameterGroup"

// DeleteParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteParameterGroup for more information on using the DeleteParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteParameterGroupRequest method.
//    req, resp := client.DeleteParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteParameterGroup
func (c *DAX) DeleteParameterGroupRequest(input *DeleteParameterGroupInput) (req *request.Request, output *DeleteParameterGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteParameterGroupInput{}
	}

	output = &DeleteParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteParameterGroup API operation for Amazon DynamoDB Accelerator (DAX).
//
// Deletes the specified parameter group. You cannot delete a parameter group
// if it is associated with any DAX clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DeleteParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterGroupStateFault "InvalidParameterGroupStateFault"
//   One or more parameters in a parameter group are in an invalid state.
//
//   * ErrCodeParameterGroupNotFoundFault "ParameterGroupNotFoundFault"
//   The specified parameter group does not exist.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteParameterGroup
func (c *DAX) DeleteParameterGroup(input *DeleteParameterGroupInput) (*DeleteParameterGroupOutput, error) {
	req, out := c.DeleteParameterGroupRequest(input)
	return out, req.Send()
}

// DeleteParameterGroupWithContext is the same as DeleteParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DeleteParameterGroupWithContext(ctx aws.Context, input *DeleteParameterGroupInput, opts ...request.Option) (*DeleteParameterGroupOutput, error) {
	req, out := c.DeleteParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSubnetGroup = "DeleteSubnetGroup"

// DeleteSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSubnetGroup for more information on using the DeleteSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSubnetGroupRequest method.
//    req, resp := client.DeleteSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteSubnetGroup
func (c *DAX) DeleteSubnetGroupRequest(input *DeleteSubnetGroupInput) (req *request.Request, output *DeleteSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSubnetGroupInput{}
	}

	output = &DeleteSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSubnetGroup API operation for Amazon DynamoDB Accelerator (DAX).
//
// Deletes a subnet group.
//
// You cannot delete a subnet group if it is associated with any DAX clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DeleteSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubnetGroupInUseFault "SubnetGroupInUseFault"
//   The specified subnet group is currently in use.
//
//   * ErrCodeSubnetGroupNotFoundFault "SubnetGroupNotFoundFault"
//   The requested subnet group name does not refer to an existing subnet group.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DeleteSubnetGroup
func (c *DAX) DeleteSubnetGroup(input *DeleteSubnetGroupInput) (*DeleteSubnetGroupOutput, error) {
	req, out := c.DeleteSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteSubnetGroupWithContext is the same as DeleteSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DeleteSubnetGroupWithContext(ctx aws.Context, input *DeleteSubnetGroupInput, opts ...request.Option) (*DeleteSubnetGroupOutput, error) {
	req, out := c.DeleteSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClusters = "DescribeClusters"

// DescribeClustersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClusters for more information on using the DescribeClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClustersRequest method.
//    req, resp := client.DescribeClustersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeClusters
func (c *DAX) DescribeClustersRequest(input *DescribeClustersInput) (req *request.Request, output *DescribeClustersOutput) {
	op := &request.Operation{
		Name:       opDescribeClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClustersInput{}
	}

	output = &DescribeClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClusters API operation for Amazon DynamoDB Accelerator (DAX).
//
// Returns information about all provisioned DAX clusters if no cluster identifier
// is specified, or about a specific DAX cluster if a cluster identifier is
// supplied.
//
// If the cluster is in the CREATING state, only cluster level information will
// be displayed until all of the nodes are successfully provisioned.
//
// If the cluster is in the DELETING state, only cluster level information will
// be displayed.
//
// If nodes are currently being added to the DAX cluster, node endpoint information
// and creation time for the additional nodes will not be displayed until they
// are completely provisioned. When the DAX cluster state is available, the
// cluster is ready for use.
//
// If nodes are currently being removed from the DAX cluster, no endpoint information
// for the removed nodes is displayed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DescribeClusters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeClusters
func (c *DAX) DescribeClusters(input *DescribeClustersInput) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	return out, req.Send()
}

// DescribeClustersWithContext is the same as DescribeClusters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DescribeClustersWithContext(ctx aws.Context, input *DescribeClustersInput, opts ...request.Option) (*DescribeClustersOutput, error) {
	req, out := c.DescribeClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDefaultParameters = "DescribeDefaultParameters"

// DescribeDefaultParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDefaultParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDefaultParameters for more information on using the DescribeDefaultParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDefaultParametersRequest method.
//    req, resp := client.DescribeDefaultParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeDefaultParameters
func (c *DAX) DescribeDefaultParametersRequest(input *DescribeDefaultParametersInput) (req *request.Request, output *DescribeDefaultParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeDefaultParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDefaultParametersInput{}
	}

	output = &DescribeDefaultParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDefaultParameters API operation for Amazon DynamoDB Accelerator (DAX).
//
// Returns the default system parameter information for the DAX caching software.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DescribeDefaultParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeDefaultParameters
func (c *DAX) DescribeDefaultParameters(input *DescribeDefaultParametersInput) (*DescribeDefaultParametersOutput, error) {
	req, out := c.DescribeDefaultParametersRequest(input)
	return out, req.Send()
}

// DescribeDefaultParametersWithContext is the same as DescribeDefaultParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDefaultParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DescribeDefaultParametersWithContext(ctx aws.Context, input *DescribeDefaultParametersInput, opts ...request.Option) (*DescribeDefaultParametersOutput, error) {
	req, out := c.DescribeDefaultParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeEvents
func (c *DAX) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for Amazon DynamoDB Accelerator (DAX).
//
// Returns events related to DAX clusters and parameter groups. You can obtain
// events specific to a particular DAX cluster or parameter group by providing
// the name as a parameter.
//
// By default, only the events occurring within the last 24 hours are returned;
// however, you can retrieve up to 14 days' worth of events if necessary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DescribeEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeEvents
func (c *DAX) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeParameterGroups = "DescribeParameterGroups"

// DescribeParameterGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeParameterGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeParameterGroups for more information on using the DescribeParameterGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeParameterGroupsRequest method.
//    req, resp := client.DescribeParameterGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameterGroups
func (c *DAX) DescribeParameterGroupsRequest(input *DescribeParameterGroupsInput) (req *request.Request, output *DescribeParameterGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeParameterGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeParameterGroupsInput{}
	}

	output = &DescribeParameterGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeParameterGroups API operation for Amazon DynamoDB Accelerator (DAX).
//
// Returns a list of parameter group descriptions. If a parameter group name
// is specified, the list will contain only the descriptions for that group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DescribeParameterGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeParameterGroupNotFoundFault "ParameterGroupNotFoundFault"
//   The specified parameter group does not exist.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameterGroups
func (c *DAX) DescribeParameterGroups(input *DescribeParameterGroupsInput) (*DescribeParameterGroupsOutput, error) {
	req, out := c.DescribeParameterGroupsRequest(input)
	return out, req.Send()
}

// DescribeParameterGroupsWithContext is the same as DescribeParameterGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeParameterGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DescribeParameterGroupsWithContext(ctx aws.Context, input *DescribeParameterGroupsInput, opts ...request.Option) (*DescribeParameterGroupsOutput, error) {
	req, out := c.DescribeParameterGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeParameters = "DescribeParameters"

// DescribeParametersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeParameters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeParameters for more information on using the DescribeParameters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeParametersRequest method.
//    req, resp := client.DescribeParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameters
func (c *DAX) DescribeParametersRequest(input *DescribeParametersInput) (req *request.Request, output *DescribeParametersOutput) {
	op := &request.Operation{
		Name:       opDescribeParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeParametersInput{}
	}

	output = &DescribeParametersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeParameters API operation for Amazon DynamoDB Accelerator (DAX).
//
// Returns the detailed parameter list for a particular parameter group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DescribeParameters for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeParameterGroupNotFoundFault "ParameterGroupNotFoundFault"
//   The specified parameter group does not exist.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeParameters
func (c *DAX) DescribeParameters(input *DescribeParametersInput) (*DescribeParametersOutput, error) {
	req, out := c.DescribeParametersRequest(input)
	return out, req.Send()
}

// DescribeParametersWithContext is the same as DescribeParameters with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DescribeParametersWithContext(ctx aws.Context, input *DescribeParametersInput, opts ...request.Option) (*DescribeParametersOutput, error) {
	req, out := c.DescribeParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSubnetGroups = "DescribeSubnetGroups"

// DescribeSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSubnetGroups for more information on using the DescribeSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSubnetGroupsRequest method.
//    req, resp := client.DescribeSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeSubnetGroups
func (c *DAX) DescribeSubnetGroupsRequest(input *DescribeSubnetGroupsInput) (req *request.Request, output *DescribeSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSubnetGroupsInput{}
	}

	output = &DescribeSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSubnetGroups API operation for Amazon DynamoDB Accelerator (DAX).
//
// Returns a list of subnet group descriptions. If a subnet group name is specified,
// the list will contain only the description of that group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation DescribeSubnetGroups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubnetGroupNotFoundFault "SubnetGroupNotFoundFault"
//   The requested subnet group name does not refer to an existing subnet group.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/DescribeSubnetGroups
func (c *DAX) DescribeSubnetGroups(input *DescribeSubnetGroupsInput) (*DescribeSubnetGroupsOutput, error) {
	req, out := c.DescribeSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeSubnetGroupsWithContext is the same as DescribeSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) DescribeSubnetGroupsWithContext(ctx aws.Context, input *DescribeSubnetGroupsInput, opts ...request.Option) (*DescribeSubnetGroupsOutput, error) {
	req, out := c.DescribeSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opIncreaseReplicationFactor = "IncreaseReplicationFactor"

// IncreaseReplicationFactorRequest generates a "aws/request.Request" representing the
// client's request for the IncreaseReplicationFactor operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See IncreaseReplicationFactor for more information on using the IncreaseReplicationFactor
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the IncreaseReplicationFactorRequest method.
//    req, resp := client.IncreaseReplicationFactorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/IncreaseReplicationFactor
func (c *DAX) IncreaseReplicationFactorRequest(input *IncreaseReplicationFactorInput) (req *request.Request, output *IncreaseReplicationFactorOutput) {
	op := &request.Operation{
		Name:       opIncreaseReplicationFactor,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IncreaseReplicationFactorInput{}
	}

	output = &IncreaseReplicationFactorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// IncreaseReplicationFactor API operation for Amazon DynamoDB Accelerator (DAX).
//
// Adds one or more nodes to a DAX cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation IncreaseReplicationFactor for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeInsufficientClusterCapacityFault "InsufficientClusterCapacityFault"
//   There are not enough system resources to create the cluster you requested
//   (or to resize an already-existing cluster).
//
//   * ErrCodeInvalidVPCNetworkStateFault "InvalidVPCNetworkStateFault"
//   The VPC network is in an invalid state.
//
//   * ErrCodeNodeQuotaForClusterExceededFault "NodeQuotaForClusterExceededFault"
//   You have attempted to exceed the maximum number of nodes for a DAX cluster.
//
//   * ErrCodeNodeQuotaForCustomerExceededFault "NodeQuotaForCustomerExceededFault"
//   You have attempted to exceed the maximum number of nodes for your AWS account.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/IncreaseReplicationFactor
func (c *DAX) IncreaseReplicationFactor(input *IncreaseReplicationFactorInput) (*IncreaseReplicationFactorOutput, error) {
	req, out := c.IncreaseReplicationFactorRequest(input)
	return out, req.Send()
}

// IncreaseReplicationFactorWithContext is the same as IncreaseReplicationFactor with the addition of
// the ability to pass a context and additional request options.
//
// See IncreaseReplicationFactor for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) IncreaseReplicationFactorWithContext(ctx aws.Context, input *IncreaseReplicationFactorInput, opts ...request.Option) (*IncreaseReplicationFactorOutput, error) {
	req, out := c.IncreaseReplicationFactorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/ListTags
func (c *DAX) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon DynamoDB Accelerator (DAX).
//
// List all of the tags for a DAX cluster. You can call ListTags up to 10 times
// per second, per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation ListTags for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeInvalidARNFault "InvalidARNFault"
//   The Amazon Resource Name (ARN) supplied in the request is not valid.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/ListTags
func (c *DAX) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootNode = "RebootNode"

// RebootNodeRequest generates a "aws/request.Request" representing the
// client's request for the RebootNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootNode for more information on using the RebootNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootNodeRequest method.
//    req, resp := client.RebootNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/RebootNode
func (c *DAX) RebootNodeRequest(input *RebootNodeInput) (req *request.Request, output *RebootNodeOutput) {
	op := &request.Operation{
		Name:       opRebootNode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootNodeInput{}
	}

	output = &RebootNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootNode API operation for Amazon DynamoDB Accelerator (DAX).
//
// Reboots a single node of a DAX cluster. The reboot action takes place as
// soon as possible. During the reboot, the node status is set to REBOOTING.
//
// RebootNode restarts the DAX engine process and does not remove the contents
// of the cache.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation RebootNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeNodeNotFoundFault "NodeNotFoundFault"
//   None of the nodes in the cluster have the given node ID.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/RebootNode
func (c *DAX) RebootNode(input *RebootNodeInput) (*RebootNodeOutput, error) {
	req, out := c.RebootNodeRequest(input)
	return out, req.Send()
}

// RebootNodeWithContext is the same as RebootNode with the addition of
// the ability to pass a context and additional request options.
//
// See RebootNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) RebootNodeWithContext(ctx aws.Context, input *RebootNodeInput, opts ...request.Option) (*RebootNodeOutput, error) {
	req, out := c.RebootNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/TagResource
func (c *DAX) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TagResource API operation for Amazon DynamoDB Accelerator (DAX).
//
// Associates a set of tags with a DAX resource. You can call TagResource up
// to 5 times per second, per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation TagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeTagQuotaPerResourceExceeded "TagQuotaPerResourceExceeded"
//   You have exceeded the maximum number of tags for this DAX cluster.
//
//   * ErrCodeInvalidARNFault "InvalidARNFault"
//   The Amazon Resource Name (ARN) supplied in the request is not valid.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/TagResource
func (c *DAX) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UntagResource
func (c *DAX) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UntagResource API operation for Amazon DynamoDB Accelerator (DAX).
//
// Removes the association of tags from a DAX resource. You can call UntagResource
// up to 5 times per second, per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation UntagResource for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeInvalidARNFault "InvalidARNFault"
//   The Amazon Resource Name (ARN) supplied in the request is not valid.
//
//   * ErrCodeTagNotFoundFault "TagNotFoundFault"
//   The tag does not exist.
//
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UntagResource
func (c *DAX) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCluster = "UpdateCluster"

// UpdateClusterRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCluster for more information on using the UpdateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClusterRequest method.
//    req, resp := client.UpdateClusterRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateCluster
func (c *DAX) UpdateClusterRequest(input *UpdateClusterInput) (req *request.Request, output *UpdateClusterOutput) {
	op := &request.Operation{
		Name:       opUpdateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateClusterInput{}
	}

	output = &UpdateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCluster API operation for Amazon DynamoDB Accelerator (DAX).
//
// Modifies the settings for a DAX cluster. You can use this action to change
// one or more cluster configuration parameters by specifying the parameters
// and the new values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation UpdateCluster for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidClusterStateFault "InvalidClusterStateFault"
//   The requested DAX cluster is not in the available state.
//
//   * ErrCodeClusterNotFoundFault "ClusterNotFoundFault"
//   The requested cluster ID does not refer to an existing DAX cluster.
//
//   * ErrCodeInvalidParameterGroupStateFault "InvalidParameterGroupStateFault"
//   One or more parameters in a parameter group are in an invalid state.
//
//   * ErrCodeParameterGroupNotFoundFault "ParameterGroupNotFoundFault"
//   The specified parameter group does not exist.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateCluster
func (c *DAX) UpdateCluster(input *UpdateClusterInput) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	return out, req.Send()
}

// UpdateClusterWithContext is the same as UpdateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) UpdateClusterWithContext(ctx aws.Context, input *UpdateClusterInput, opts ...request.Option) (*UpdateClusterOutput, error) {
	req, out := c.UpdateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateParameterGroup = "UpdateParameterGroup"

// UpdateParameterGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateParameterGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateParameterGroup for more information on using the UpdateParameterGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateParameterGroupRequest method.
//    req, resp := client.UpdateParameterGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateParameterGroup
func (c *DAX) UpdateParameterGroupRequest(input *UpdateParameterGroupInput) (req *request.Request, output *UpdateParameterGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateParameterGroupInput{}
	}

	output = &UpdateParameterGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateParameterGroup API operation for Amazon DynamoDB Accelerator (DAX).
//
// Modifies the parameters of a parameter group. You can modify up to 20 parameters
// in a single request by submitting a list parameter name and value pairs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation UpdateParameterGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterGroupStateFault "InvalidParameterGroupStateFault"
//   One or more parameters in a parameter group are in an invalid state.
//
//   * ErrCodeParameterGroupNotFoundFault "ParameterGroupNotFoundFault"
//   The specified parameter group does not exist.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
//   * ErrCodeInvalidParameterValueException "InvalidParameterValueException"
//   The value for a parameter is invalid.
//
//   * ErrCodeInvalidParameterCombinationException "InvalidParameterCombinationException"
//   Two or more incompatible parameters were specified.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateParameterGroup
func (c *DAX) UpdateParameterGroup(input *UpdateParameterGroupInput) (*UpdateParameterGroupOutput, error) {
	req, out := c.UpdateParameterGroupRequest(input)
	return out, req.Send()
}

// UpdateParameterGroupWithContext is the same as UpdateParameterGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateParameterGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) UpdateParameterGroupWithContext(ctx aws.Context, input *UpdateParameterGroupInput, opts ...request.Option) (*UpdateParameterGroupOutput, error) {
	req, out := c.UpdateParameterGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSubnetGroup = "UpdateSubnetGroup"

// UpdateSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSubnetGroup for more information on using the UpdateSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSubnetGroupRequest method.
//    req, resp := client.UpdateSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateSubnetGroup
func (c *DAX) UpdateSubnetGroupRequest(input *UpdateSubnetGroupInput) (req *request.Request, output *UpdateSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSubnetGroupInput{}
	}

	output = &UpdateSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSubnetGroup API operation for Amazon DynamoDB Accelerator (DAX).
//
// Modifies an existing subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon DynamoDB Accelerator (DAX)'s
// API operation UpdateSubnetGroup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeSubnetGroupNotFoundFault "SubnetGroupNotFoundFault"
//   The requested subnet group name does not refer to an existing subnet group.
//
//   * ErrCodeSubnetQuotaExceededFault "SubnetQuotaExceededFault"
//   The request cannot be processed because it would exceed the allowed number
//   of subnets in a subnet group.
//
//   * ErrCodeSubnetInUse "SubnetInUse"
//   The requested subnet is being used by another subnet group.
//
//   * ErrCodeInvalidSubnet "InvalidSubnet"
//   An invalid subnet identifier was specified.
//
//   * ErrCodeServiceLinkedRoleNotFoundFault "ServiceLinkedRoleNotFoundFault"
//   The specified service linked role (SLR) was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dax-2017-04-19/UpdateSubnetGroup
func (c *DAX) UpdateSubnetGroup(input *UpdateSubnetGroupInput) (*UpdateSubnetGroupOutput, error) {
	req, out := c.UpdateSubnetGroupRequest(input)
	return out, req.Send()
}

// UpdateSubnetGroupWithContext is the same as UpdateSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DAX) UpdateSubnetGroupWithContext(ctx aws.Context, input *UpdateSubnetGroupInput, opts ...request.Option) (*UpdateSubnetGroupOutput, error) {
	req, out := c.UpdateSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Contains all of the attributes of a specific DAX cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The number of nodes in the cluster that are active (i.e., capable of serving
	// requests).
	ActiveNodes *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) that uniquely identifies the cluster.
	ClusterArn *string `type:"string"`

	// The configuration endpoint for this DAX cluster, consisting of a DNS name
	// and a port number. Client applications can specify this endpoint, rather
	// than an individual node endpoint, and allow the DAX client software to intelligently
	// route requests and responses to nodes in the DAX cluster.
	ClusterDiscoveryEndpoint *Endpoint `type:"structure"`

	// The name of the DAX cluster.
	ClusterName *string `type:"string"`

	// The description of the cluster.
	Description *string `type:"string"`

	// A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime,
	// DAX will assume this role and use the role's permissions to access DynamoDB
	// on your behalf.
	IamRoleArn *string `type:"string"`

	// A list of nodes to be removed from the cluster.
	NodeIdsToRemove []*string `type:"list"`

	// The node type for the nodes in the cluster. (All nodes in a DAX cluster are
	// of the same type.)
	NodeType *string `type:"string"`

	// A list of nodes that are currently in the cluster.
	Nodes []*Node `type:"list"`

	// Describes a notification topic and its status. Notification topics are used
	// for publishing DAX events to subscribers using Amazon Simple Notification
	// Service (SNS).
	NotificationConfiguration *NotificationConfiguration `type:"structure"`

	// The parameter group being used by nodes in the cluster.
	ParameterGroup *ParameterGroupStatus `type:"structure"`

	// A range of time when maintenance of DAX cluster software will be performed.
	// For example: sun:01:00-sun:09:00. Cluster maintenance normally takes less
	// than 30 minutes, and is performed automatically within the maintenance window.
	PreferredMaintenanceWindow *string `type:"string"`

	// The description of the server-side encryption status on the specified DAX
	// cluster.
	SSEDescription *SSEDescription `type:"structure"`

	// A list of security groups, and the status of each, for the nodes in the cluster.
	SecurityGroups []*SecurityGroupMembership `type:"list"`

	// The current status of the cluster.
	Status *string `type:"string"`

	// The subnet group where the DAX cluster is running.
	SubnetGroup *string `type:"string"`

	// The total number of nodes in the cluster.
	TotalNodes *int64 `type:"integer"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cluster) GoString() string {
	return s.String()
}

// SetActiveNodes sets the ActiveNodes field's value.
func (s *Cluster) SetActiveNodes(v int64) *Cluster {
	s.ActiveNodes = &v
	return s
}

// SetClusterArn sets the ClusterArn field's value.
func (s *Cluster) SetClusterArn(v string) *Cluster {
	s.ClusterArn = &v
	return s
}

// SetClusterDiscoveryEndpoint sets the ClusterDiscoveryEndpoint field's value.
func (s *Cluster) SetClusterDiscoveryEndpoint(v *Endpoint) *Cluster {
	s.ClusterDiscoveryEndpoint = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Cluster) SetClusterName(v string) *Cluster {
	s.ClusterName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Cluster) SetDescription(v string) *Cluster {
	s.Description = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *Cluster) SetIamRoleArn(v string) *Cluster {
	s.IamRoleArn = &v
	return s
}

// SetNodeIdsToRemove sets the NodeIdsToRemove field's value.
func (s *Cluster) SetNodeIdsToRemove(v []*string) *Cluster {
	s.NodeIdsToRemove = v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *Cluster) SetNodeType(v string) *Cluster {
	s.NodeType = &v
	return s
}

// SetNodes sets the Nodes field's value.
func (s *Cluster) SetNodes(v []*Node) *Cluster {
	s.Nodes = v
	return s
}

// SetNotificationConfiguration sets the NotificationConfiguration field's value.
func (s *Cluster) SetNotificationConfiguration(v *NotificationConfiguration) *Cluster {
	s.NotificationConfiguration = v
	return s
}

// SetParameterGroup sets the ParameterGroup field's value.
func (s *Cluster) SetParameterGroup(v *ParameterGroupStatus) *Cluster {
	s.ParameterGroup = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *Cluster) SetPreferredMaintenanceWindow(v string) *Cluster {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetSSEDescription sets the SSEDescription field's value.
func (s *Cluster) SetSSEDescription(v *SSEDescription) *Cluster {
	s.SSEDescription = v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *Cluster) SetSecurityGroups(v []*SecurityGroupMembership) *Cluster {
	s.SecurityGroups = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v string) *Cluster {
	s.Status = &v
	return s
}

// SetSubnetGroup sets the SubnetGroup field's value.
func (s *Cluster) SetSubnetGroup(v string) *Cluster {
	s.SubnetGroup = &v
	return s
}

// SetTotalNodes sets the TotalNodes field's value.
func (s *Cluster) SetTotalNodes(v int64) *Cluster {
	s.TotalNodes = &v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zones (AZs) in which the cluster nodes will reside after
	// the cluster has been created or updated. If provided, the length of this
	// list must equal the ReplicationFactor parameter. If you omit this parameter,
	// DAX will spread the nodes across Availability Zones for the highest availability.
	AvailabilityZones []*string `type:"list"`

	// The cluster identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * A name must contain from 1 to 20 alphanumeric characters or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * A name cannot end with a hyphen or contain two consecutive hyphens.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// A description of the cluster.
	Description *string `type:"string"`

	// A valid Amazon Resource Name (ARN) that identifies an IAM role. At runtime,
	// DAX will assume this role and use the role's permissions to access DynamoDB
	// on your behalf.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// The compute and memory capacity of the nodes in the cluster.
	//
	// NodeType is a required field
	NodeType *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which notifications
	// will be sent.
	//
	// The Amazon SNS topic owner must be same as the DAX cluster owner.
	NotificationTopicArn *string `type:"string"`

	// The parameter group to be associated with the DAX cluster.
	ParameterGroupName *string `type:"string"`

	// Specifies the weekly time range during which maintenance on the DAX cluster
	// is performed. It is specified as a range in the format ddd:hh24:mi-ddd:hh24:mi
	// (24H Clock UTC). The minimum maintenance window is a 60 minute period. Valid
	// values for ddd are:
	//
	//    * sun
	//
	//    * mon
	//
	//    * tue
	//
	//    * wed
	//
	//    * thu
	//
	//    * fri
	//
	//    * sat
	//
	// Example: sun:05:00-sun:09:00
	//
	// If you don't specify a preferred maintenance window when you create or modify
	// a cache cluster, DAX assigns a 60-minute maintenance window on a randomly
	// selected day of the week.
	PreferredMaintenanceWindow *string `type:"string"`

	// The number of nodes in the DAX cluster. A replication factor of 1 will create
	// a single-node cluster, without any read replicas. For additional fault tolerance,
	// you can create a multiple node cluster with one or more read replicas. To
	// do this, set ReplicationFactor to a number between 3 (one primary and two
	// read replicas) and 10 (one primary and nine read replicas). If the AvailabilityZones
	// parameter is provided, its length must equal the ReplicationFactor.
	//
	// AWS recommends that you have at least two read replicas per cluster.
	//
	// ReplicationFactor is a required field
	ReplicationFactor *int64 `type:"integer" required:"true"`

	// Represents the settings used to enable server-side encryption on the cluster.
	SSESpecification *SSESpecification `type:"structure"`

	// A list of security group IDs to be assigned to each node in the DAX cluster.
	// (Each of the security group ID is system-generated.)
	//
	// If this parameter is not specified, DAX assigns the default VPC security
	// group to each node.
	SecurityGroupIds []*string `type:"list"`

	// The name of the subnet group to be used for the replication group.
	//
	// DAX clusters can only run in an Amazon VPC environment. All of the subnets
	// that you specify in a subnet group must exist in the same VPC.
	SubnetGroupName *string `type:"string"`

	// A set of tags to associate with the DAX cluster.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.NodeType == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeType"))
	}
	if s.ReplicationFactor == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationFactor"))
	}
	if s.SSESpecification != nil {
		if err := s.SSESpecification.Validate(); err != nil {
			invalidParams.AddNested("SSESpecification", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *CreateClusterInput) SetAvailabilityZones(v []*string) *CreateClusterInput {
	s.AvailabilityZones = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateClusterInput) SetClusterName(v string) *CreateClusterInput {
	s.ClusterName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateClusterInput) SetDescription(v string) *CreateClusterInput {
	s.Description = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CreateClusterInput) SetIamRoleArn(v string) *CreateClusterInput {
	s.IamRoleArn = &v
	return s
}

// SetNodeType sets the NodeType field's value.
func (s *CreateClusterInput) SetNodeType(v string) *CreateClusterInput {
	s.NodeType = &v
	return s
}

// SetNotificationTopicArn sets the NotificationTopicArn field's value.
func (s *CreateClusterInput) SetNotificationTopicArn(v string) *CreateClusterInput {
	s.NotificationTopicArn = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *CreateClusterInput) SetParameterGroupName(v string) *CreateClusterInput {
	s.ParameterGroupName = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateClusterInput) SetPreferredMaintenanceWindow(v string) *CreateClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationFactor sets the ReplicationFactor field's value.
func (s *CreateClusterInput) SetReplicationFactor(v int64) *CreateClusterInput {
	s.ReplicationFactor = &v
	return s
}

// SetSSESpecification sets the SSESpecification field's value.
func (s *CreateClusterInput) SetSSESpecification(v *SSESpecification) *CreateClusterInput {
	s.SSESpecification = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateClusterInput) SetSecurityGroupIds(v []*string) *CreateClusterInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *CreateClusterInput) SetSubnetGroupName(v string) *CreateClusterInput {
	s.SubnetGroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v []*Tag) *CreateClusterInput {
	s.Tags = v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// A description of the DAX cluster that you have created.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the parameter group.
	Description *string `type:"string"`

	// The name of the parameter group to apply to all of the clusters in this replication
	// group.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateParameterGroupInput) SetDescription(v string) *CreateParameterGroupInput {
	s.Description = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *CreateParameterGroupInput) SetParameterGroupName(v string) *CreateParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

type CreateParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of a CreateParameterGroup action.
	ParameterGroup *ParameterGroup `type:"structure"`
}

// String returns the string representation
func (s CreateParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateParameterGroupOutput) GoString() string {
	return s.String()
}

// SetParameterGroup sets the ParameterGroup field's value.
func (s *CreateParameterGroupOutput) SetParameterGroup(v *ParameterGroup) *CreateParameterGroupOutput {
	s.ParameterGroup = v
	return s
}

type CreateSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description for the subnet group
	Description *string `type:"string"`

	// A name for the subnet group. This value is stored as a lowercase string.
	//
	// SubnetGroupName is a required field
	SubnetGroupName *string `type:"string" required:"true"`

	// A list of VPC subnet IDs for the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSubnetGroupInput"}
	if s.SubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetGroupName"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateSubnetGroupInput) SetDescription(v string) *CreateSubnetGroupInput {
	s.Description = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *CreateSubnetGroupInput) SetSubnetGroupName(v string) *CreateSubnetGroupInput {
	s.SubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateSubnetGroupInput) SetSubnetIds(v []*string) *CreateSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type CreateSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// Represents the output of a CreateSubnetGroup operation.
	SubnetGroup *SubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetSubnetGroup sets the SubnetGroup field's value.
func (s *CreateSubnetGroupOutput) SetSubnetGroup(v *SubnetGroup) *CreateSubnetGroupOutput {
	s.SubnetGroup = v
	return s
}

type DecreaseReplicationFactorInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone(s) from which to remove nodes.
	AvailabilityZones []*string `type:"list"`

	// The name of the DAX cluster from which you want to remove nodes.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// The new number of nodes for the DAX cluster.
	//
	// NewReplicationFactor is a required field
	NewReplicationFactor *int64 `type:"integer" required:"true"`

	// The unique identifiers of the nodes to be removed from the cluster.
	NodeIdsToRemove []*string `type:"list"`
}

// String returns the string representation
func (s DecreaseReplicationFactorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecreaseReplicationFactorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DecreaseReplicationFactorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DecreaseReplicationFactorInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.NewReplicationFactor == nil {
		invalidParams.Add(request.NewErrParamRequired("NewReplicationFactor"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *DecreaseReplicationFactorInput) SetAvailabilityZones(v []*string) *DecreaseReplicationFactorInput {
	s.AvailabilityZones = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DecreaseReplicationFactorInput) SetClusterName(v string) *DecreaseReplicationFactorInput {
	s.ClusterName = &v
	return s
}

// SetNewReplicationFactor sets the NewReplicationFactor field's value.
func (s *DecreaseReplicationFactorInput) SetNewReplicationFactor(v int64) *DecreaseReplicationFactorInput {
	s.NewReplicationFactor = &v
	return s
}

// SetNodeIdsToRemove sets the NodeIdsToRemove field's value.
func (s *DecreaseReplicationFactorInput) SetNodeIdsToRemove(v []*string) *DecreaseReplicationFactorInput {
	s.NodeIdsToRemove = v
	return s
}

type DecreaseReplicationFactorOutput struct {
	_ struct{} `type:"structure"`

	// A description of the DAX cluster, after you have decreased its replication
	// factor.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DecreaseReplicationFactorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecreaseReplicationFactorOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DecreaseReplicationFactorOutput) SetCluster(v *Cluster) *DecreaseReplicationFactorOutput {
	s.Cluster = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster to be deleted.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteClusterInput) SetClusterName(v string) *DeleteClusterInput {
	s.ClusterName = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// A description of the DAX cluster that is being deleted.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group to delete.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DeleteParameterGroupInput) SetParameterGroupName(v string) *DeleteParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

type DeleteParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// A user-specified message for this action (i.e., a reason for deleting the
	// parameter group).
	DeletionMessage *string `type:"string"`
}

// String returns the string representation
func (s DeleteParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteParameterGroupOutput) GoString() string {
	return s.String()
}

// SetDeletionMessage sets the DeletionMessage field's value.
func (s *DeleteParameterGroupOutput) SetDeletionMessage(v string) *DeleteParameterGroupOutput {
	s.DeletionMessage = &v
	return s
}

type DeleteSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the subnet group to delete.
	//
	// SubnetGroupName is a required field
	SubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSubnetGroupInput"}
	if s.SubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *DeleteSubnetGroupInput) SetSubnetGroupName(v string) *DeleteSubnetGroupInput {
	s.SubnetGroupName = &v
	return s
}

type DeleteSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// A user-specified message for this action (i.e., a reason for deleting the
	// subnet group).
	DeletionMessage *string `type:"string"`
}

// String returns the string representation
func (s DeleteSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetDeletionMessage sets the DeletionMessage field's value.
func (s *DeleteSubnetGroupOutput) SetDeletionMessage(v string) *DeleteSubnetGroupOutput {
	s.DeletionMessage = &v
	return s
}

type DescribeClustersInput struct {
	_ struct{} `type:"structure"`

	// The names of the DAX clusters being described.
	ClusterNames []*string `type:"list"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	//
	// The value for MaxResults must be between 20 and 100.
	MaxResults *int64 `type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClustersInput) GoString() string {
	return s.String()
}

// SetClusterNames sets the ClusterNames field's value.
func (s *DescribeClustersInput) SetClusterNames(v []*string) *DescribeClustersInput {
	s.ClusterNames = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeClustersInput) SetMaxResults(v int64) *DescribeClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeClustersInput) SetNextToken(v string) *DescribeClustersInput {
	s.NextToken = &v
	return s
}

type DescribeClustersOutput struct {
	_ struct{} `type:"structure"`

	// The descriptions of your DAX clusters, in response to a DescribeClusters
	// request.
	Clusters []*Cluster `type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *DescribeClustersOutput) SetClusters(v []*Cluster) *DescribeClustersOutput {
	s.Clusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeClustersOutput) SetNextToken(v string) *DescribeClustersOutput {
	s.NextToken = &v
	return s
}

type DescribeDefaultParametersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	//
	// The value for MaxResults must be between 20 and 100.
	MaxResults *int64 `type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeDefaultParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultParametersInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeDefaultParametersInput) SetMaxResults(v int64) *DescribeDefaultParametersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDefaultParametersInput) SetNextToken(v string) *DescribeDefaultParametersInput {
	s.NextToken = &v
	return s
}

type DescribeDefaultParametersOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// A list of parameters. Each element in the list represents one parameter.
	Parameters []*Parameter `type:"list"`
}

// String returns the string representation
func (s DescribeDefaultParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDefaultParametersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeDefaultParametersOutput) SetNextToken(v string) *DescribeDefaultParametersOutput {
	s.NextToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeDefaultParametersOutput) SetParameters(v []*Parameter) *DescribeDefaultParametersOutput {
	s.Parameters = v
	return s
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The number of minutes' worth of events to retrieve.
	Duration *int64 `type:"integer"`

	// The end of the time interval for which to retrieve events, specified in ISO
	// 8601 format.
	EndTime *time.Time `type:"timestamp"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	//
	// The value for MaxResults must be between 20 and 100.
	MaxResults *int64 `type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `type:"string"`

	// The identifier of the event source for which events will be returned. If
	// not specified, then all sources are included in the response.
	SourceName *string `type:"string"`

	// The event source to retrieve events for. If no value is specified, all events
	// are returned.
	SourceType *string `type:"string" enum:"SourceType"`

	// The beginning of the time interval to retrieve events for, specified in ISO
	// 8601 format.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEventsInput) SetMaxResults(v int64) *DescribeEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsInput) SetNextToken(v string) *DescribeEventsInput {
	s.NextToken = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *DescribeEventsInput) SetSourceName(v string) *DescribeEventsInput {
	s.SourceName = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// An array of events. Each element in the array represents one event.
	Events []*Event `type:"list"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsOutput) SetNextToken(v string) *DescribeEventsOutput {
	s.NextToken = &v
	return s
}

type DescribeParameterGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	//
	// The value for MaxResults must be between 20 and 100.
	MaxResults *int64 `type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `type:"string"`

	// The names of the parameter groups.
	ParameterGroupNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeParameterGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeParameterGroupsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeParameterGroupsInput) SetMaxResults(v int64) *DescribeParameterGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParameterGroupsInput) SetNextToken(v string) *DescribeParameterGroupsInput {
	s.NextToken = &v
	return s
}

// SetParameterGroupNames sets the ParameterGroupNames field's value.
func (s *DescribeParameterGroupsInput) SetParameterGroupNames(v []*string) *DescribeParameterGroupsInput {
	s.ParameterGroupNames = v
	return s
}

type DescribeParameterGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// An array of parameter groups. Each element in the array represents one parameter
	// group.
	ParameterGroups []*ParameterGroup `type:"list"`
}

// String returns the string representation
func (s DescribeParameterGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeParameterGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParameterGroupsOutput) SetNextToken(v string) *DescribeParameterGroupsOutput {
	s.NextToken = &v
	return s
}

// SetParameterGroups sets the ParameterGroups field's value.
func (s *DescribeParameterGroupsOutput) SetParameterGroups(v []*ParameterGroup) *DescribeParameterGroupsOutput {
	s.ParameterGroups = v
	return s
}

type DescribeParametersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	//
	// The value for MaxResults must be between 20 and 100.
	MaxResults *int64 `type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `type:"string"`

	// The name of the parameter group.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// How the parameter is defined. For example, system denotes a system-defined
	// parameter.
	Source *string `type:"string"`
}

// String returns the string representation
func (s DescribeParametersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeParametersInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeParametersInput) SetMaxResults(v int64) *DescribeParametersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParametersInput) SetNextToken(v string) *DescribeParametersInput {
	s.NextToken = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *DescribeParametersInput) SetParameterGroupName(v string) *DescribeParametersInput {
	s.ParameterGroupName = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribeParametersInput) SetSource(v string) *DescribeParametersInput {
	s.Source = &v
	return s
}

type DescribeParametersOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// A list of parameters within a parameter group. Each element in the list represents
	// one parameter.
	Parameters []*Parameter `type:"list"`
}

// String returns the string representation
func (s DescribeParametersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeParametersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeParametersOutput) SetNextToken(v string) *DescribeParametersOutput {
	s.NextToken = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *DescribeParametersOutput) SetParameters(v []*Parameter) *DescribeParametersOutput {
	s.Parameters = v
	return s
}

type DescribeSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to include in the response. If more results
	// exist than the specified MaxResults value, a token is included in the response
	// so that the remaining results can be retrieved.
	//
	// The value for MaxResults must be between 20 and 100.
	MaxResults *int64 `type:"integer"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token, up to the value specified by MaxResults.
	NextToken *string `type:"string"`

	// The name of the subnet group.
	SubnetGroupNames []*string `type:"list"`
}

// String returns the string representation
func (s DescribeSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubnetGroupsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeSubnetGroupsInput) SetMaxResults(v int64) *DescribeSubnetGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSubnetGroupsInput) SetNextToken(v string) *DescribeSubnetGroupsInput {
	s.NextToken = &v
	return s
}

// SetSubnetGroupNames sets the SubnetGroupNames field's value.
func (s *DescribeSubnetGroupsInput) SetSubnetGroupNames(v []*string) *DescribeSubnetGroupsInput {
	s.SubnetGroupNames = v
	return s
}

type DescribeSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// Provides an identifier to allow retrieval of paginated results.
	NextToken *string `type:"string"`

	// An array of subnet groups. Each element in the array represents a single
	// subnet group.
	SubnetGroups []*SubnetGroup `type:"list"`
}

// String returns the string representation
func (s DescribeSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeSubnetGroupsOutput) SetNextToken(v string) *DescribeSubnetGroupsOutput {
	s.NextToken = &v
	return s
}

// SetSubnetGroups sets the SubnetGroups field's value.
func (s *DescribeSubnetGroupsOutput) SetSubnetGroups(v []*SubnetGroup) *DescribeSubnetGroupsOutput {
	s.SubnetGroups = v
	return s
}

// Represents the information required for client programs to connect to the
// configuration endpoint for a DAX cluster, or to an individual node within
// the cluster.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS hostname of the endpoint.
	Address *string `type:"string"`

	// The port number that applications should use to connect to the endpoint.
	Port *int64 `type:"integer"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// Represents a single occurrence of something interesting within the system.
// Some examples of events are creating a DAX cluster, adding or removing a
// node, or rebooting a node.
type Event struct {
	_ struct{} `type:"structure"`

	// The date and time when the event occurred.
	Date *time.Time `type:"timestamp"`

	// A user-defined message associated with the event.
	Message *string `type:"string"`

	// The source of the event. For example, if the event occurred at the node level,
	// the source would be the node ID.
	SourceName *string `type:"string"`

	// Specifies the origin of this event - a cluster, a parameter group, a node
	// ID, etc.
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceName sets the SourceName field's value.
func (s *Event) SetSourceName(v string) *Event {
	s.SourceName = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

type IncreaseReplicationFactorInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zones (AZs) in which the cluster nodes will be created.
	// All nodes belonging to the cluster are placed in these Availability Zones.
	// Use this parameter if you want to distribute the nodes across multiple AZs.
	AvailabilityZones []*string `type:"list"`

	// The name of the DAX cluster that will receive additional nodes.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// The new number of nodes for the DAX cluster.
	//
	// NewReplicationFactor is a required field
	NewReplicationFactor *int64 `type:"integer" required:"true"`
}

// String returns the string representation
func (s IncreaseReplicationFactorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseReplicationFactorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IncreaseReplicationFactorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IncreaseReplicationFactorInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.NewReplicationFactor == nil {
		invalidParams.Add(request.NewErrParamRequired("NewReplicationFactor"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *IncreaseReplicationFactorInput) SetAvailabilityZones(v []*string) *IncreaseReplicationFactorInput {
	s.AvailabilityZones = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *IncreaseReplicationFactorInput) SetClusterName(v string) *IncreaseReplicationFactorInput {
	s.ClusterName = &v
	return s
}

// SetNewReplicationFactor sets the NewReplicationFactor field's value.
func (s *IncreaseReplicationFactorInput) SetNewReplicationFactor(v int64) *IncreaseReplicationFactorInput {
	s.NewReplicationFactor = &v
	return s
}

type IncreaseReplicationFactorOutput struct {
	_ struct{} `type:"structure"`

	// A description of the DAX cluster. with its new replication factor.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s IncreaseReplicationFactorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncreaseReplicationFactorOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *IncreaseReplicationFactorOutput) SetCluster(v *Cluster) *IncreaseReplicationFactorOutput {
	s.Cluster = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// An optional token returned from a prior request. Use this token for pagination
	// of results from this action. If this parameter is specified, the response
	// includes only results beyond the token.
	NextToken *string `type:"string"`

	// The name of the DAX resource to which the tags belong.
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ListTagsInput) SetResourceName(v string) *ListTagsInput {
	s.ResourceName = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// If this value is present, there are additional results to be displayed. To
	// retrieve them, call ListTags again, with NextToken set to this value.
	NextToken *string `type:"string"`

	// A list of tags currently associated with the DAX cluster.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v []*Tag) *ListTagsOutput {
	s.Tags = v
	return s
}

// Represents an individual node within a DAX cluster.
type Node struct {
	_ struct{} `type:"structure"`

	// The Availability Zone (AZ) in which the node has been deployed.
	AvailabilityZone *string `type:"string"`

	// The endpoint for the node, consisting of a DNS name and a port number. Client
	// applications can connect directly to a node endpoint, if desired (as an alternative
	// to allowing DAX client software to intelligently route requests and responses
	// to nodes in the DAX cluster.
	Endpoint *Endpoint `type:"structure"`

	// The date and time (in UNIX epoch format) when the node was launched.
	NodeCreateTime *time.Time `type:"timestamp"`

	// A system-generated identifier for the node.
	NodeId *string `type:"string"`

	// The current status of the node. For example: available.
	NodeStatus *string `type:"string"`

	// The status of the parameter group associated with this node. For example,
	// in-sync.
	ParameterGroupStatus *string `type:"string"`
}

// String returns the string representation
func (s Node) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Node) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Node) SetAvailabilityZone(v string) *Node {
	s.AvailabilityZone = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Node) SetEndpoint(v *Endpoint) *Node {
	s.Endpoint = v
	return s
}

// SetNodeCreateTime sets the NodeCreateTime field's value.
func (s *Node) SetNodeCreateTime(v time.Time) *Node {
	s.NodeCreateTime = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *Node) SetNodeId(v string) *Node {
	s.NodeId = &v
	return s
}

// SetNodeStatus sets the NodeStatus field's value.
func (s *Node) SetNodeStatus(v string) *Node {
	s.NodeStatus = &v
	return s
}

// SetParameterGroupStatus sets the ParameterGroupStatus field's value.
func (s *Node) SetParameterGroupStatus(v string) *Node {
	s.ParameterGroupStatus = &v
	return s
}

// Represents a parameter value that is applicable to a particular node type.
type NodeTypeSpecificValue struct {
	_ struct{} `type:"structure"`

	// A node type to which the parameter value applies.
	NodeType *string `type:"string"`

	// The parameter value for this node type.
	Value *string `type:"string"`
}

// String returns the string representation
func (s NodeTypeSpecificValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeTypeSpecificValue) GoString() string {
	return s.String()
}

// SetNodeType sets the NodeType field's value.
func (s *NodeTypeSpecificValue) SetNodeType(v string) *NodeTypeSpecificValue {
	s.NodeType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *NodeTypeSpecificValue) SetValue(v string) *NodeTypeSpecificValue {
	s.Value = &v
	return s
}

// Describes a notification topic and its status. Notification topics are used
// for publishing DAX events to subscribers using Amazon Simple Notification
// Service (SNS).
type NotificationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the topic.
	TopicArn *string `type:"string"`

	// The current state of the topic.
	TopicStatus *string `type:"string"`
}

// String returns the string representation
func (s NotificationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationConfiguration) GoString() string {
	return s.String()
}

// SetTopicArn sets the TopicArn field's value.
func (s *NotificationConfiguration) SetTopicArn(v string) *NotificationConfiguration {
	s.TopicArn = &v
	return s
}

// SetTopicStatus sets the TopicStatus field's value.
func (s *NotificationConfiguration) SetTopicStatus(v string) *NotificationConfiguration {
	s.TopicStatus = &v
	return s
}

// Describes an individual setting that controls some aspect of DAX behavior.
type Parameter struct {
	_ struct{} `type:"structure"`

	// A range of values within which the parameter can be set.
	AllowedValues *string `type:"string"`

	// The conditions under which changes to this parameter can be applied. For
	// example, requires-reboot indicates that a new value for this parameter will
	// only take effect if a node is rebooted.
	ChangeType *string `type:"string" enum:"ChangeType"`

	// The data type of the parameter. For example, integer:
	DataType *string `type:"string"`

	// A description of the parameter
	Description *string `type:"string"`

	// Whether the customer is allowed to modify the parameter.
	IsModifiable *string `type:"string" enum:"IsModifiable"`

	// A list of node types, and specific parameter values for each node.
	NodeTypeSpecificValues []*NodeTypeSpecificValue `type:"list"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// Determines whether the parameter can be applied to any nodes, or only nodes
	// of a particular type.
	ParameterType *string `type:"string" enum:"ParameterType"`

	// The value for the parameter.
	ParameterValue *string `type:"string"`

	// How the parameter is defined. For example, system denotes a system-defined
	// parameter.
	Source *string `type:"string"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// SetAllowedValues sets the AllowedValues field's value.
func (s *Parameter) SetAllowedValues(v string) *Parameter {
	s.AllowedValues = &v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *Parameter) SetChangeType(v string) *Parameter {
	s.ChangeType = &v
	return s
}

// SetDataType sets the DataType field's value.
func (s *Parameter) SetDataType(v string) *Parameter {
	s.DataType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Parameter) SetDescription(v string) *Parameter {
	s.Description = &v
	return s
}

// SetIsModifiable sets the IsModifiable field's value.
func (s *Parameter) SetIsModifiable(v string) *Parameter {
	s.IsModifiable = &v
	return s
}

// SetNodeTypeSpecificValues sets the NodeTypeSpecificValues field's value.
func (s *Parameter) SetNodeTypeSpecificValues(v []*NodeTypeSpecificValue) *Parameter {
	s.NodeTypeSpecificValues = v
	return s
}

// SetParameterName sets the ParameterName field's value.
func (s *Parameter) SetParameterName(v string) *Parameter {
	s.ParameterName = &v
	return s
}

// SetParameterType sets the ParameterType field's value.
func (s *Parameter) SetParameterType(v string) *Parameter {
	s.ParameterType = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *Parameter) SetParameterValue(v string) *Parameter {
	s.ParameterValue = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Parameter) SetSource(v string) *Parameter {
	s.Source = &v
	return s
}

// A named set of parameters that are applied to all of the nodes in a DAX cluster.
type ParameterGroup struct {
	_ struct{} `type:"structure"`

	// A description of the parameter group.
	Description *string `type:"string"`

	// The name of the parameter group.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ParameterGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterGroup) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ParameterGroup) SetDescription(v string) *ParameterGroup {
	s.Description = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ParameterGroup) SetParameterGroupName(v string) *ParameterGroup {
	s.ParameterGroupName = &v
	return s
}

// The status of a parameter group.
type ParameterGroupStatus struct {
	_ struct{} `type:"structure"`

	// The node IDs of one or more nodes to be rebooted.
	NodeIdsToReboot []*string `type:"list"`

	// The status of parameter updates.
	ParameterApplyStatus *string `type:"string"`

	// The name of the parameter group.
	ParameterGroupName *string `type:"string"`
}

// String returns the string representation
func (s ParameterGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterGroupStatus) GoString() string {
	return s.String()
}

// SetNodeIdsToReboot sets the NodeIdsToReboot field's value.
func (s *ParameterGroupStatus) SetNodeIdsToReboot(v []*string) *ParameterGroupStatus {
	s.NodeIdsToReboot = v
	return s
}

// SetParameterApplyStatus sets the ParameterApplyStatus field's value.
func (s *ParameterGroupStatus) SetParameterApplyStatus(v string) *ParameterGroupStatus {
	s.ParameterApplyStatus = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *ParameterGroupStatus) SetParameterGroupName(v string) *ParameterGroupStatus {
	s.ParameterGroupName = &v
	return s
}

// An individual DAX parameter.
type ParameterNameValue struct {
	_ struct{} `type:"structure"`

	// The name of the parameter.
	ParameterName *string `type:"string"`

	// The value of the parameter.
	ParameterValue *string `type:"string"`
}

// String returns the string representation
func (s ParameterNameValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterNameValue) GoString() string {
	return s.String()
}

// SetParameterName sets the ParameterName field's value.
func (s *ParameterNameValue) SetParameterName(v string) *ParameterNameValue {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ParameterNameValue) SetParameterValue(v string) *ParameterNameValue {
	s.ParameterValue = &v
	return s
}

type RebootNodeInput struct {
	_ struct{} `type:"structure"`

	// The name of the DAX cluster containing the node to be rebooted.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// The system-assigned ID of the node to be rebooted.
	//
	// NodeId is a required field
	NodeId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootNodeInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.NodeId == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *RebootNodeInput) SetClusterName(v string) *RebootNodeInput {
	s.ClusterName = &v
	return s
}

// SetNodeId sets the NodeId field's value.
func (s *RebootNodeInput) SetNodeId(v string) *RebootNodeInput {
	s.NodeId = &v
	return s
}

type RebootNodeOutput struct {
	_ struct{} `type:"structure"`

	// A description of the DAX cluster after a node has been rebooted.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s RebootNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootNodeOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RebootNodeOutput) SetCluster(v *Cluster) *RebootNodeOutput {
	s.Cluster = v
	return s
}

// The description of the server-side encryption status on the specified DAX
// cluster.
type SSEDescription struct {
	_ struct{} `type:"structure"`

	// The current state of server-side encryption:
	//
	//    * ENABLING - Server-side encryption is being enabled.
	//
	//    * ENABLED - Server-side encryption is enabled.
	//
	//    * DISABLING - Server-side encryption is being disabled.
	//
	//    * DISABLED - Server-side encryption is disabled.
	Status *string `type:"string" enum:"SSEStatus"`
}

// String returns the string representation
func (s SSEDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSEDescription) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *SSEDescription) SetStatus(v string) *SSEDescription {
	s.Status = &v
	return s
}

// Represents the settings used to enable server-side encryption.
type SSESpecification struct {
	_ struct{} `type:"structure"`

	// Indicates whether server-side encryption is enabled (true) or disabled (false)
	// on the cluster.
	//
	// Enabled is a required field
	Enabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation
func (s SSESpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SSESpecification) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SSESpecification) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SSESpecification"}
	if s.Enabled == nil {
		invalidParams.Add(request.NewErrParamRequired("Enabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *SSESpecification) SetEnabled(v bool) *SSESpecification {
	s.Enabled = &v
	return s
}

// An individual VPC security group and its status.
type SecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The unique ID for this security group.
	SecurityGroupIdentifier *string `type:"string"`

	// The status of this security group.
	Status *string `type:"string"`
}

// String returns the string representation
func (s SecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SecurityGroupMembership) GoString() string {
	return s.String()
}

// SetSecurityGroupIdentifier sets the SecurityGroupIdentifier field's value.
func (s *SecurityGroupMembership) SetSecurityGroupIdentifier(v string) *SecurityGroupMembership {
	s.SecurityGroupIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SecurityGroupMembership) SetStatus(v string) *SecurityGroupMembership {
	s.Status = &v
	return s
}

// Represents the subnet associated with a DAX cluster. This parameter refers
// to subnets defined in Amazon Virtual Private Cloud (Amazon VPC) and used
// with DAX.
type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone (AZ) for the subnet.
	SubnetAvailabilityZone *string `type:"string"`

	// The system-assigned identifier for the subnet.
	SubnetIdentifier *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *Subnet) SetSubnetAvailabilityZone(v string) *Subnet {
	s.SubnetAvailabilityZone = &v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *Subnet) SetSubnetIdentifier(v string) *Subnet {
	s.SubnetIdentifier = &v
	return s
}

// Represents the output of one of the following actions:
//
//    * CreateSubnetGroup
//
//    * ModifySubnetGroup
type SubnetGroup struct {
	_ struct{} `type:"structure"`

	// The description of the subnet group.
	Description *string `type:"string"`

	// The name of the subnet group.
	SubnetGroupName *string `type:"string"`

	// A list of subnets associated with the subnet group.
	Subnets []*Subnet `type:"list"`

	// The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s SubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubnetGroup) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SubnetGroup) SetDescription(v string) *SubnetGroup {
	s.Description = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *SubnetGroup) SetSubnetGroupName(v string) *SubnetGroup {
	s.SubnetGroupName = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *SubnetGroup) SetSubnets(v []*Subnet) *SubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *SubnetGroup) SetVpcId(v string) *SubnetGroup {
	s.VpcId = &v
	return s
}

// A description of a tag. Every tag is a key-value pair. You can add up to
// 50 tags to a single DAX cluster.
//
// AWS-assigned tag names and values are automatically assigned the aws: prefix,
// which the user cannot assign. AWS-assigned tag names do not count towards
// the tag limit of 50. User-assigned tag names have the prefix user:.
//
// You cannot backdate the application of a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag. Tag keys are case sensitive. Every DAX cluster can only
	// have one tag with the same key. If you try to add an existing tag (same key),
	// the existing tag value will be updated to the new value.
	Key *string `type:"string"`

	// The value of the tag. Tag values are case-sensitive and can be null.
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the DAX resource to which tags should be added.
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// The tags to be assigned to the DAX resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *TagResourceInput) SetResourceName(v string) *TagResourceInput {
	s.ResourceName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags that are associated with the DAX resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *TagResourceOutput) SetTags(v []*Tag) *TagResourceOutput {
	s.Tags = v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The name of the DAX resource from which the tags should be removed.
	//
	// ResourceName is a required field
	ResourceName *string `type:"string" required:"true"`

	// A list of tag keys. If the DAX cluster has any tags with these keys, then
	// the tags are removed from the cluster.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceName"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceName sets the ResourceName field's value.
func (s *UntagResourceInput) SetResourceName(v string) *UntagResourceInput {
	s.ResourceName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tag keys that have been removed from the cluster.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *UntagResourceOutput) SetTags(v []*Tag) *UntagResourceOutput {
	s.Tags = v
	return s
}

type UpdateClusterInput struct {
	_ struct{} `type:"structure"`

	// The name of the DAX cluster to be modified.
	//
	// ClusterName is a required field
	ClusterName *string `type:"string" required:"true"`

	// A description of the changes being made to the cluster.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) that identifies the topic.
	NotificationTopicArn *string `type:"string"`

	// The current state of the topic.
	NotificationTopicStatus *string `type:"string"`

	// The name of a parameter group for this cluster.
	ParameterGroupName *string `type:"string"`

	// A range of time when maintenance of DAX cluster software will be performed.
	// For example: sun:01:00-sun:09:00. Cluster maintenance normally takes less
	// than 30 minutes, and is performed automatically within the maintenance window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A list of user-specified security group IDs to be assigned to each node in
	// the DAX cluster. If this parameter is not specified, DAX assigns the default
	// VPC security group to each node.
	SecurityGroupIds []*string `type:"list"`
}

// String returns the string representation
func (s UpdateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateClusterInput) SetClusterName(v string) *UpdateClusterInput {
	s.ClusterName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateClusterInput) SetDescription(v string) *UpdateClusterInput {
	s.Description = &v
	return s
}

// SetNotificationTopicArn sets the NotificationTopicArn field's value.
func (s *UpdateClusterInput) SetNotificationTopicArn(v string) *UpdateClusterInput {
	s.NotificationTopicArn = &v
	return s
}

// SetNotificationTopicStatus sets the NotificationTopicStatus field's value.
func (s *UpdateClusterInput) SetNotificationTopicStatus(v string) *UpdateClusterInput {
	s.NotificationTopicStatus = &v
	return s
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *UpdateClusterInput) SetParameterGroupName(v string) *UpdateClusterInput {
	s.ParameterGroupName = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *UpdateClusterInput) SetPreferredMaintenanceWindow(v string) *UpdateClusterInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateClusterInput) SetSecurityGroupIds(v []*string) *UpdateClusterInput {
	s.SecurityGroupIds = v
	return s
}

type UpdateClusterOutput struct {
	_ struct{} `type:"structure"`

	// A description of the DAX cluster, after it has been modified.
	Cluster *Cluster `type:"structure"`
}

// String returns the string representation
func (s UpdateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *UpdateClusterOutput) SetCluster(v *Cluster) *UpdateClusterOutput {
	s.Cluster = v
	return s
}

type UpdateParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the parameter group.
	//
	// ParameterGroupName is a required field
	ParameterGroupName *string `type:"string" required:"true"`

	// An array of name-value pairs for the parameters in the group. Each element
	// in the array represents a single parameter.
	//
	// ParameterNameValues is a required field
	ParameterNameValues []*ParameterNameValue `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateParameterGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateParameterGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateParameterGroupInput"}
	if s.ParameterGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterGroupName"))
	}
	if s.ParameterNameValues == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterNameValues"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterGroupName sets the ParameterGroupName field's value.
func (s *UpdateParameterGroupInput) SetParameterGroupName(v string) *UpdateParameterGroupInput {
	s.ParameterGroupName = &v
	return s
}

// SetParameterNameValues sets the ParameterNameValues field's value.
func (s *UpdateParameterGroupInput) SetParameterNameValues(v []*ParameterNameValue) *UpdateParameterGroupInput {
	s.ParameterNameValues = v
	return s
}

type UpdateParameterGroupOutput struct {
	_ struct{} `type:"structure"`

	// The parameter group that has been modified.
	ParameterGroup *ParameterGroup `type:"structure"`
}

// String returns the string representation
func (s UpdateParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateParameterGroupOutput) GoString() string {
	return s.String()
}

// SetParameterGroup sets the ParameterGroup field's value.
func (s *UpdateParameterGroupOutput) SetParameterGroup(v *ParameterGroup) *UpdateParameterGroupOutput {
	s.ParameterGroup = v
	return s
}

type UpdateSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description of the subnet group.
	Description *string `type:"string"`

	// The name of the subnet group.
	//
	// SubnetGroupName is a required field
	SubnetGroupName *string `type:"string" required:"true"`

	// A list of subnet IDs in the subnet group.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s UpdateSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSubnetGroupInput"}
	if s.SubnetGroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateSubnetGroupInput) SetDescription(v string) *UpdateSubnetGroupInput {
	s.Description = &v
	return s
}

// SetSubnetGroupName sets the SubnetGroupName field's value.
func (s *UpdateSubnetGroupInput) SetSubnetGroupName(v string) *UpdateSubnetGroupInput {
	s.SubnetGroupName = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateSubnetGroupInput) SetSubnetIds(v []*string) *UpdateSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type UpdateSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The subnet group that has been modified.
	SubnetGroup *SubnetGroup `type:"structure"`
}

// String returns the string representation
func (s UpdateSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetSubnetGroup sets the SubnetGroup field's value.
func (s *UpdateSubnetGroupOutput) SetSubnetGroup(v *SubnetGroup) *UpdateSubnetGroupOutput {
	s.SubnetGroup = v
	return s
}

const (
	// ChangeTypeImmediate is a ChangeType enum value
	ChangeTypeImmediate = "IMMEDIATE"

	// ChangeTypeRequiresReboot is a ChangeType enum value
	ChangeTypeRequiresReboot = "REQUIRES_REBOOT"
)

const (
	// IsModifiableTrue is a IsModifiable enum value
	IsModifiableTrue = "TRUE"

	// IsModifiableFalse is a IsModifiable enum value
	IsModifiableFalse = "FALSE"

	// IsModifiableConditional is a IsModifiable enum value
	IsModifiableConditional = "CONDITIONAL"
)

const (
	// ParameterTypeDefault is a ParameterType enum value
	ParameterTypeDefault = "DEFAULT"

	// ParameterTypeNodeTypeSpecific is a ParameterType enum value
	ParameterTypeNodeTypeSpecific = "NODE_TYPE_SPECIFIC"
)

const (
	// SSEStatusEnabling is a SSEStatus enum value
	SSEStatusEnabling = "ENABLING"

	// SSEStatusEnabled is a SSEStatus enum value
	SSEStatusEnabled = "ENABLED"

	// SSEStatusDisabling is a SSEStatus enum value
	SSEStatusDisabling = "DISABLING"

	// SSEStatusDisabled is a SSEStatus enum value
	SSEStatusDisabled = "DISABLED"
)

const (
	// SourceTypeCluster is a SourceType enum value
	SourceTypeCluster = "CLUSTER"

	// SourceTypeParameterGroup is a SourceType enum value
	SourceTypeParameterGroup = "PARAMETER_GROUP"

	// SourceTypeSubnetGroup is a SourceType enum value
	SourceTypeSubnetGroup = "SUBNET_GROUP"
)
