static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" * Copyright 2010 Alexia Death                                                \n"
" *                                                                            \n"
" * Based on \"Kaleidoscope\" GIMP plugin                                      \n"
" * Copyright (C) 1999, 2002 Kelly Martin, updated 2005 by Matthew Plough      \n"
" * kelly@gimp.org                                                             \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (m_angle, _(\"Mirror rotation\"), 0.0)                        \n"
"    description (_(\"Rotation applied to the mirrors\"))                      \n"
"    value_range (0.0, 180.0)                                                  \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_double (r_angle, _(\"Result rotation\"), 0.0)                        \n"
"    description (_(\"Rotation applied to the result\"))                       \n"
"    value_range (0.0, 360.0)                                                  \n"
"    ui_meta     (\"unit\", \"degree\")                                        \n"
"                                                                              \n"
"property_int    (n_segs, _(\"Mirrors\"), 6)                                   \n"
"    description (_(\"Number of mirrors to use\"))                             \n"
"    value_range (2, 24)                                                       \n"
"                                                                              \n"
"property_double (c_x, _(\"Offset X\"), 0.5)                                   \n"
"    description (_(\"position of symmetry center in output\"))                \n"
"    value_range (0.0, 1.0)                                                    \n"
"    ui_meta     (\"unit\", \"relative-coordinate\")                           \n"
"    ui_meta     (\"axis\", \"x\")                                             \n"
"                                                                              \n"
"property_double (c_y, _(\"Offset Y\"), 0.5)                                   \n"
"    description (_(\"position of symmetry center in output\"))                \n"
"    value_range (0.0, 1.0)                                                    \n"
"    ui_meta     (\"unit\", \"relative-coordinate\")                           \n"
"    ui_meta     (\"axis\", \"y\")                                             \n"
"                                                                              \n"
"property_double (o_x, _(\"Center X\"), 0.0)                                   \n"
"    description (_(\"X axis ratio for the center of mirroring\"))             \n"
"    value_range (-1.0, 1.0)                                                   \n"
"    ui_meta     (\"unit\", \"relative-coordinate\")                           \n"
"                                                                              \n"
"property_double (o_y, _(\"Center Y\"), 0.0)                                   \n"
"    description (_(\"Y axis ratio for the center of mirroring\"))             \n"
"    value_range (-1.0, 1.0)                                                   \n"
"    ui_meta     (\"unit\", \"relative-coordinate\")                           \n"
"                                                                              \n"
"property_double (trim_x, _(\"Trim X\"), 0.0)                                  \n"
"    description (_(\"X axis ratio for trimming mirror expanse\"))             \n"
"    value_range (0.0, 0.5)                                                    \n"
"                                                                              \n"
"property_double (trim_y, _(\"Trim Y\"), 0.0)                                  \n"
"    description (_(\"Y axis ratio for trimming mirror expanse\"))             \n"
"    value_range (0.0, 0.5)                                                    \n"
"                                                                              \n"
"property_double (input_scale, _(\"Zoom\"), 100.0)                             \n"
"    description (_(\"Scale factor to make rendering size bigger\"))           \n"
"    value_range (0.1, 100.0)                                                  \n"
"                                                                              \n"
"property_double (output_scale, _(\"Expand\"), 1.0)                            \n"
"    description (_(\"Scale factor to make rendering size bigger\"))           \n"
"    value_range (0.0, 100.0)                                                  \n"
"                                                                              \n"
"property_boolean (clip, _(\"Clip result to input size\"), TRUE)               \n"
"                                                                              \n"
"property_boolean (warp, _(\"Wrap input\"), TRUE)                              \n"
"    description (_(\"Fill full output area\"))                                \n"
"                                                                              \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE mirrors.c                                            \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#if 0                                                                         \n"
"#define TRACE       /* Define this to see basic tracing info. */              \n"
"#endif                                                                        \n"
"                                                                              \n"
"#if 0                                                                         \n"
"#define DO_NOT_USE_BUFFER_SAMPLE       /* Define this to disable buffer sample.*/\n"
"#endif                                                                        \n"
"                                                                              \n"
"static int                                                                    \n"
"calc_undistorted_coords(double wx, double wy,                                 \n"
"                        double angle1, double angle2, int nsegs,              \n"
"                        double cen_x, double cen_y,                           \n"
"                        double off_x, double off_y,                           \n"
"                        double *x, double *y)                                 \n"
"{                                                                             \n"
"  double dx, dy;                                                              \n"
"  double r, ang;                                                              \n"
"                                                                              \n"
"  double awidth = G_PI/nsegs;                                                 \n"
"  double mult;                                                                \n"
"                                                                              \n"
"  dx = wx - cen_x;                                                            \n"
"  dy = wy - cen_y;                                                            \n"
"                                                                              \n"
"  r = sqrt(dx*dx+dy*dy);                                                      \n"
"  if (r == 0.0) {                                                             \n"
"    *x = wx + off_x;                                                          \n"
"    *y = wy + off_y;                                                          \n"
"    return TRUE;                                                              \n"
"  }                                                                           \n"
"                                                                              \n"
"  ang = atan2(dy,dx) - angle1 - angle2;                                       \n"
"  if (ang<0.0) ang = 2*G_PI - fmod (fabs (ang), 2*G_PI);                      \n"
"                                                                              \n"
"  mult = ceil(ang/awidth) - 1;                                                \n"
"  ang = ang - mult*awidth;                                                    \n"
"  if (((int) mult) % 2 == 1) ang = awidth - ang;                              \n"
"  ang = ang + angle1;                                                         \n"
"                                                                              \n"
"  *x = r*cos(ang) + off_x;                                                    \n"
"  *y = r*sin(ang) + off_y;                                                    \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"} /* calc_undistorted_coords */                                               \n"
"                                                                              \n"
"/* Apply the actual transform */                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"apply_mirror (double               mirror_angle,                              \n"
"              double               result_angle,                              \n"
"              int                  nsegs,                                     \n"
"              double               cen_x,                                     \n"
"              double               cen_y,                                     \n"
"              double               off_x,                                     \n"
"              double               off_y,                                     \n"
"              double               input_scale,                               \n"
"              gboolean             clip,                                      \n"
"              gboolean             warp,                                      \n"
"              const Babl          *format,                                    \n"
"              GeglBuffer          *src,                                       \n"
"              GeglRectangle       *in_boundary,                               \n"
"              GeglBuffer          *dst,                                       \n"
"              GeglRectangle       *boundary,                                  \n"
"              const GeglRectangle *roi,                                       \n"
"              gint                 level)                                     \n"
"{                                                                             \n"
"  gfloat *dst_buf;                                                            \n"
"  gint    row, col;                                                           \n"
"  gdouble cx, cy;                                                             \n"
"                                                                              \n"
"  /* Get src pixels. */                                                       \n"
"                                                                              \n"
"  #ifdef TRACE                                                                \n"
"    g_warning (\"> mirror marker1, boundary x:%d, y:%d, w:%d, h:%d, center: (%f, %f) offset: (%f, %f)\", boundary->x, boundary->y, boundary->width, boundary->height, cen_x, cen_y, off_x,off_y );\n"
"  #endif                                                                      \n"
"                                                                              \n"
"  #ifdef DO_NOT_USE_BUFFER_SAMPLE                                             \n"
"    src_buf = g_new0 (gfloat, boundary->width * boundary->height * 4);        \n"
"    gegl_buffer_get (src, 1.0, boundary, format, src_buf, GEGL_AUTO_ROWSTRIDE);\n"
"  #endif                                                                      \n"
"  /* Get buffer in which to place dst pixels. */                              \n"
"  dst_buf = g_new0 (gfloat, roi->width * roi->height * 4);                    \n"
"                                                                              \n"
"  mirror_angle   = mirror_angle * G_PI / 180;                                 \n"
"  result_angle   = result_angle * G_PI / 180;                                 \n"
"                                                                              \n"
"  for (row = 0; row < roi->height; row++) {                                   \n"
"    for (col = 0; col < roi->width; col++) {                                  \n"
"        calc_undistorted_coords(roi->x + col + 0.01, roi->y + row - 0.01, mirror_angle, result_angle,\n"
"                                  nsegs,                                      \n"
"                                  cen_x, cen_y,                               \n"
"                                  off_x * input_scale, off_y * input_scale,   \n"
"                                  &cx, &cy);                                  \n"
"                                                                              \n"
"                                                                              \n"
"  /* apply scale*/                                                            \n"
"  cx = in_boundary->x + (cx - in_boundary->x) / input_scale;                  \n"
"  cy = in_boundary->y + (cy - in_boundary->y) / input_scale;                  \n"
"                                                                              \n"
"        /*Warping*/                                                           \n"
"        if (warp)                                                             \n"
"          {                                                                   \n"
"            double dx = cx - in_boundary->x;                                  \n"
"            double dy = cy - in_boundary->y;                                  \n"
"                                                                              \n"
"            double width_overrun = ceil ((dx) / (in_boundary->width)) ;       \n"
"            double height_overrun = ceil ((dy) / (in_boundary->height));      \n"
"                                                                              \n"
"            if (cx <= (in_boundary->x))                                       \n"
"              {                                                               \n"
"                if ( fabs (fmod (width_overrun, 2)) < 1.0)                    \n"
"                  cx = in_boundary->x - fmod (dx, in_boundary->width);        \n"
"                else                                                          \n"
"                  cx = in_boundary->x + in_boundary->width + fmod (dx, in_boundary->width);\n"
"              }                                                               \n"
"                                                                              \n"
"            if (cy <= (in_boundary->y))                                       \n"
"              {                                                               \n"
"                if ( fabs (fmod (height_overrun, 2)) < 1.0)                   \n"
"                  cy = in_boundary->y + fmod (dy, in_boundary->height);       \n"
"                else                                                          \n"
"                  cy = in_boundary->y + in_boundary->height - fmod (dy, in_boundary->height);\n"
"              }                                                               \n"
"                                                                              \n"
"            if (cx >= (in_boundary->x + in_boundary->width))                  \n"
"              {                                                               \n"
"                if ( fabs (fmod (width_overrun, 2)) < 1.0)                    \n"
"                  cx = in_boundary->x + in_boundary->width - fmod (dx, in_boundary->width);\n"
"                else                                                          \n"
"                  cx = in_boundary->x + fmod (dx, in_boundary->width);        \n"
"              }                                                               \n"
"                                                                              \n"
"            if (cy >= (in_boundary->y + in_boundary->height))                 \n"
"              {                                                               \n"
"                if ( fabs (fmod (height_overrun, 2)) < 1.0)                   \n"
"                  cy = in_boundary->y + in_boundary->height - fmod (dy, in_boundary->height);\n"
"                else                                                          \n"
"                  cy = in_boundary->y + fmod (dy, in_boundary->height);       \n"
"              }                                                               \n"
"          }                                                                   \n"
"        else /* cliping */                                                    \n"
"          {                                                                   \n"
"            if (cx < boundary->x)                                             \n"
"              cx = 0;                                                         \n"
"            if (cy < boundary->x)                                             \n"
"              cy = 0;                                                         \n"
"                                                                              \n"
"            if (cx >= boundary->width)                                        \n"
"              cx = boundary->width - 1;                                       \n"
"            if (cy >= boundary->height)                                       \n"
"              cy = boundary->height -1;                                       \n"
"        }                                                                     \n"
"                                                                              \n"
"                                                                              \n"
"        /* Top */                                                             \n"
"#ifdef DO_NOT_USE_BUFFER_SAMPLE                                               \n"
"                                                                              \n"
"        if (cx >= 0.0)                                                        \n"
"          ix = (int) cx;                                                      \n"
"        else                                                                  \n"
"          ix = -((int) -cx + 1);                                              \n"
"                                                                              \n"
"        if (cy >= 0.0)                                                        \n"
"          iy = (int) cy;                                                      \n"
"        else                                                                  \n"
"          iy = -((int) -cy + 1);                                              \n"
"                                                                              \n"
"        spx_pos = (iy * boundary->width + ix) * 4;                            \n"
"#endif                                                                        \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"#ifndef DO_NOT_USE_BUFFER_SAMPLE                                              \n"
"        gegl_buffer_sample_at_level (src, cx, cy, NULL, &dst_buf[(row * roi->width + col) * 4], format, level, GEGL_SAMPLER_LINEAR, GEGL_ABYSS_NONE);\n"
"#endif                                                                        \n"
"                                                                              \n"
"#ifdef DO_NOT_USE_BUFFER_SAMPLE                                               \n"
"         dst_buf[dpx_pos]     = src_buf[spx_pos];                             \n"
"         dst_buf[dpx_pos + 1] = src_buf[spx_pos + 1];                         \n"
"         dst_buf[dpx_pos + 2] = src_buf[spx_pos + 2];                         \n"
"         dst_buf[dpx_pos + 3] = src_buf[spx_pos + 3];                         \n"
"#endif                                                                        \n"
"                                                                              \n"
"    } /* for */                                                               \n"
"  } /* for */                                                                 \n"
"                                                                              \n"
"    gegl_buffer_sample_cleanup(src);                                          \n"
"                                                                              \n"
"  /* Store dst pixels. */                                                     \n"
"  gegl_buffer_set (dst, roi, 0, format, dst_buf, GEGL_AUTO_ROWSTRIDE);        \n"
"                                                                              \n"
"  /* Free acquired storage. */                                                \n"
"#ifdef DO_NOT_USE_BUFFER_SAMPLE                                               \n"
"  g_free (src_buf);                                                           \n"
"#endif                                                                        \n"
"  g_free (dst_buf);                                                           \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/*****************************************************************************/\n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_effective_area (GeglOperation *operation)                                 \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gdouble xt = o->trim_x * in_rect->width;                                    \n"
"  gdouble yt = o->trim_y * in_rect->height;                                   \n"
"                                                                              \n"
"  gegl_rectangle_copy(&result, in_rect);                                      \n"
"                                                                              \n"
"  /*Applying trims*/                                                          \n"
"                                                                              \n"
"  result.x = result.x + xt;                                                   \n"
"  result.y = result.y + yt;                                                   \n"
"  result.width = result.width - xt;                                           \n"
"  result.height = result.height - yt;                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/* Compute the region for which this operation is defined.                    \n"
" */                                                                           \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle  result = {0,0,0,0};                                          \n"
"  GeglRectangle *in_rect = gegl_operation_source_get_bounding_box (operation, \"input\");\n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (!in_rect){                                                              \n"
"        return result;                                                        \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (o->clip) {                                                              \n"
"    gegl_rectangle_copy(&result, in_rect);                                    \n"
"  }                                                                           \n"
"  else {                                                                      \n"
"    result.x = in_rect->x;                                                    \n"
"    result.y = in_rect->y;                                                    \n"
"    result.width = result.height = sqrt (in_rect->width * in_rect->width + in_rect->height * in_rect->height) * MAX ((o->o_x + 1),  (o->o_y + 1)) * 2;\n"
"  }                                                                           \n"
"                                                                              \n"
"  result.width = result.width * o->output_scale;                              \n"
"  result.height = result.height * o->output_scale;                            \n"
"                                                                              \n"
"  #ifdef TRACE                                                                \n"
"    g_warning (\"< get_bounding_box result = %dx%d+%d+%d\", result.width, result.height, result.x, result.y);\n"
"  #endif                                                                      \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/* Compute the input rectangle required to compute the specified region of interest (roi).\n"
" */                                                                           \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglRectangle  result = get_effective_area (operation);                     \n"
"                                                                              \n"
"  #ifdef TRACE                                                                \n"
"    g_warning (\"> get_required_for_output src=%dx%d+%d+%d\", result.width, result.height, result.x, result.y);\n"
"    if (roi)                                                                  \n"
"      g_warning (\"  ROI == %dx%d+%d+%d\", roi->width, roi->height, roi->x, roi->y);\n"
"  #endif                                                                      \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"/* Specify the input and output buffer formats.                               \n"
" */                                                                           \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RaGaBaA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RaGaBaA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"/* Perform the specified operation.                                           \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o            = GEGL_PROPERTIES (operation);                 \n"
"  GeglRectangle   boundary     = gegl_operation_get_bounding_box (operation); \n"
"  GeglRectangle   eff_boundary = get_effective_area (operation);              \n"
"  const Babl     *format       = babl_format (\"RaGaBaA float\");             \n"
"                                                                              \n"
"#ifdef DO_NOT_USE_BUFFER_SAMPLE                                               \n"
" g_warning (\"NOT USING BUFFER SAMPLE!\");                                    \n"
"#endif                                                                        \n"
"  apply_mirror (o->m_angle,                                                   \n"
"                o->r_angle,                                                   \n"
"                o->n_segs,                                                    \n"
"                o->c_x * boundary.width,                                      \n"
"                o->c_y * boundary.height,                                     \n"
"                o->o_x * (eff_boundary.width  - eff_boundary.x) + eff_boundary.x,\n"
"                o->o_y * (eff_boundary.height - eff_boundary.y) + eff_boundary.y,\n"
"                o->input_scale / 100,                                         \n"
"                o->clip,                                                      \n"
"                o->warp,                                                      \n"
"                format,                                                       \n"
"                input,                                                        \n"
"                &eff_boundary,                                                \n"
"                output,                                                       \n"
"                &boundary,                                                    \n"
"                result,                                                       \n"
"                level);                                                       \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",               \"gegl:mirrors\",                                 \n"
"    \"title\",              _(\"Kaleidoscopic Mirroring\"),                   \n"
"    \"position-dependent\", \"true\",                                         \n"
"    \"categories\",         \"blur\",                                         \n"
"    \"description\",        _(\"Create a kaleidoscope like effect.\"),        \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
