/*
  propertycontrollerextension.cpp

  This file is part of GammaRay, the Qt application inspection and
  manipulation tool.

  Copyright (C) 2014-2021 Klarälvdalens Datakonsult AB, a KDAB Group company, info@kdab.com
  Author: Anton Kreuzkamp <anton.kreuzkamp@kdab.com>

  Licensees holding valid commercial KDAB GammaRay licenses may use this file in
  accordance with GammaRay Commercial License Agreement provided with the Software.

  Contact info@kdab.com if any conditions of this licensing are not clear to you.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "propertycontrollerextension.h"

using namespace GammaRay;

PropertyControllerExtension::PropertyControllerExtension(const QString &name)
    : m_name(name)
{
}

PropertyControllerExtension::~PropertyControllerExtension() = default;

QString PropertyControllerExtension::name() const
{
    return m_name;
}

bool PropertyControllerExtension::setObject(void *object, const QString &typeName)
{
    Q_UNUSED(object);
    Q_UNUSED(typeName);
    return false;
}

bool PropertyControllerExtension::setQObject(QObject *object)
{
    Q_UNUSED(object);
    return false;
}

bool PropertyControllerExtension::setMetaObject(const QMetaObject *metaObject)
{
    Q_UNUSED(metaObject);
    return false;
}
