/*******************************************************************
 * libfaxophone                                                    *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file phone.h
 * \brief Phone handling header
 */

#ifndef PHONE_H
#define PHONE_H

#define PHONE_CIP	0x04

struct sCapiConnection *phoneCall( unsigned char nController, const char *pnSource, const char *pnTarget, unsigned char nAnonymous );
void phoneMute( struct sCapiConnection *psConnection, unsigned char nMute );
void phoneHold( struct sCapiConnection *psConnection, unsigned char nRecord );
void phoneRecord( struct sCapiConnection *psConnection, unsigned char nHold );
void phoneSendDtmfCode( struct sCapiConnection *psConnection, unsigned char nCode );
void phoneHangup( struct sCapiConnection *psConnection );
int phonePickup( struct sCapiConnection *psConnection );
void phoneTransfer( struct sCapiConnection *psConnection, _cmsg sMessage );
void phoneFlush( struct sCapiConnection *psConnection );

int recordingWrite( struct sRecorder *psRecorder, short *pnBuf, int nSize, int nChannel );

#endif
