/*******************************************************************
 * libfaxophone                                                    *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file debug.h
 * \brief Debug related header
 */

#ifndef DEBUG_H
#define DEBUG_H

#define FopDebug2(level, format...)\
	do {\
	} while ( 0 )

#define FopDebug(level, format...)\
	do {\
		if ( level >= nFaxophoneLogLevel ) {\
			FopDebugIntern( level, __FUNCTION__, format );\
		}\
	} while ( 0 )

enum {
	FOP_TRANSFER = 0,
	FOP_DEBUG,
	FOP_ERROR,
	FOP_INFO
} eFaxophoneDebug;

extern unsigned char nFaxophoneLogLevel;

void FopDebugIntern( unsigned char nLevel, const char *pnName, char *pnFormat, ... );

char *getLineAccessCode( void );
char *getAreaCode( void );
char *getCountryCode( void );

#endif
