/*
FatRat download manager
http://fatrat.dolezel.info

Copyright (C) 2006-2008 Lubos Dolezel <lubos a dolezel.info>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
version 2 as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#ifndef CZSHAREDOWNLOAD_H
#define CZSHAREDOWNLOAD_H
#include <fatrat/engines/CurlDownload.h>
#include <QHttpResponseHeader>
#include <fatrat/WidgetHostChild.h>
#include "ui_CzshareDownloadForm.h"

class QHttp;
class QBuffer;

class CzshareDownload : public CurlDownload
{
Q_OBJECT
public:
	CzshareDownload();
	virtual void init(QString source, QString target);
	virtual QString myClass() const { return "CzshareDownload"; }
	virtual QString name() const;
	
	virtual void load(const QDomNode& map);
	virtual void save(QDomDocument& doc, QDomNode& map) const;
	virtual void changeActive(bool bActive);
	
	static Transfer* createInstance() { return new CzshareDownload; }
	static int acceptable(QString uri, bool);
	static void globalInit();

	virtual WidgetHostChild* createOptionsWidget(QWidget* w);
	virtual void fillContextMenu(QMenu& menu);
	
	virtual QString object() const { return m_strTarget; }
	virtual void setObject(QString newdir);
	
	void headersStep1(const QHttpResponseHeader& hdr);
	void headersStep2(const QHttpResponseHeader& hdr);
protected slots:
	void convertLink();
	void authHeaders(const QHttpResponseHeader&);
	void requestDone(bool error);
protected:
	QString m_strOriginal, m_strTarget, m_strConverted, m_strSessID;
	QString m_strUser, m_strPassword;
	QHttp* m_http;
	QBuffer* m_buffer;
	int m_step;
	
	friend class CzshareDownloadForm;
};

class CzshareDownloadForm : public QObject, public WidgetHostChild, Ui_CzshareDownloadForm
{
public:
    CzshareDownloadForm(QWidget* me, CzshareDownload* myobj);
    virtual void load();
    virtual void accepted();
private:
    CzshareDownload* m_myobj;
};

#endif
