(defun newstr1 (s)
  (let* ((l (length s)) (I 0) (j 0) (ns (make-string l)) (ch))
     (while (< i (1- l))
	(if (and (eql #\^ (char s i))
		 (alpha-char-p (setq ch (char s (1+ i)))))
	    (setf (char ns j) (- ch #x40)  i (1+ i)))
	    (setf i (1+ i) j (1+ j)))
     (subseq ns 0 j)))

(defun newstr (s)
   (if (stringp s)
       (newstr1 s)
       (if (consp s)
	   (cons (newstr (car s)) (newstr (cdr s)))
	   s)))

(defun newstrfile (infile outfile)
  (let (s (eof (gensym)))
    (with-open-file (of outfile :direction :output)
       (with-open-file (if infile)
	 (loop
	   (setq s (read if nil eof))
	   (if (eq s eof) (return-from newstrfile nil))
	   (print (newstr s) of))))) )

(defun allnewstrfile (dir)
   (dolist (d (directory dir))
	(when (substringp "HELP" d)
	   (unix:unlink "temp")
	   (newstrfile d "temp")
	   (unix:unlink d)
	   (unix:system (format nil "mv temp ~A" d))) )
)
