/* -*- Mode: C++; tab-width: 4 -*- */
/* vi: set ts=4 sw=4 noexpandtab: */

/*
 * Copyright (C) 2009, 2010 Florian Weimer <fw@deneb.enyo.de>
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef DIAGNOSTICS__EXTENSIONS__STACKTRACE__ERROR__INCLUDE_GUARD
#define DIAGNOSTICS__EXTENSIONS__STACKTRACE__ERROR__INCLUDE_GUARD

#include <diagnostics/frame/namespace.hpp>
#include <diagnostics/extensions/stacktrace/namespace.hpp>

#include <stdexcept>

DIAGNOSTICS_NAMESPACE_BEGIN;
STACKTRACE_NAMESAPCE_BEGIN;
namespace POSIX {

class Error : public std::runtime_error {
public:
  Error(); // use global errno variable
  Error(int code);
  virtual ~Error() throw ();

  int Code() const { return code; }

  // Throws error if false, using the global errno value.
  static void Unless(bool flag)
  {
    if (!flag) {
      Throw();
    }
  }
    
  virtual char const * name() const { return "POSIX::Error"; }

private:
  int code;
  static void Throw() __attribute__((noreturn));
};

// Similar to strerror.
std::string ErrorString(int code);

} // Enyo::POSIX
STACKTRACE_NAMESAPCE_END;
DIAGNOSTICS_NAMESPACE_END;

#endif

