# Copyright © 2012-2013 Piotr Ożarowski <piotr@debian.org>
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

from typing import override

from dhpython.build.base import Base, shell_command, copy_test_files
from dhpython.build.types import Args, Context


class BuildSystem(Base):
    DESCRIPTION = 'use --*-args options to configure this system'
    SUPPORTED_INTERPRETERS = True  # all interpreters

    @shell_command
    @override
    def clean(self, context: Context, args: Args) -> str:
        super().clean(context, args)
        return args.args

    @shell_command
    @override
    def configure(self, context: Context, args: Args) -> str:
        return args.args

    @shell_command
    @override
    def build(self, context: Context, args: Args) -> str:
        return args.args

    @shell_command
    @override
    def install(self, context: Context, args: Args) -> str:
        return args.args

    @copy_test_files()
    @shell_command
    @override
    def test(self, context: Context, args: Args) -> str:
        return args.args or super().test_cmd(context, args)
