# -*- perl -*-
#
# Copyright (C) 2015       Ian Jackson
#
# Some bits stolen from the proper Dpkg::Changelog::Parse
# (from dpkg-dev 1.16.16):
#
# Copyright (C) 2005, 2007 Frank Lichtenheld <frank@lichtenheld.de>
# Copyright (C) 2009       Raphael Hertzog <hertzog@debian.org>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Dpkg::Changelog::Parse;

use strict;
use warnings;

our $VERSION = "1.00";

use Dpkg::Control::Changelog;

use base qw(Exporter);
our @EXPORT = qw(changelog_parse);

sub changelog_parse {
    my (%options) = @_; # ignored

    $options{'file'} //= 'debian/changelog';

    open P, "dpkg-parsechangelog -l$options{'file'} |" or die $!;

    my $fields = Dpkg::Control::Changelog->new();
    $fields->parse(\*P, "output of stunt changelog parser");

    close P or die "$! $?";

    return $fields;
}
