% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-DBIResult.R, R/dbGetInfo.R
\name{dbGetInfo}
\alias{dbGetInfo}
\title{Get DBMS metadata}
\usage{
dbGetInfo(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}
}
\value{
For objects of class \linkS4class{DBIDriver}, \code{dbGetInfo()}
returns a named list
that contains at least the following components:
\itemize{
\item \code{driver.version}: the package version of the DBI backend,
\item \code{client.version}: the version of the DBMS client library.
}

For objects of class \linkS4class{DBIConnection}, \code{dbGetInfo()}
returns a named list
that contains at least the following components:
\itemize{
\item \code{db.version}: version of the database server,
\item \code{dbname}: database name,
\item \code{username}: username to connect to the database,
\item \code{host}: hostname of the database server,
\item \code{port}: port on the database server.
It must not contain a \code{password} component.
Components that are not applicable should be set to \code{NA}.
}

For objects of class \linkS4class{DBIResult}, \code{dbGetInfo()}
returns a named list
that contains at least the following components:
\itemize{
\item \code{statatment}: the statement used with \code{\link[=dbSendQuery]{dbSendQuery()}} or \code{\link[=dbExecute]{dbExecute()}},
as returned by \code{\link[=dbGetStatement]{dbGetStatement()}},
\item \code{row.count}: the number of rows fetched so far (for queries),
as returned by \code{\link[=dbGetRowCount]{dbGetRowCount()}},
\item \code{rows.affected}: the number of rows affected (for statements),
as returned by \code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}}
\item \code{has.completed}: a logical that indicates
if the query or statement has completed,
as returned by \code{\link[=dbHasCompleted]{dbHasCompleted()}}.
}
}
\description{
Retrieves information on objects of class \linkS4class{DBIDriver},
\linkS4class{DBIConnection} or \linkS4class{DBIResult}.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbGetInfo")}
}
\section{Implementation notes}{

The default implementation for \verb{DBIResult objects}
constructs such a list from the return values of the corresponding methods,
\code{\link[=dbGetStatement]{dbGetStatement()}}, \code{\link[=dbGetRowCount]{dbGetRowCount()}},
\code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}}, and \code{\link[=dbHasCompleted]{dbHasCompleted()}}.
}

\seealso{
Other DBIDriver generics: 
\code{\link{DBIDriver-class}},
\code{\link{dbCanConnect}()},
\code{\link{dbConnect}()},
\code{\link{dbDataType}()},
\code{\link{dbDriver}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListConnections}()}

Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbAppendTableArrow}()},
\code{\link{dbCreateTable}()},
\code{\link{dbCreateTableArrow}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetQuery}()},
\code{\link{dbGetQueryArrow}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbReadTable}()},
\code{\link{dbReadTableArrow}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendQueryArrow}()},
\code{\link{dbSendStatement}()},
\code{\link{dbUnquoteIdentifier}()},
\code{\link{dbWriteTable}()},
\code{\link{dbWriteTableArrow}()}

Other DBIResult generics: 
\code{\link{DBIResult-class}},
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbColumnInfo}()},
\code{\link{dbFetch}()},
\code{\link{dbGetRowCount}()},
\code{\link{dbGetRowsAffected}()},
\code{\link{dbGetStatement}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbIsValid}()},
\code{\link{dbQuoteLiteral}()},
\code{\link{dbQuoteString}()}
}
\concept{DBIConnection generics}
\concept{DBIDriver generics}
\concept{DBIResult generics}
