
# NACO_SET_PREFIX(PREFIX)
#---------------------------
AC_DEFUN([NACO_SET_PREFIX],
[
    unset CDPATH
    # make $PIPE_HOME the default for the installation
    AC_PREFIX_DEFAULT($1)

    if test "x$prefix" = "xNONE"; then
        prefix=$ac_default_prefix
        ac_configure_args="$ac_configure_args --prefix $prefix"
    fi

    if test "x$exec_prefix" = "xNONE"; then
        exec_prefix=$prefix
    fi

])


# NACO_SET_VERSION_INFO(VERSION, [CURRENT], [REVISION], [AGE])
#----------------------------------------------------------------
# Setup various version information, especially the libtool versioning
AC_DEFUN([NACO_SET_VERSION_INFO],
[
    naco_version=`echo "$1" | sed -e 's/[[a-z,A-Z]].*$//'`

    naco_major_version=`echo "$naco_version" | \
        sed 's/\([[0-9]]*\).\(.*\)/\1/'`
    naco_minor_version=`echo "$naco_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\)\(.*\)/\2/'`
    naco_micro_version=`echo "$naco_version" | \
        sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`

    if test -z "$naco_major_version"; then naco_major_version=0
    fi

    if test -z "$naco_minor_version"; then naco_minor_version=0
    fi

    if test -z "$naco_micro_version"; then naco_micro_version=0
    fi

    NACO_VERSION="$naco_version"
    NACO_MAJOR_VERSION=$naco_major_version
    NACO_MINOR_VERSION=$naco_minor_version
    NACO_MICRO_VERSION=$naco_micro_version

    if test -z "$4"; then NACO_INTERFACE_AGE=0
    else NACO_INTERFACE_AGE="$4"
    fi

    NACO_BINARY_AGE=`expr 100 '*' $NACO_MINOR_VERSION + $NACO_MICRO_VERSION`
    NACO_BINARY_VERSION=`expr 10000 '*' $NACO_MAJOR_VERSION + \
                          $NACO_BINARY_AGE`

    AC_SUBST(NACO_VERSION)
    AC_SUBST(NACO_MAJOR_VERSION)
    AC_SUBST(NACO_MINOR_VERSION)
    AC_SUBST(NACO_MICRO_VERSION)
    AC_SUBST(NACO_INTERFACE_AGE)
    AC_SUBST(NACO_BINARY_VERSION)
    AC_SUBST(NACO_BINARY_AGE)

    AC_DEFINE_UNQUOTED(NACO_MAJOR_VERSION, $NACO_MAJOR_VERSION,
                       [NACO major version number])
    AC_DEFINE_UNQUOTED(NACO_MINOR_VERSION, $NACO_MINOR_VERSION,
                       [NACO minor version number])
    AC_DEFINE_UNQUOTED(NACO_MICRO_VERSION, $NACO_MICRO_VERSION,
                       [NACO micro version number])
    AC_DEFINE_UNQUOTED(NACO_INTERFACE_AGE, $NACO_INTERFACE_AGE,
                       [NACO interface age])
    AC_DEFINE_UNQUOTED(NACO_BINARY_VERSION, $NACO_BINARY_VERSION,
                       [NACO binary version number])
    AC_DEFINE_UNQUOTED(NACO_BINARY_AGE, $NACO_BINARY_AGE,
                       [NACO binary age])

    ESO_SET_LIBRARY_VERSION([$2], [$3], [$4])
])


# NACO_SET_PATHS
#------------------
# Define auxiliary directories of the installed directory tree.
AC_DEFUN([NACO_SET_PATHS],
[

    if test -z "$plugindir"; then
        plugindir='${libdir}/esopipes-plugins/${PACKAGE}-${VERSION}'
    fi

    if test -z "$pipedocsdir"; then
        pipedocsdir='${datadir}/doc/esopipes/${PACKAGE}-${VERSION}'
    fi
    apidocdir='${pipedocsdir}/html'

    if test -z "$configdir"; then
       configdir='${datadir}/${PACKAGE}/config'
    fi

    if test -z "$privatelibdir"; then
       privatelibdir='${libdir}/${PACKAGE}-${VERSION}'
    fi

    AC_SUBST(plugindir)
    AC_SUBST(apidocdir)
    AC_SUBST(configdir)
    AC_SUBST(privatelibdir)
    AC_SUBST(pipedocsdir)

    # Define a preprocesor symbol for the plugin search paths

    AC_DEFINE_UNQUOTED(NACO_PLUGIN_DIR, "esopipes-plugins",
                       [Plugin directory tree prefix])

    eval plugin_dir="$plugindir"
    plugin_path=`eval echo $plugin_dir | \
                sed -e "s/\/${PACKAGE}-${VERSION}.*$//"`

    AC_DEFINE_UNQUOTED(NACO_PLUGIN_PATH, "$plugin_path",
                       [Absolute path to the plugin directory tree])

])


# NACO_CREATE_SYMBOLS
#-----------------------
# Define include and library related makefile symbols
AC_DEFUN([NACO_CREATE_SYMBOLS],
[

    # Symbols for package include file and library search paths

    NACO_INCLUDES='-I$(top_srcdir)/naco -I$(top_srcdir)/irplib -I$(top_srcdir)/hdrl'
    NACO_LDFLAGS='-L$(top_builddir)/naco'

    # No -L for IRPLIB which is statically linked
    all_includes='$(NACO_INCLUDES) $(CPL_INCLUDES) $(EXTRA_INCLUDES)'
    all_ldflags='$(NACO_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS)'

    # Library aliases

    LIBNACO='$(top_builddir)/naco/libnaco.la'
    LIBIRPLIB='$(top_builddir)/irplib/libirplib.la'

    # Substitute the defined symbols

    AC_SUBST(NACO_INCLUDES)
    AC_SUBST(NACO_LDFLAGS)

    AC_SUBST(LIBNACO)
    AC_SUBST(LIBIRPLIB)

    # Check for CPL and user defined libraries
    AC_REQUIRE([CPL_CHECK_LIBS])
    AC_REQUIRE([ESO_CHECK_EXTRA_LIBS])

    all_includes='$(NACO_INCLUDES) $(CPL_INCLUDES) $(EXTRA_INCLUDES)'
    all_ldflags='$(NACO_LDFLAGS) $(CPL_LDFLAGS) $(EXTRA_LDFLAGS)'

    AC_SUBST(all_includes)
    AC_SUBST(all_ldflags)
])
