(require "asdf")

;; CL-IRONCLAD does not compile against recent SBCL on 32-bit ARM.
;; See Debian bug#1016750.
(when (and (member :sbcl *features*)
	   (member (or (uiop:getenv "DEB_HOST_ARCH")
		       (uiop:stripln
			(uiop:run-program '("dpkg" "--print-architecture")
					  :output :string)))
		   '("armel" "armhf") :test #'string=))
  (uiop:quit 0))

(let ((asdf:*user-cache* (uiop:getenv "AUTOPKGTEST_TMP"))) ; Store FASL in some temporary dir
  (asdf:load-system "ironclad/tests")
  (asdf:load-system "ironclad-text"))

;; Can't use ASDF:TEST-SYSTEM, its return value is meaningless
(unless (rtest:do-tests)
    (uiop:quit 1))
