# CiviCRM 4.7.19

Released May 3, 2017

- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**

## <a name="features"></a>Features

### Backdrop Integration

- **[CRM-17711](https://issues.civicrm.org/jira/browse/CRM-17711) Add Support
  for Backdrop ([10184](https://github.com/civicrm/civicrm-core/pull/10184))
  (completes previous work)**

  Backdrop is a fork of the Drupal project designed to offer a smooth upgrade
  from Drupal 7.  This is now the fourth content management system supported by
  CiviCRM.

### Core CiviCRM

- **[CRM-20420](https://issues.civicrm.org/jira/browse/CRM-20420) Allow
  retention of generated PDFs/Docs
  ([10155](https://github.com/civicrm/civicrm-core/pull/10155))**

  A new option allows for generated PDF and other document files to be
  automatically attached to their corresponding activities.

- **[CRM-19813](https://issues.civicrm.org/jira/browse/CRM-19813) Hook
  priorities and core hooks to support LExIM
  ([10138](https://github.com/civicrm/civicrm-core/pull/10138) and
  [9949](https://github.com/civicrm/civicrm-core/pull/9949))**

  CiviCRM has increasingly relied upon the Symfony framework for providing new
  areas of functionality.  Symfony offers an [EventDispatcher](http://symfony.com/doc/current/components/event_dispatcher.html)
  component that allows for extensions to respond to events and modify values.
  Meanwhile, CiviCRM has long offered a Drupal-style hook system for those
  purposes.

  This change runs hook invocations through the EventDispatcher system to allow
  for a richer feature set for extensions.  This will let core functionality
  become more modular.  [Read the introduction to the pull request for more
  background](https://github.com/civicrm/civicrm-core/pull/9949#issue-212649186)

- **[CRM-20361](https://issues.civicrm.org/jira/browse/CRM-20361) Populate
  tokens when Scheduled Reminders are set to Record Activity for Automated Email
  ([10081](https://github.com/civicrm/civicrm-core/pull/10081))**

  Activities generated by scheduled reminders now have the token values
  populated.  This is valuable for referring to fields that have changed since
  the message was generated.

- **[CRM-20318](https://issues.civicrm.org/jira/browse/CRM-20318) Add is_public
  setting on Custom Groups.
  ([10028](https://github.com/civicrm/civicrm-core/pull/10028))**

  Custom data sets now have an additional setting determining whether the fields
  should be displayed in "public" contexts.  The only current application is for
  events: event custom fields will only display if they are marked as "public".

- **[CRM-20207](https://issues.civicrm.org/jira/browse/CRM-20207) Introduce
  selectWhereClause hook for activity results on activity tab contact summary
  page ([9916](https://github.com/civicrm/civicrm-core/pull/9916))**

  This change increases the coverage of `hook_civicrm_selectWhereClause` to
  include the activity listing on a contact record.

- **[CRM-20312](https://issues.civicrm.org/jira/browse/CRM-20312) Identify and
  fix missing indexes
  ([10109](https://github.com/civicrm/civicrm-core/pull/10109),
  [10106](https://github.com/civicrm/civicrm-core/pull/10106), and
  [10108](https://github.com/civicrm/civicrm-core/pull/10108))**

  A new system check compares the indices on a site's database with those that
  would be expected from the CiviCRM configuration.  (A mismatch can cause
  performance problems.)  A utility now offers to clean up the database's
  indices.

- **[CRM-20313](https://issues.civicrm.org/jira/browse/CRM-20313) Add index to
  civicrm_activity.status_id
  ([10169](https://github.com/civicrm/civicrm-core/pull/10169) and
  [10025](https://github.com/civicrm/civicrm-core/pull/10025))**

  This adds database indices to several commonly-filtered columns in
  `civicrm_activity`, `civicrm_entity_financial_account`, and
  `civicrm_mailing_event_queue`.

- **[CRM-20332](https://issues.civicrm.org/jira/browse/CRM-20332) Refactor
  summaryActions hook to allow user-defined actions in third column
  ([10046](https://github.com/civicrm/civicrm-core/pull/10046))**

  Extension developers can now modify all items in the "Actions" list on a
  contact record using `hook_civicrm_summaryActions`.

- **[CRM-18251](https://issues.civicrm.org/jira/browse/CRM-18251) Pingback
  improvements ([8525](https://github.com/civicrm/civicrm-core/pull/8525))**

  By default, CiviCRM sends basic usage statistics to civicrm.org.  This adds
  the country of the domain's address and the count of delivered mailings to
  those statistics.

- **[CRM-20330](https://issues.civicrm.org/jira/browse/CRM-20330) Generate a
  table with composite primary key
  ([10038](https://github.com/civicrm/civicrm-core/pull/10038))**

  The database schema generation system of CiviCRM now supports the creation of
  tables with composite primary keys: two or more fields in tandem serving as
  the primary key.

- **[CRM-20368](https://issues.civicrm.org/jira/browse/CRM-20368) report
  templates: don't hard-code order bys
  ([10087](https://github.com/civicrm/civicrm-core/pull/10087))**

  Several report templates that had the "order by" clause directly specified in
  code now use the standard sorting options.

- **[CRM-20308](https://issues.civicrm.org/jira/browse/CRM-20308) Activity copy
  is always sent FROM logged in user's email ID
  ([10158](https://github.com/civicrm/civicrm-core/pull/10158),
  [10122](https://github.com/civicrm/civicrm-core/pull/10122),
  and [10163](https://github.com/civicrm/civicrm-core/pull/10163))**

  The from email address for an activity assignment notification will now be
  determined in the following order of preference:

  1. The email address of the source contact of the activity

  2. If that can not be found, the default `from` email address for the domain

  3. If the default `from` email address for the domain can not be found the
     email address of the logged-in user will be used.  This was the prior
     behavior.

- **[CRM-19464](https://issues.civicrm.org/jira/browse/CRM-19464)
  supplemental_address_3 only exists in API
  ([10166](https://github.com/civicrm/civicrm-core/pull/10166) and
  [9857](https://github.com/civicrm/civicrm-core/pull/9857))**

  The Supplemental Address 3 field is now available to view and edit in the UI.

- **Icons for attachments
  ([10078](https://github.com/civicrm/civicrm-core/pull/10078))**

  File attachments now have an icon corresponding to their MIME type.

### CiviCase

- **[CRM-16633](https://issues.civicrm.org/jira/browse/CRM-16633) Case Subject
  not Editable ([10123](https://github.com/civicrm/civicrm-core/pull/10123))**

  Case subjects can now be edited, generating a "Change Case Subject" activity.

- **[CRM-20345](https://issues.civicrm.org/jira/browse/CRM-20345) Sortable
  columns ([10058](https://github.com/civicrm/civicrm-core/pull/10058)) (partial
  work)**

  Cases can now be sorted according to client.

- **[CRM-20105](https://issues.civicrm.org/jira/browse/CRM-20105) Search actions
  ([10188](https://github.com/civicrm/civicrm-core/pull/10188))**

  Cases can now be merged with each other or restored from the trash using the
  API.

- **[CRM-19778](https://issues.civicrm.org/jira/browse/CRM-19778) Allowed
  statuses per case-type
  ([10065](https://github.com/civicrm/civicrm-core/pull/10065)) (completes
  previous work)**

  UI improvements to the case type management screen.

### CiviContribute

- **[CRM-20384](https://issues.civicrm.org/jira/browse/CRM-20384) Bookkeeping
  report add contrib ID, filter by financial account owner (IIDA-85)
  ([10112](https://github.com/civicrm/civicrm-core/pull/10112))**

  Two fields are added as columns and filters on the Bookkeeping Report:
  contribution ID and financial account owner.

- **[CRM-20400](https://issues.civicrm.org/jira/browse/CRM-20400) Update the
  Payment Receipt to use for Contribution payment
  ([10128](https://github.com/civicrm/civicrm-core/pull/10128))**

  The receipt for partial payments has updated language appropriate for use
  besides merely for participant partial payments.

- **[CRM-20264](https://issues.civicrm.org/jira/browse/CRM-20264) Store CC type
  and last 4 digits from Contribution form
  ([10234](https://github.com/civicrm/civicrm-core/pull/10234),
  [10228](https://github.com/civicrm/civicrm-core/pull/10228),
  [10157](https://github.com/civicrm/civicrm-core/pull/10157),
  [10193](https://github.com/civicrm/civicrm-core/pull/10193),
  [10194](https://github.com/civicrm/civicrm-core/pull/10194), and
  [10189](https://github.com/civicrm/civicrm-core/pull/10189))**

  When processing a credit card from the front or back end, the last four digits
  of the card number along with the card type are now stored on the financial
  transaction.

- **[CRM-20158](https://issues.civicrm.org/jira/browse/CRM-20158) Store card
  type and last 4 digits of credit card
  ([9880](https://github.com/civicrm/civicrm-core/pull/9880)) (partially
  complete)**

  This is the parent issue for tracking and retrieving card type and the last
  four digits of the card number on financial transactions.

- **[CRM-20391](https://issues.civicrm.org/jira/browse/CRM-20391) Add
  pan_truncation to search form
  ([10139](https://github.com/civicrm/civicrm-core/pull/10139))**

  The last four digits of a card number are now searchable in the Find
  Contributions search and Advanced Search pane.

- **[CRM-20273](https://issues.civicrm.org/jira/browse/CRM-20273) Add credit
  card type field for Contribution Details Report
  ([9987](https://github.com/civicrm/civicrm-core/pull/9987))**

- **[CRM-20278](https://issues.civicrm.org/jira/browse/CRM-20278) Add credit
  card type field for Top Donor Report
  ([9991](https://github.com/civicrm/civicrm-core/pull/9991))**

- **[CRM-20275](https://issues.civicrm.org/jira/browse/CRM-20275) Add credit
  card type field for Contributions by Organization Report
  ([9989](https://github.com/civicrm/civicrm-core/pull/9989))**

- **[CRM-20277](https://issues.civicrm.org/jira/browse/CRM-20277) Add credit
  card type field for Contributions by Household Report
  ([9990](https://github.com/civicrm/civicrm-core/pull/9990))**

- **[CRM-20279](https://issues.civicrm.org/jira/browse/CRM-20279) Add credit
  card type field for SYBUNT report
  ([9992](https://github.com/civicrm/civicrm-core/pull/9992))**

- **[CRM-20280](https://issues.civicrm.org/jira/browse/CRM-20280) Add credit
  card type field for LYBUNT report
  ([9993](https://github.com/civicrm/civicrm-core/pull/9993))**

- **[CRM-20281](https://issues.civicrm.org/jira/browse/CRM-20281) Add credit
  card type field for Soft Credit Report
  ([9994](https://github.com/civicrm/civicrm-core/pull/9994))**

- **[CRM-20284](https://issues.civicrm.org/jira/browse/CRM-20284) Add credit
  card type field for Contribution Aggregate by Relationship report
  ([9997](https://github.com/civicrm/civicrm-core/pull/9997))**

- **[CRM-20285](https://issues.civicrm.org/jira/browse/CRM-20285) Add credit
  card type field for Recurring Contributions report
  ([10001](https://github.com/civicrm/civicrm-core/pull/10001))**

- **[CRM-20331](https://issues.civicrm.org/jira/browse/CRM-20331) Add card type
  and pan truncation besides payment method
  ([10037](https://github.com/civicrm/civicrm-core/pull/10037))**

  When viewing payment details on a credit card contribution, the credit card
  type and last four digits are displayed if available.

- **[CRM-8526](https://issues.civicrm.org/jira/browse/CRM-8526) Support
  [contribution.custom_nn] tokens in templates
  ([9848](https://github.com/civicrm/civicrm-core/pull/9848)) (completes
  previous work)**

  CiviCRM can now process tokens for contribution custom fields (most lately in
  emails sent from search results).

- **[CRM-20379](https://issues.civicrm.org/jira/browse/CRM-20379) Move payment
  details above less important sections on backoffice form
  ([10101](https://github.com/civicrm/civicrm-core/pull/10101))**

  Payment details now appear before soft credits when recording or editing
  contributions in the backend.

- **[CRM-19892](https://issues.civicrm.org/jira/browse/CRM-19892) Improve
  financial transaction pager for batch assignment
  ([9694](https://github.com/civicrm/civicrm-core/pull/9694))**

  The listing of financial transactions for batches now allows for viewing more
  lines per page.

- **[CRM-20022](https://issues.civicrm.org/jira/browse/CRM-20022) Add Batch
  Title to Columns, Grouping tabs on Contribution Summary report
  ([10142](https://github.com/civicrm/civicrm-core/pull/10142) and
  [10006](https://github.com/civicrm/civicrm-core/pull/10006))**

  The batch title is now available to view and group in the Contribution
  Summary report.

### CiviEvent

- **[CRM-19773](https://issues.civicrm.org/jira/browse/CRM-19773) Call
  hook_civicrm_selectWhereClause from the BAOs
  ([10125](https://github.com/civicrm/civicrm-core/pull/10125) and
  [9544](https://github.com/civicrm/civicrm-core/pull/9544))**

  This change increases the coverage of `hook_civicrm_selectWhereClause` to
  include selecting events.

### CiviMail

- **[CRM-20369](https://issues.civicrm.org/jira/browse/CRM-20369) include
  subject field in mailing reports
  ([10088](https://github.com/civicrm/civicrm-core/pull/10088))**

  Mailing reports now can display the subject line in addition to the internal
  mailing name.

### CiviMember

- **[CRM-20344](https://issues.civicrm.org/jira/browse/CRM-20344) Make 'Member
  Since' displayed on membership tabs for Inactive Memberships.
  ([10055](https://github.com/civicrm/civicrm-core/pull/10055))**

  The membership join date is now displayed even on the table of a contact's
  inactive memberships.

- **[CRM-20375](https://issues.civicrm.org/jira/browse/CRM-20375) Respect
  membership auto-renew status for contribution pages
  ([10095](https://github.com/civicrm/civicrm-core/pull/10095))**

  Auto-renew options on contribution pages now appear or freeze according to the
  selected membership type's settings for auto-renew.

### Drupal Integration Modules

- **[CRM-20319](https://issues.civicrm.org/jira/browse/CRM-20319) Expose
  relationship permission to views
  ([437](https://github.com/civicrm/civicrm-drupal/pull/437))**

  Views can now display, filter by, and sort by whether a relationship grants
  permission for one contact to view or edit the other.

### WordPress Integration

- **[CRM-20148](https://issues.civicrm.org/jira/browse/CRM-20148) WP-CLI
  installer won't run if it can be run
  ([110](https://github.com/civicrm/civicrm-wordpress/pull/110))**

  CiviCRM can now be installed using WP-CLI, either by first downloading and
  enabling the CiviCRM plugin or manually including the `wp-cli/civicrm.php`
  file as part of the command.

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **[CRM-20417](https://issues.civicrm.org/jira/browse/CRM-20417) Translate
  strings ([10179](https://github.com/civicrm/civicrm-core/pull/10179) and
  [10148](https://github.com/civicrm/civicrm-core/pull/10148))**

  A number of untranslated phrases are now sent through translation.

- **[CRM-20246](https://issues.civicrm.org/jira/browse/CRM-20246) maxfilesize on
  import should respect 0 as meaning "no limit"
  ([10021](https://github.com/civicrm/civicrm-core/pull/10021))**

  A zero value had been interpreted as disallowing any size file.

- **[CRM-20333](https://issues.civicrm.org/jira/browse/CRM-20333) Search menu
  visible even when a user has not access to any contacts.
  ([10040](https://github.com/civicrm/civicrm-core/pull/10040))**

- **[CRM-20451](https://issues.civicrm.org/jira/browse/CRM-20451) Do no assume
  all BAOs have exportableFields method in Core_report
  ([10191](https://github.com/civicrm/civicrm-core/pull/10191))**

- **[CRM-20481](https://issues.civicrm.org/jira/browse/CRM-20481) Refactor
  Activity api to more efficient query
  ([10280](https://github.com/civicrm/civicrm-core/pull/10280)) (preliminary
  work)**

- **[CRM-20467](https://issues.civicrm.org/jira/browse/CRM-20467) PHP notices on
  contact search for ACL'd user
  ([10243](https://github.com/civicrm/civicrm-core/pull/10243))**

  Notices appeared when the user has access to contacts via ACLs rather than the
  "View all contacts" permission.

- **[CRM-20441](https://issues.civicrm.org/jira/browse/CRM-20441) Fatal error on
  contact summary for ACL'd user (from activity tab count)
  ([10237](https://github.com/civicrm/civicrm-core/pull/10237),
  [10232](https://github.com/civicrm/civicrm-core/pull/10232),
  [10231](https://github.com/civicrm/civicrm-core/pull/10231), and
  [10212](https://github.com/civicrm/civicrm-core/pull/10212))**

  The fatal error occurred when the user has access to contacts via ACLs rather
  than the "View all contacts" permission.

- **Added object type selector to panel rule
  ([10175](https://github.com/civicrm/civicrm-core/pull/10175))**

  This fixes a bug where all elements with the `panel` class were hidden.

- **[CRM-20436](https://issues.civicrm.org/jira/browse/CRM-20436) Non Static
  method CRM_Upgrade_Incremental_php_FourSeven::updateKenyanProvinces should be
  static ([10170](https://github.com/civicrm/civicrm-core/pull/10170))**

- **[CRM-20429](https://issues.civicrm.org/jira/browse/CRM-20429) Deleting an
  activity with target contacts > 50 results in error
  ([10162](https://github.com/civicrm/civicrm-core/pull/10162))**

- **[CRM-20339](https://issues.civicrm.org/jira/browse/CRM-20339) Custom field
  data on relationships only saved when creating a new relationship, not on edit
  ([10092](https://github.com/civicrm/civicrm-core/pull/10092))**

- **[CRM-20390](https://issues.civicrm.org/jira/browse/CRM-20390) Data type
  mismatch in angular select2 bindings
  ([10116](https://github.com/civicrm/civicrm-core/pull/10116))**

  Select2 widgets had been expected to accept comma-delimited data and produce
  arrays.  This change makes input and output consistent.

- **[CRM-19921](https://issues.civicrm.org/jira/browse/CRM-19921) CustomGroup
  $params['extends'] should only be required on create, not on update
  ([9724](https://github.com/civicrm/civicrm-core/pull/9724))**

- **[CRM-19400](https://issues.civicrm.org/jira/browse/CRM-19400) open street
  map no longer works
  ([10049](https://github.com/civicrm/civicrm-core/pull/10049))**

  Mapping with OpenStreetMap now uses the Carto tile server.

- **[CRM-20350](https://issues.civicrm.org/jira/browse/CRM-20350) Incorrect
  escaping of double-quotes in iCalendar text values
  ([10067](https://github.com/civicrm/civicrm-core/pull/10067))**

- **[CRM-20011](https://issues.civicrm.org/jira/browse/CRM-20011) Profile date
  fields using YYYY-MM or MM YY don't work
  ([10003](https://github.com/civicrm/civicrm-core/pull/10003))**

- **[CRM-20327](https://issues.civicrm.org/jira/browse/CRM-20327) API chaining -
  replace $value when using operators.
  ([10033](https://github.com/civicrm/civicrm-core/pull/10033))**

  API Chaining is a CiviCRM feature introduced in May 2011 by Eileen McNaughton
  ([CRM-8148](https://issues.civicrm.org/jira/browse/CRM-8148)) allowing for a
  single API call to both retrieve entities and perform actions on those
  entities.  The value of the parent link in a chain is denoted by `$value`, but
  this was not handled properly with operators like `IF` or `<`.

- **[CRM-20178](https://issues.civicrm.org/jira/browse/CRM-20178) Writes to
  timestamp fields are silently ignored by $dao->save()
  ([178](https://github.com/civicrm/civicrm-packages/pull/178))**

- **[CRM-20427](https://issues.civicrm.org/jira/browse/CRM-20427) Many pages
  break on multilingual on 4.7.18
  ([10171](https://github.com/civicrm/civicrm-core/pull/10171))**

- **[CRM-19663](https://issues.civicrm.org/jira/browse/CRM-19663) A scheduled
  reminder set to use an absolute date does not allow repeats
  ([9773](https://github.com/civicrm/civicrm-core/pull/9773))**

- **[CRM-19612](https://issues.civicrm.org/jira/browse/CRM-19612) Dedupe_copy DB
  error ([10035](https://github.com/civicrm/civicrm-core/pull/10035))
  (preliminary work)**

  Deduping according to a matching rule with more than one field can result in a
  database error.  Users still report facing this bug.

### CiviCampaign

- **[CRM-20376](https://issues.civicrm.org/jira/browse/CRM-20376) SurveyDetails
  Report should not repeat field names when printing
  ([10096](https://github.com/civicrm/civicrm-core/pull/10096))**

- **Crm 20378 - simplify SurveyDetail report - improve line breaks in PDF, etc.
  ([10097](https://github.com/civicrm/civicrm-core/pull/10097))**

### CiviMember

- **[CRM-20343](https://issues.civicrm.org/jira/browse/CRM-20343) Wrong Activity
  creation when Membership status is changed from membership form.
  ([10093](https://github.com/civicrm/civicrm-core/pull/10093))**

  Editing a cancelled membership may result in a new membership activity being
  created.

- **[CRM-20371](https://issues.civicrm.org/jira/browse/CRM-20371) Set
  is_transactional when trying to create membership_payments in recur
  transaciton ([10091](https://github.com/civicrm/civicrm-core/pull/10091))**

  If creating a membership payment fails on a recurring payment, the entire
  transaction should not roll back.

- **[CRM-20311](https://issues.civicrm.org/jira/browse/CRM-20311) Membership
  cancelation via contribution doesn't create membership status change activity
  ([10054](https://github.com/civicrm/civicrm-core/pull/10054) and
  [10024](https://github.com/civicrm/civicrm-core/pull/10024))**

- **[CRM-20008](https://issues.civicrm.org/jira/browse/CRM-20008)
  repeattrasaction should create pending membership when
  contribtuion_status_id is pending
  ([10030](https://github.com/civicrm/civicrm-core/pull/10030))**

- **[CRM-20413](https://issues.civicrm.org/jira/browse/CRM-20413) Wrong
  payment_instrument used for civicrm_contribution for membership office
  contributions  ([10144](https://github.com/civicrm/civicrm-core/pull/10144))**

  This fixes a bug where contributions created by memberships created in the
  backend have the payment instrument incorrectly recorded as "Check".

- **[CRM-19243](https://issues.civicrm.org/jira/browse/CRM-19243) Free
  membership results in two activities and email receipts
  ([10084](https://github.com/civicrm/civicrm-core/pull/10084))**

- **[CRM-20329](https://issues.civicrm.org/jira/browse/CRM-20329) Backend
  Membership with Payment set to Failed results in Membership being set to New
  ([10036](https://github.com/civicrm/civicrm-core/pull/10036))**

### CiviMail

- **[CRM-20340](https://issues.civicrm.org/jira/browse/CRM-20340) Translate
  unsubscribe string
  ([10047](https://github.com/civicrm/civicrm-core/pull/10047))**

  The unsubscribe button on the unsubscribe form was not translated.

- **[CRM-20316](https://issues.civicrm.org/jira/browse/CRM-20316) Api mailing
  create should work without logged in user (eg. drush)
  ([10186](https://github.com/civicrm/civicrm-core/pull/10186))**

- **[CRM-20389](https://issues.civicrm.org/jira/browse/CRM-20389) Cloned
  experiment or winner mailing should have type standalone
  ([10127](https://github.com/civicrm/civicrm-core/pull/10127))**

  Reusing a mailing from an A/B test should not carry the type from the test;
  it should look like other "normal" mailings.

- **[CRM-20402](https://issues.civicrm.org/jira/browse/CRM-20402) improve "spam"
  pattern match for bounces
  ([10132](https://github.com/civicrm/civicrm-core/pull/10132))**

  Some spam notifications were being treated as syntax bounces.

- **[CRM-20140](https://issues.civicrm.org/jira/browse/CRM-20140) CiviCRM
  alterMailParams hook does not work on subject
  ([9869](https://github.com/civicrm/civicrm-core/pull/9869))**

### CiviContribute

- **[CRM-20374](https://issues.civicrm.org/jira/browse/CRM-20374) Don't crash
  when we can't UpdateSubscription for recurring contributions
  ([10094](https://github.com/civicrm/civicrm-core/pull/10094))**

- **[CRM-20450](https://issues.civicrm.org/jira/browse/CRM-20450) Fix invoice
  math for partial payments
  ([10223](https://github.com/civicrm/civicrm-core/pull/10223) and
  [10222](https://github.com/civicrm/civicrm-core/pull/10222))**

- **[CRM-20465](https://issues.civicrm.org/jira/browse/CRM-20465) pan truncation
  doesn't respect values preceding with 0
  ([10218](https://github.com/civicrm/civicrm-core/pull/10218))**

  The last four digits of a credit card number were being stored as an integer
  rather than a four-character string.

- **[CRM-20464](https://issues.civicrm.org/jira/browse/CRM-20464) Smarty error
  when receipt is send for recording payment
  ([10210](https://github.com/civicrm/civicrm-core/pull/10210))**

- **[CRM-19597](https://issues.civicrm.org/jira/browse/CRM-19597) Allow the
  receive_date to be passed in when replaying Authorize.net transactions
  ([10099](https://github.com/civicrm/civicrm-core/pull/10099))**

  The `receive_date` had been populated by the current date.

- **[CRM-20392](https://issues.civicrm.org/jira/browse/CRM-20392) Credit card
  payment not recorded when contribution is partially paid
  ([10187](https://github.com/civicrm/civicrm-core/pull/10187),
  [10143](https://github.com/civicrm/civicrm-core/pull/10143),
  [10129](https://github.com/civicrm/civicrm-core/pull/10129),
  [10137](https://github.com/civicrm/civicrm-core/pull/10137), and
  [10136](https://github.com/civicrm/civicrm-core/pull/10136))**

- **[CRM-20388](https://issues.civicrm.org/jira/browse/CRM-20388) Payflow Pro
  payment processor codes rejected payments as completed
  ([10115](https://github.com/civicrm/civicrm-core/pull/10115))**

- **[CRM-20385](https://issues.civicrm.org/jira/browse/CRM-20385) oversensitive
  deferred revenue account validation
  ([10114](https://github.com/civicrm/civicrm-core/pull/10114))**

- **Refactored Deferred Revenue report to follow more standardized approach.
  ([10113](https://github.com/civicrm/civicrm-core/pull/10113))**

- **[CRM-19633](https://issues.civicrm.org/jira/browse/CRM-19633) Contribution
  page shows error on multisite when viewed from a domain that the payment
  processor isn't linked to
  ([9371](https://github.com/civicrm/civicrm-core/pull/9371))**

- **[CRM-20336](https://issues.civicrm.org/jira/browse/CRM-20336) Failed iATS
  contribution should be set to failed, not pending
  ([10041](https://github.com/civicrm/civicrm-core/pull/10041))**

- **[CRM-20012](https://issues.civicrm.org/jira/browse/CRM-20012) contribution
  batch update: can't unset thank you date value
  ([9729](https://github.com/civicrm/civicrm-core/pull/9729))**

  Date handling in profiles is simplified and standardized.

- **[CRM-20334](https://issues.civicrm.org/jira/browse/CRM-20334) Regression
  within release cycle - Fatal Error on Submit Credit Card Form
  ([10039](https://github.com/civicrm/civicrm-core/pull/10039))**

- **[CRM-20449](https://issues.civicrm.org/jira/browse/CRM-20449) Possible
  regression - enotices from 'send thankyou letter' on contribution search
  actions ([10219](https://github.com/civicrm/civicrm-core/pull/10219))**

- **[CRM-20393](https://issues.civicrm.org/jira/browse/CRM-20393) Authorize.net:
  fix for the "check if the user already submitted this transaction"
  ([10147](https://github.com/civicrm/civicrm-core/pull/10147))**

- **[CRM-19517](https://issues.civicrm.org/jira/browse/CRM-19517) Show price
  field Options that use disabled Financial Types so they can be edited.
  ([9276](https://github.com/civicrm/civicrm-core/pull/9276))**

- **[CRM-20360](https://issues.civicrm.org/jira/browse/CRM-20360) Payment
  Options heading is incorrectly shown when default amount is 0
  ([10080](https://github.com/civicrm/civicrm-core/pull/10080))**

- **[CRM-19741](https://issues.civicrm.org/jira/browse/CRM-19741) Price set and
  price set value "label" fields are inconsistant to users
  ([10120](https://github.com/civicrm/civicrm-core/pull/10120))**

### CiviSMS

- **[CRM-20410](https://issues.civicrm.org/jira/browse/CRM-20410) Refactor SMS
  provider BAO to have proper create function
  ([10135](https://github.com/civicrm/civicrm-core/pull/10135))**

- **[CRM-19961](https://issues.civicrm.org/jira/browse/CRM-19961) Make CiviCRM
  SMS Providers multisite aware
  ([9796](https://github.com/civicrm/civicrm-core/pull/9796) and
  [10100](https://github.com/civicrm/civicrm-core/pull/10100))**

### CiviEvent

- **[CRM-20029](https://issues.civicrm.org/jira/browse/CRM-20029) Events with
  file custom fields don't copy the files
  ([9960](https://github.com/civicrm/civicrm-core/pull/9960))**

  Copying an event with files uploaded to custom fields should result in copies
  of the files attached to the copy of the event.

### Drupal Integration

- **[CRM-20502](https://issues.civicrm.org/jira/browse/CRM-20502) Drush upgrade
  crashes on loading "is_public" field
  ([444](https://github.com/civicrm/civicrm-drupal/pull/444))**

  The cache of custom fields will no longer be populated when a site is being
  upgraded.

- **Drupal bootstrap failures should throw debuggable exception
  ([9616](https://github.com/civicrm/civicrm-core/pull/9616))**

## <a name="misc"></a>Miscellany

- **[CRM-20439](https://issues.civicrm.org/jira/browse/CRM-20439) Rename
  card_type to card_type_id of civicrm_financial_trxn table (IIDA-126)
  ([10178](https://github.com/civicrm/civicrm-core/pull/10178))**

- **[CRM-20367](https://issues.civicrm.org/jira/browse/CRM-20367) Add wrapper
  function for adding and dropping Index in Upgrader
  ([10131](https://github.com/civicrm/civicrm-core/pull/10131) and
  [10086](https://github.com/civicrm/civicrm-core/pull/10086))**

- **[CRM-19967](https://issues.civicrm.org/jira/browse/CRM-19967) Contact query
  inline docs improvements from CRM-4287
  ([10090](https://github.com/civicrm/civicrm-core/pull/10090))**

- **[CRM-19715](https://issues.civicrm.org/jira/browse/CRM-19715) Remove Close
  Accounting Period code
  ([10083](https://github.com/civicrm/civicrm-core/pull/10083),
  [9974](https://github.com/civicrm/civicrm-core/pull/9974),
  [9985](https://github.com/civicrm/civicrm-core/pull/9985), and
  [10077](https://github.com/civicrm/civicrm-core/pull/10077))**

  An unadvertised set of features allowed for closing the books at the end of an
  accounting period and producing a trial balance.  This feature set is more
  appropriate in an extension.

- **[CRM-20328](https://issues.civicrm.org/jira/browse/CRM-20328) Remove code
  duplication when calling Dedupe functions
  ([10053](https://github.com/civicrm/civicrm-core/pull/10053),
  [10034](https://github.com/civicrm/civicrm-core/pull/10034),
  [10150](https://github.com/civicrm/civicrm-core/pull/10150),
  [10069](https://github.com/civicrm/civicrm-core/pull/10069),
  [10070](https://github.com/civicrm/civicrm-core/pull/10070), and
  [10064](https://github.com/civicrm/civicrm-core/pull/10064)) (towards
  [CRM-20155](https://issues.civicrm.org/jira/browse/CRM-20155))**

  This refactors and standardizes code for matching contacts and preparing to
  merge duplicates.

- **[CRM-20357](https://issues.civicrm.org/jira/browse/CRM-20357) Remove
  CRM_Dedupe_Finder::dupesOfContact function
  ([10071](https://github.com/civicrm/civicrm-core/pull/10071))**

  The function was obsolete and unused.

- **Fix spelling. ([10282](https://github.com/civicrm/civicrm-core/pull/10282))**

- **[NFC] Remove comment as this has been fixed
  ([10199](https://github.com/civicrm/civicrm-core/pull/10199))**

- **[NFC] Further test improvement
  ([10198](https://github.com/civicrm/civicrm-core/pull/10198))**

- **CiviEventInspector - Add util for displaying hook metadata
  ([10161](https://github.com/civicrm/civicrm-core/pull/10161))**

  This utility makes use of the fact that hooks are now handled by Symfony
  events, providing the ability to view information about implementations of a
  hook/event.

- **Code cleanup ([10176](https://github.com/civicrm/civicrm-core/pull/10176))**

  This removes redundant code relating to financial accounts.

- **Used Api to get financial account for an entity defined in
  civicrm_entity_financial_account table
  ([10130](https://github.com/civicrm/civicrm-core/pull/10130))**

- **GenCode - Reduce merge-conflicts on AllCoreTables
  ([10182](https://github.com/civicrm/civicrm-core/pull/10182))**

- **[NFC] Fix invalid php in test-generated example
  ([10185](https://github.com/civicrm/civicrm-core/pull/10185))**

- **Fix visibility typo
  ([10177](https://github.com/civicrm/civicrm-core/pull/10177))**

- **Document PR scope & size
  ([10174](https://github.com/civicrm/civicrm-core/pull/10174))**

- **Make sourceSQLFile throw an error when it can't find a file.
  ([10160](https://github.com/civicrm/civicrm-core/pull/10160))**

- **Fix test regression by correctly setting timestamp in test method
  ([10145](https://github.com/civicrm/civicrm-core/pull/10145))**

- **[CRM-19987](https://issues.civicrm.org/jira/browse/CRM-19987) Disabled
  activities are shown in search results
  ([10119](https://github.com/civicrm/civicrm-core/pull/10119))**

  Only comments are added.

- **Add my details ([10110](https://github.com/civicrm/civicrm-core/pull/10110))**

- **Minor spelling & casing  tidy ups
  ([10107](https://github.com/civicrm/civicrm-core/pull/10107))**

- **[CRM-20346](https://issues.civicrm.org/jira/browse/CRM-20346) Remove
  encryptDB.php from codebase
  ([10059](https://github.com/civicrm/civicrm-core/pull/10059))**

- **(NFC) Update stale GenCode checksums
  ([10048](https://github.com/civicrm/civicrm-core/pull/10048))**

- **Remove CRM_Core_Form::generateID().
  ([9968](https://github.com/civicrm/civicrm-core/pull/9968))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Andrew Hunt; Agileware - Agileware Team; Australian Greens -
Seamus Lee; CiviCoop - Erik Hommel, Jaap Jansma; CiviCRM - Coleman Watts, Tim
Otten; CiviFirst - John Kirk; CompuCorp - Omar Abu Hussein; Coop SymbioTIC -
Mathieu Lutfy; Erich Schulz; Fuzion - Chris Burgess, Eileen McNaughton, Jitendra
Purohit; JMA Consulting - Edsel Lopez, Joe Murray, Monish Deb, Pradeep Nayak;
Joinery - Allen Shaw; Lighthouse Design and Consulting - Brian Shaughnessy; MJW
Consulting - Matthew Wire; Progressive Technology Project - Jamie McClelland;
Romain Thouvenin; Semper IT - Karin Gerritsen; Squiffle Consulting - Aidan
Saunders; Stan Dragnev; Systopia - Björn Endres; Third Sector Design - Michael
McAndrew; Tobias Lounsbury; Wikimedia Foundation - Eileen McNaughton

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

AGH Strategies - Mika Weinstein; Annertech - Anthony Lindsay; Barbara Miller;
Blackfly Solutions - Alan Dixon; British Humanist Association - William Gordon;
Canine Companions for Independence - Angela Cacciola; Christian Wach; Circle
Interactive - Dave Jenkins, Martin Castle; CiviCRM - Josh Gowans; CiviDesk -
Nicolas Ganivet, Steve Kessler, Sunil Pawar, Yashodha Chaku; Comunica2 - René
Nieuwburg; CompuCorp - Guanhuan Chen, Mirela Stanila; Coop SymbioTIC - Mathieu
Lutfy; Donald Lobo; Freeform Solutions - Herb van den Dool; Fuzion - Gemma
Potaka, Peter Davis; Ginkgo Street Labs - Frank Gómez; Glick Software - David
Glick; GMCVO Databases - Jon-man Cheung; Greenleaf Advancement - Guy Iaccarino;
Hartmann Computer Consulting - Peter Hartmann; JMA Consulting - Jon Goldberg;
John Kingsnorth; Korlon - Stuart Gaston; Lullabot - Nate Lampton; Marc Brazeau;
MC3 - Graham Mitchell; Michal Mach; Richard van Oosterhout; Romain Thouvenin;
Samuel Haskell; Sean Madsen; Semper IT - Karin Gerritsen; Spry Digital - Ellen
Hendricks, Sheila Burkett; Tadpole Collective - Kevin Cristiano; Team Expansion -
Greg Harris; Timbsoft Technologies - Tunbola Ogunwande
