# Copyright 2014 The Chromium Authors. All rights reserved.
# Use of this source code is governed by a BSD-style license that can be
# found in the LICENSE file.

{
  'variables': {
    'remoting_host_installer_win_roots': [
      'host/installer/win/',
    ],
    'remoting_host_installer_win_files': [
      'host/installer/win/chromoting.wxs',
      'host/installer/win/parameters.json',
    ],
  },

  'conditions': [
    ['OS=="win"', {
      'targets': [
        {
          'target_name': 'remoting_breakpad_tester',
          'type': 'executable',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'dependencies': [
            '../base/base.gyp:base',
            'remoting_host',
          ],
          'sources': [
            'tools/breakpad_tester_win.cc',
          ],
        },  # end of target 'remoting_breakpad_tester'
        {
          'target_name': 'remoting_lib_idl',
          'type': 'static_library',
          'sources': [
            'host/win/chromoting_lib_idl.templ',
            '<(SHARED_INTERMEDIATE_DIR)/remoting/host/chromoting_lib.h',
            '<(SHARED_INTERMEDIATE_DIR)/remoting/host/chromoting_lib.idl',
            '<(SHARED_INTERMEDIATE_DIR)/remoting/host/chromoting_lib_i.c',
          ],
          # This target exports a hard dependency because dependent targets may
          # include chromoting_lib.h, a generated header.
          'hard_dependency': 1,
          'msvs_settings': {
            'VCMIDLTool': {
              'OutputDirectory': '<(SHARED_INTERMEDIATE_DIR)/remoting/host',
            },
          },
          'direct_dependent_settings': {
            'include_dirs': [
              '<(SHARED_INTERMEDIATE_DIR)',
            ],
          },
          'rules': [
            {
              'rule_name': 'generate_idl',
              'extension': 'templ',
              'outputs': [
                '<(SHARED_INTERMEDIATE_DIR)/remoting/host/chromoting_lib.idl',
              ],
              'action': [
                'python', '<(version_py_path)',
                '-e', "DAEMON_CONTROLLER_CLSID='<(daemon_controller_clsid)'",
                '-e', "RDP_DESKTOP_SESSION_CLSID='<(rdp_desktop_session_clsid)'",
                '<(RULE_INPUT_PATH)',
                '<@(_outputs)',
              ],
              'process_outputs_as_sources': 1,
              'message': 'Generating <@(_outputs)',
            },
          ],
        },  # end of target 'remoting_lib_idl'

        # remoting_lib_ps builds the proxy/stub code generated by MIDL (see
        # remoting_lib_idl).
        {
          'target_name': 'remoting_lib_ps',
          'type': 'static_library',
          'defines': [
            # Prepend 'Ps' to the MIDL-generated routines. This includes
            # DllGetClassObject, DllCanUnloadNow, DllRegisterServer,
            # DllUnregisterServer, and DllMain.
            'ENTRY_PREFIX=Ps',
            'REGISTER_PROXY_DLL',
          ],
          'dependencies': [
            'remoting_lib_idl',
          ],
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/remoting/host/chromoting_lib.dlldata.c',
            '<(SHARED_INTERMEDIATE_DIR)/remoting/host/chromoting_lib_p.c',
          ],
        },  # end of target 'remoting_lib_ps'

        # Regenerates 'chromoting_lib.rc' (used to embed 'chromoting_lib.tlb'
        # into remoting_core.dll's resources) every time
        # 'chromoting_lib_idl.templ' changes. Making remoting_core depend on
        # both this and 'remoting_lib_idl' targets ensures that the resorces
        # are rebuilt every time the type library is updated. GYP alone is
        # not smart enough to figure out this dependency on its own.
        {
          'target_name': 'remoting_lib_rc',
          'type': 'none',
          'sources': [
            'host/win/chromoting_lib_idl.templ',
          ],
          'hard_dependency': 1,
          'direct_dependent_settings': {
            'include_dirs': [
              '<(SHARED_INTERMEDIATE_DIR)',
            ],
          },
          'rules': [
            {
              'rule_name': 'generate_rc',
              'extension': 'templ',
              'outputs': [
                '<(SHARED_INTERMEDIATE_DIR)/remoting/host/chromoting_lib.rc',
              ],
              'action': [
                'echo 1 typelib "remoting/host/chromoting_lib.tlb" > <@(_outputs)',
              ],
              'message': 'Generating <@(_outputs)',
            },
          ],
        },  # end of target 'remoting_lib_rc'
        # The only difference between |remoting_console.exe| and
        # |remoting_host.exe| is that the former is a console application.
        # |remoting_console.exe| is used for debugging purposes.
        {
          'target_name': 'remoting_console',
          'type': 'executable',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'defines': [
            'BINARY=BINARY_HOST_ME2ME',
          ],
          'dependencies': [
            'remoting_core',
            'remoting_windows_resources',
          ],
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/remoting/version.rc',
            'host/win/entry_point.cc',
          ],
          'msvs_settings': {
            'VCManifestTool': {
              'AdditionalManifestFiles': [
                'host/win/dpi_aware.manifest',
              ],
            },
            'VCLinkerTool': {
              'EntryPointSymbol': 'HostEntryPoint',
              'IgnoreAllDefaultLibraries': 'true',
              'SubSystem': '1', # /SUBSYSTEM:CONSOLE
            },
          },
        },  # end of target 'remoting_console'
        {
          'target_name': 'remoting_core',
          'type': 'shared_library',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'defines' : [
            '_ATL_APARTMENT_THREADED',
            '_ATL_CSTRING_EXPLICIT_CONSTRUCTORS',
            '_ATL_NO_AUTOMATIC_NAMESPACE',
            '_ATL_NO_EXCEPTIONS',
            'BINARY=BINARY_CORE',
            'DAEMON_CONTROLLER_CLSID="{<(daemon_controller_clsid)}"',
            'RDP_DESKTOP_SESSION_CLSID="{<(rdp_desktop_session_clsid)}"',
            'HOST_IMPLEMENTATION',
            'ISOLATION_AWARE_ENABLED=1',
            'STRICT',
            'VERSION=<(version_full)',
          ],
          'dependencies': [
            '../base/base.gyp:base',
            '../base/base.gyp:base_static',
            '../base/third_party/dynamic_annotations/dynamic_annotations.gyp:dynamic_annotations',
            '../ipc/ipc.gyp:ipc',
            '../net/net.gyp:net',
            '../third_party/webrtc/modules/modules.gyp:desktop_capture',
            'remoting_base',
            'remoting_breakpad',
            'remoting_host',
            'remoting_host_setup_base',
            'remoting_lib_idl',
            'remoting_lib_ps',
            'remoting_lib_rc',
            'remoting_me2me_host_static',
            'remoting_native_messaging_base',
            'remoting_protocol',
            'remoting_windows_resources',
          ],
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/remoting/core.rc',
            '<(SHARED_INTERMEDIATE_DIR)/remoting/host/chromoting_lib.rc',
            '<(SHARED_INTERMEDIATE_DIR)/remoting/host/remoting_host_messages.rc',
            '<(SHARED_INTERMEDIATE_DIR)/remoting/version.rc',
            'host/desktop_process_main.cc',
            'host/host_main.cc',
            'host/host_main.h',
            'host/ipc_constants.cc',
            'host/ipc_constants.h',
            'host/remoting_me2me_host.cc',
            'host/sas_injector.h',
            'host/sas_injector_win.cc',
            'host/setup/me2me_native_messaging_host_main.cc',
            'host/verify_config_window_win.cc',
            'host/verify_config_window_win.h',
            'host/win/chromoting_module.cc',
            'host/win/chromoting_module.h',
            'host/win/core.cc',
            'host/win/core_resource.h',
            'host/win/elevated_controller.cc',
            'host/win/elevated_controller.h',
            'host/win/host_service.cc',
            'host/win/host_service.h',
            'host/win/omaha.cc',
            'host/win/omaha.h',
            'host/win/rdp_desktop_session.cc',
            'host/win/rdp_desktop_session.h',
            'host/win/unprivileged_process_delegate.cc',
            'host/win/unprivileged_process_delegate.h',
            'host/win/worker_process_launcher.cc',
            'host/win/worker_process_launcher.h',
            'host/win/wts_session_process_delegate.cc',
            'host/win/wts_session_process_delegate.h',
            'host/worker_process_ipc_delegate.h',
          ],
          'msvs_settings': {
            'VCManifestTool': {
              'EmbedManifest': 'true',
              'AdditionalManifestFiles': [
                'host/win/common-controls.manifest',
              ],
            },
            'VCLinkerTool': {
              'AdditionalDependencies': [
                'comctl32.lib',
                'rpcns4.lib',
                'rpcrt4.lib',
                'uuid.lib',
                'wtsapi32.lib',
              ],
              'AdditionalOptions': [
                # Export the proxy/stub entry points. Note that the generated
                # routines have 'Ps' prefix to avoid conflicts with our own
                # DllMain().
                '/EXPORT:DllGetClassObject=PsDllGetClassObject,PRIVATE',
                '/EXPORT:DllCanUnloadNow=PsDllCanUnloadNow,PRIVATE',
                '/EXPORT:DllRegisterServer=PsDllRegisterServer,PRIVATE',
                '/EXPORT:DllUnregisterServer=PsDllUnregisterServer,PRIVATE',
              ],
            },
          },
        },  # end of target 'remoting_core'
        {
          'target_name': 'remoting_desktop',
          'type': 'executable',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'defines': [
            'BINARY=BINARY_DESKTOP',
          ],
          'dependencies': [
            'remoting_core',
            'remoting_windows_resources',
          ],
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/remoting/version.rc',
            'host/win/entry_point.cc',
          ],
          'msvs_settings': {
            'VCManifestTool': {
              'AdditionalManifestFiles': [
                'host/win/dpi_aware.manifest',
              ],
            },
            'VCLinkerTool': {
              'EnableUAC': 'true',
              # Add 'level="requireAdministrator" uiAccess="true"' to
              # the manifest only for the official builds because it requires
              # the binary to be signed to work.
              'conditions': [
                ['buildtype == "Official"', {
                  'UACExecutionLevel': 2,
                  'UACUIAccess': 'true',
                }],
              ],
              'EntryPointSymbol': 'HostEntryPoint',
              'IgnoreAllDefaultLibraries': 'true',
              'SubSystem': '2', # /SUBSYSTEM:WINDOWS
            },
          },
        },  # end of target 'remoting_desktop'
        {
          'target_name': 'remoting_host_exe',
          'product_name': 'remoting_host',
          'type': 'executable',
          'variables': { 'enable_wexit_time_destructors': 1, },
          'defines': [
            'BINARY=BINARY_HOST_ME2ME',
          ],
          'dependencies': [
            'remoting_core',
            'remoting_windows_resources',
          ],
          'sources': [
            '<(SHARED_INTERMEDIATE_DIR)/remoting/version.rc',
            'host/win/entry_point.cc',
          ],
          'msvs_settings': {
            'VCManifestTool': {
              'AdditionalManifestFiles': [
                'host/win/dpi_aware.manifest',
              ],
            },
            'VCLinkerTool': {
              'EntryPointSymbol': 'HostEntryPoint',
              'IgnoreAllDefaultLibraries': 'true',
              'ImportLibrary': '$(OutDir)\\lib\\remoting_host_exe.lib',
              'OutputFile': '$(OutDir)\\remoting_host.exe',
              'SubSystem': '2', # /SUBSYSTEM:WINDOWS
            },
          },
        },  # end of target 'remoting_host_exe'
        {
          'target_name': 'remoting_host_messages',
          'type': 'none',
          'dependencies': [
            'remoting_resources',
          ],
          'hard_dependency': 1,
          'direct_dependent_settings': {
            'include_dirs': [
              '<(SHARED_INTERMEDIATE_DIR)',
            ],
          },
          'sources': [
            'host/win/host_messages.mc.jinja2'
          ],
          'rules': [
            {
              'rule_name': 'localize',
              'extension': 'jinja2',
              'outputs': [
                '<(SHARED_INTERMEDIATE_DIR)/remoting/host/remoting_host_messages.mc',
              ],
              'action': [
                'python', '<(remoting_localize_path)',
                '--locale_dir', '<(webapp_locale_dir)',
                '--template', '<(RULE_INPUT_PATH)',
                '--output', '<@(_outputs)',
                '--encoding', 'utf-16',
                '<@(remoting_locales)',
              ],
              'message': 'Localizing the event log messages'
            },
          ],
        },  # end of target 'remoting_host_messages'

        # Generates localized resources for the Windows binaries.
        # The substitution strings are taken from:
        #   - build/util/LASTCHANGE - the last source code revision. There is
        #       no explicit dependency on this file to avoid rebuilding the host
        #       after unrelated changes.
        #   - chrome/VERSION - the major, build & patch versions.
        #   - remoting/VERSION - the chromoting patch version (and overrides
        #       for chrome/VERSION).
        #   - translated webapp strings
        {
          'target_name': 'remoting_windows_resources',
          'type': 'none',
          'dependencies': [
            'remoting_resources',
          ],
          'hard_dependency': 1,
          'direct_dependent_settings': {
            'include_dirs': [
              '<(SHARED_INTERMEDIATE_DIR)',
            ],
          },
          'sources': [
            'host/win/core.rc.jinja2',
            'host/win/version.rc.jinja2',
          ],
          'rules': [
            {
              'rule_name': 'version',
              'extension': 'jinja2',
              'variables': {
                'lastchange_path': '<(DEPTH)/build/util/LASTCHANGE',
              },
              'inputs': [
                '<(chrome_version_path)',
                '<(remoting_version_path)',
                '<(RULE_INPUT_PATH)',
              ],
              'outputs': [
                '<(SHARED_INTERMEDIATE_DIR)/remoting/<(RULE_INPUT_ROOT)',
              ],
              'action': [
                'python', '<(remoting_localize_path)',
                '--variables', '<(chrome_version_path)',
                # |remoting_version_path| must be after |chrome_version_path|
                # because it can contain overrides for the version numbers.
                '--variables', '<(remoting_version_path)',
                '--variables', '<(lastchange_path)',
                '--locale_dir', '<(webapp_locale_dir)',
                '--template', '<(RULE_INPUT_PATH)',
                '--output', '<@(_outputs)',
                '--encoding', 'utf-16',
                '<@(remoting_locales)',
              ],
              'message': 'Localizing the version information'
            },
          ],
        },  # end of target 'remoting_windows_resources'
      ],  # end of 'targets'
    }],  # 'OS=="win"'

    # The host installation is generated only if WiX is available. If
    # component build is used the produced installation will not work due to
    # missing DLLs. We build it anyway to make sure the GYP scripts are executed
    # by the bots.
    ['OS == "win" and wix_exists == "True" and sas_dll_exists == "True"', {
      'targets': [
        {
          'target_name': 'remoting_host_installation',
          'type': 'none',
          'dependencies': [
            'remoting_me2me_host_archive',
          ],
          'sources': [
            '<(PRODUCT_DIR)/remoting-me2me-host-<(OS).zip',
          ],
          'outputs': [
            '<(PRODUCT_DIR)/chromoting.msi',
          ],
          'rules': [
            {
              'rule_name': 'zip2msi',
              'extension': 'zip',
              'inputs': [
                'tools/zip2msi.py',
              ],
              'outputs': [
                '<(PRODUCT_DIR)/chromoting.msi',
              ],
              'action': [
                'python', 'tools/zip2msi.py',
                '--wix_path', '<(wix_path)',
                '--intermediate_dir', '<(INTERMEDIATE_DIR)/installation',
                '<(RULE_INPUT_PATH)',
                '<@(_outputs)',
              ],
              'message': 'Generating <@(_outputs)',
            },
          ],
        },  # end of target 'remoting_host_installation'

        {
          'target_name': 'remoting_me2me_host_archive',
          'type': 'none',
          'dependencies': [
            '<(icu_gyp_path):icudata',
            'remoting_core',
            'remoting_desktop',
            'remoting_host_exe',
            'remoting_it2me_native_messaging_host',
            'remoting_me2me_native_messaging_host',
            'remoting_native_messaging_manifests',
          ],
          'compiled_inputs': [
            '<(PRODUCT_DIR)/remote_assistance_host.exe',
            '<(PRODUCT_DIR)/remoting_core.dll',
            '<(PRODUCT_DIR)/remoting_desktop.exe',
            '<(PRODUCT_DIR)/remoting_host.exe',
            '<(PRODUCT_DIR)/remoting_native_messaging_host.exe',
          ],
          'compiled_inputs_dst': [
            'files/remote_assistance_host.exe',
            'files/remoting_core.dll',
            'files/remoting_desktop.exe',
            'files/remoting_host.exe',
            'files/remoting_native_messaging_host.exe',
          ],
          'conditions': [
            ['buildtype == "Official"', {
              'defs': [
                'OFFICIAL_BUILD=1',
              ],
            }, {  # else buildtype != "Official"
              'defs': [
                'OFFICIAL_BUILD=0',
              ],
            }],
          ],
          'defs': [
            'BRANDING=<(branding)',
            'DAEMON_CONTROLLER_CLSID={<(daemon_controller_clsid)}',
            'RDP_DESKTOP_SESSION_CLSID={<(rdp_desktop_session_clsid)}',
            'VERSION=<(version_full)',
          ],
          'generated_files': [
            '<@(_compiled_inputs)',
            '<(sas_dll_path)/sas.dll',
            '<(PRODUCT_DIR)/remoting/com.google.chrome.remote_assistance.json',
            '<(PRODUCT_DIR)/remoting/com.google.chrome.remote_desktop.json',
            'resources/chromoting.ico',
            '<(PRODUCT_DIR)/icudtl.dat',
          ],
          'generated_files_dst': [
            '<@(_compiled_inputs_dst)',
            'files/sas.dll',
            'files/com.google.chrome.remote_assistance.json',
            'files/com.google.chrome.remote_desktop.json',
            'files/chromoting.ico',
            'files/icudtl.dat',
          ],
          'zip_path': '<(PRODUCT_DIR)/remoting-me2me-host-<(OS).zip',
          'outputs': [
            '<(_zip_path)',
          ],
          'actions': [
            {
              'action_name': 'Zip installer files for signing',
              'temp_dir': '<(INTERMEDIATE_DIR)/installation',
              'source_files': [
                '<@(remoting_host_installer_win_files)',
              ],
              'inputs': [
                '<@(_compiled_inputs)',
                '<(sas_dll_path)/sas.dll',
                '<@(_source_files)',
                'host/installer/build-installer-archive.py',
                'resources/chromoting.ico',
              ],
              'outputs': [
                '<(_zip_path)',
              ],
              'action': [
                'python', 'host/installer/build-installer-archive.py',
                '<(_temp_dir)',
                '<(_zip_path)',
                '--source-file-roots', '<@(remoting_host_installer_win_roots)',
                '--source-files', '<@(_source_files)',
                '--generated-files', '<@(_generated_files)',
                '--generated-files-dst', '<@(_generated_files_dst)',
                '--defs', '<@(_defs)',
              ],
            },
          ],  # actions
        }, # end of target 'remoting_me2me_host_archive'
      ],  # end of 'targets'
    }],  # '<(wix_path) != ""'

  ],  # end of 'conditions'
}
