# Security Policy

Centreon takes the security of our software products seriously.

If you believe you have found a security vulnerability, please report it to us as described below.

## Reporting a Vulnerability

**Please do not report security vulnerabilities through public GitHub issues.**

Send an email to security@centreon.com. If possible, encrypt your message with our PGP key below.

You should receive a response within 48 hours. If for some reason you do not, please follow up via email to ensure we received your original message.

To help us better understand the nature and scope of the possible issue, please describe as much as you can: 

* Type of issue (e.g. buffer overflow, SQL injection, cross-site scripting, etc.)
* Full paths of source file(s) related to the manifestation of the issue
* The location of the affected source code (tag/branch/commit or direct URL)
* Any special configuration required to reproduce the issue
* Step-by-step instructions to reproduce the issue
* Proof-of-concept or exploit code (if possible)
* Impact of the issue, including how an attacker might exploit the issue

## PGP information

### Public key

```
-----BEGIN PGP PUBLIC KEY BLOCK-----
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=3kAj
-----END PGP PUBLIC KEY BLOCK-----
```

| Tag | Value |
| -- | -- |
| ID | BEAF6EBF631106F9 |
| Type | RSA |
| Size | 4096 |
| Created | 2020-02-11 |
| Expires | 2021-02-10 |
| Cipher |AES-256|
| Fingerprint | C377 E9D5 2D5C 137D 3DD5 73B5 BEA F6EBF 6311 06F9 |

## Bug bounty

We don't have a bug bounty program but this is something we are thinking about.
