/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2021 Univ. Grenoble Alpes, CNRS, Grenoble INP, TIMC, 38000 Grenoble, France
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef MANUALTHRESHOLD_H
#define MANUALTHRESHOLD_H

#include <Action.h>
#include <ImageComponent.h>

/**
 *
 * @ingroup group_cepimaging_actions_itksegmentation
 *
 * @brief
 * Segment the @ref camitk::ImageComponent "ImageComponent" using a manual threshold.
 *
 **/
class ManualThreshold : public camitk::Action {
    Q_OBJECT

public:
    /// Default Constructor
    ManualThreshold(camitk::ActionExtension*);

    /// Default Destructor
    virtual ~ManualThreshold();

    /// Required to update the min/max constraints on the threshold value
    /// from the currently selected images (which depends on the pixel type)
    virtual QWidget* getWidget();

public slots:
    /** this method is automatically called when the action is triggered.
      * Use getTargets() QList to get the list of component to use.
      * \note getTargets() is automatically filtered so that it only contains compatible components,
      * i.e., instances of ImageComponent (or a subclass).
      */
    virtual camitk::Action::ApplyStatus apply();

private:
    /// helper method to simplify the target component processing
    virtual void process(camitk::ImageComponent* comp);

    vtkSmartPointer<vtkImageData> implementProcess(vtkSmartPointer<vtkImageData> img);

    template <class InputPixelType, class OutputPixelType, const int dim>
    vtkSmartPointer<vtkImageData> itkProcess(vtkSmartPointer<vtkImageData> img);


protected:
    /// Parameters
    int lowThreshold;
    int highThreshold;
};
#endif // MANUALTHRESHOLD_H
