#region license
// Copyright (c) 2009 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by astgen.boo.
//

namespace Boo.Lang.Compiler.Ast
{	
	public partial class CodeSerializer
	{
		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(TypeMemberModifiers value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(TypeMemberModifiers value)
		{
			return SerializeEnum("TypeMemberModifiers", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(MethodImplementationFlags value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(MethodImplementationFlags value)
		{
			return SerializeEnum("MethodImplementationFlags", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(ParameterModifiers value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(ParameterModifiers value)
		{
			return SerializeEnum("ParameterModifiers", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(ExceptionHandlerFlags value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(ExceptionHandlerFlags value)
		{
			return SerializeEnum("ExceptionHandlerFlags", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(GenericParameterConstraints value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(GenericParameterConstraints value)
		{
			return SerializeEnum("GenericParameterConstraints", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(StatementModifierType value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(StatementModifierType value)
		{
			return SerializeEnum("StatementModifierType", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(BinaryOperatorType value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(BinaryOperatorType value)
		{
			return SerializeEnum("BinaryOperatorType", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(BinaryOperatorKind value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(BinaryOperatorKind value)
		{
			return SerializeEnum("BinaryOperatorKind", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public bool ShouldSerialize(UnaryOperatorType value)
		{
			return (long)value != 0;
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		public Expression Serialize(UnaryOperatorType value)
		{
			return SerializeEnum("UnaryOperatorType", (long)value);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnCompileUnit(Boo.Lang.Compiler.Ast.CompileUnit node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.CompileUnit"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modules))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modules"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ModuleCollection", node.Modules)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnTypeMemberStatement(Boo.Lang.Compiler.Ast.TypeMemberStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.TypeMemberStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.TypeMember))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "TypeMember"),
						Serialize(node.TypeMember)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnExplicitMemberInfo(Boo.Lang.Compiler.Ast.ExplicitMemberInfo node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ExplicitMemberInfo"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.InterfaceType))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "InterfaceType"),
						Serialize(node.InterfaceType)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnSimpleTypeReference(Boo.Lang.Compiler.Ast.SimpleTypeReference node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SimpleTypeReference"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.IsPointer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsPointer"),
						Serialize(node.IsPointer)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnArrayTypeReference(Boo.Lang.Compiler.Ast.ArrayTypeReference node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ArrayTypeReference"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.IsPointer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsPointer"),
						Serialize(node.IsPointer)));
			}
			if (ShouldSerialize(node.ElementType))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ElementType"),
						Serialize(node.ElementType)));
			}
			if (ShouldSerialize(node.Rank))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Rank"),
						Serialize(node.Rank)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnCallableTypeReference(Boo.Lang.Compiler.Ast.CallableTypeReference node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.CallableTypeReference"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.IsPointer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsPointer"),
						Serialize(node.IsPointer)));
			}
			if (ShouldSerialize(node.Parameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Parameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ParameterDeclarationCollection", node.Parameters)));
			}
			if (ShouldSerialize(node.ReturnType))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnType"),
						Serialize(node.ReturnType)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnGenericTypeReference(Boo.Lang.Compiler.Ast.GenericTypeReference node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.GenericTypeReference"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.IsPointer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsPointer"),
						Serialize(node.IsPointer)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.GenericArguments))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericArguments"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeReferenceCollection", node.GenericArguments)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnGenericTypeDefinitionReference(Boo.Lang.Compiler.Ast.GenericTypeDefinitionReference node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.GenericTypeDefinitionReference"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.IsPointer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsPointer"),
						Serialize(node.IsPointer)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.GenericPlaceholders))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericPlaceholders"),
						Serialize(node.GenericPlaceholders)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnCallableDefinition(Boo.Lang.Compiler.Ast.CallableDefinition node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.CallableDefinition"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Parameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Parameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ParameterDeclarationCollection", node.Parameters)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			if (ShouldSerialize(node.ReturnType))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnType"),
						Serialize(node.ReturnType)));
			}
			if (ShouldSerialize(node.ReturnTypeAttributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnTypeAttributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.ReturnTypeAttributes)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnNamespaceDeclaration(Boo.Lang.Compiler.Ast.NamespaceDeclaration node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.NamespaceDeclaration"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnImport(Boo.Lang.Compiler.Ast.Import node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Import"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Namespace))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Namespace"),
						Serialize(node.Namespace)));
			}
			if (ShouldSerialize(node.AssemblyReference))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "AssemblyReference"),
						Serialize(node.AssemblyReference)));
			}
			if (ShouldSerialize(node.Alias))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Alias"),
						Serialize(node.Alias)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnModule(Boo.Lang.Compiler.Ast.Module node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Module"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Members))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Members"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeMemberCollection", node.Members)));
			}
			if (ShouldSerialize(node.BaseTypes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "BaseTypes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeReferenceCollection", node.BaseTypes)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			if (ShouldSerialize(node.Namespace))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Namespace"),
						Serialize(node.Namespace)));
			}
			if (ShouldSerialize(node.Imports))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Imports"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ImportCollection", node.Imports)));
			}
			if (ShouldSerialize(node.Globals))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Globals"),
						Serialize(node.Globals)));
			}
			if (ShouldSerialize(node.AssemblyAttributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "AssemblyAttributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.AssemblyAttributes)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnClassDefinition(Boo.Lang.Compiler.Ast.ClassDefinition node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ClassDefinition"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Members))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Members"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeMemberCollection", node.Members)));
			}
			if (ShouldSerialize(node.BaseTypes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "BaseTypes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeReferenceCollection", node.BaseTypes)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnStructDefinition(Boo.Lang.Compiler.Ast.StructDefinition node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.StructDefinition"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Members))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Members"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeMemberCollection", node.Members)));
			}
			if (ShouldSerialize(node.BaseTypes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "BaseTypes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeReferenceCollection", node.BaseTypes)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnInterfaceDefinition(Boo.Lang.Compiler.Ast.InterfaceDefinition node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.InterfaceDefinition"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Members))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Members"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeMemberCollection", node.Members)));
			}
			if (ShouldSerialize(node.BaseTypes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "BaseTypes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeReferenceCollection", node.BaseTypes)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnEnumDefinition(Boo.Lang.Compiler.Ast.EnumDefinition node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.EnumDefinition"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Members))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Members"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeMemberCollection", node.Members)));
			}
			if (ShouldSerialize(node.BaseTypes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "BaseTypes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeReferenceCollection", node.BaseTypes)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnEnumMember(Boo.Lang.Compiler.Ast.EnumMember node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.EnumMember"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Initializer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Initializer"),
						Serialize(node.Initializer)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnField(Boo.Lang.Compiler.Ast.Field node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Field"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			if (ShouldSerialize(node.Initializer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Initializer"),
						Serialize(node.Initializer)));
			}
			if (ShouldSerialize(node.IsVolatile))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsVolatile"),
						Serialize(node.IsVolatile)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnProperty(Boo.Lang.Compiler.Ast.Property node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Property"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Parameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Parameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ParameterDeclarationCollection", node.Parameters)));
			}
			if (ShouldSerialize(node.Getter))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Getter"),
						Serialize(node.Getter)));
			}
			if (ShouldSerialize(node.Setter))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Setter"),
						Serialize(node.Setter)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			if (ShouldSerialize(node.ExplicitInfo))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ExplicitInfo"),
						Serialize(node.ExplicitInfo)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnEvent(Boo.Lang.Compiler.Ast.Event node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Event"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Add))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Add"),
						Serialize(node.Add)));
			}
			if (ShouldSerialize(node.Remove))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Remove"),
						Serialize(node.Remove)));
			}
			if (ShouldSerialize(node.Raise))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Raise"),
						Serialize(node.Raise)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnLocal(Boo.Lang.Compiler.Ast.Local node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Local"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnBlockExpression(Boo.Lang.Compiler.Ast.BlockExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.BlockExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Parameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Parameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ParameterDeclarationCollection", node.Parameters)));
			}
			if (ShouldSerialize(node.ReturnType))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnType"),
						Serialize(node.ReturnType)));
			}
			if (ShouldSerialize(node.Body))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Body"),
						Serialize(node.Body)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnMethod(Boo.Lang.Compiler.Ast.Method node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Method"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Parameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Parameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ParameterDeclarationCollection", node.Parameters)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			if (ShouldSerialize(node.ReturnType))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnType"),
						Serialize(node.ReturnType)));
			}
			if (ShouldSerialize(node.ReturnTypeAttributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnTypeAttributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.ReturnTypeAttributes)));
			}
			if (ShouldSerialize(node.Body))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Body"),
						Serialize(node.Body)));
			}
			if (ShouldSerialize(node.Locals))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Locals"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.LocalCollection", node.Locals)));
			}
			if (ShouldSerialize(node.ImplementationFlags))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ImplementationFlags"),
						Serialize(node.ImplementationFlags)));
			}
			if (ShouldSerialize(node.ExplicitInfo))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ExplicitInfo"),
						Serialize(node.ExplicitInfo)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnConstructor(Boo.Lang.Compiler.Ast.Constructor node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Constructor"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Parameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Parameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ParameterDeclarationCollection", node.Parameters)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			if (ShouldSerialize(node.ReturnType))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnType"),
						Serialize(node.ReturnType)));
			}
			if (ShouldSerialize(node.ReturnTypeAttributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnTypeAttributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.ReturnTypeAttributes)));
			}
			if (ShouldSerialize(node.Body))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Body"),
						Serialize(node.Body)));
			}
			if (ShouldSerialize(node.Locals))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Locals"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.LocalCollection", node.Locals)));
			}
			if (ShouldSerialize(node.ImplementationFlags))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ImplementationFlags"),
						Serialize(node.ImplementationFlags)));
			}
			if (ShouldSerialize(node.ExplicitInfo))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ExplicitInfo"),
						Serialize(node.ExplicitInfo)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnDestructor(Boo.Lang.Compiler.Ast.Destructor node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Destructor"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Parameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Parameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ParameterDeclarationCollection", node.Parameters)));
			}
			if (ShouldSerialize(node.GenericParameters))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericParameters"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclarationCollection", node.GenericParameters)));
			}
			if (ShouldSerialize(node.ReturnType))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnType"),
						Serialize(node.ReturnType)));
			}
			if (ShouldSerialize(node.ReturnTypeAttributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ReturnTypeAttributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.ReturnTypeAttributes)));
			}
			if (ShouldSerialize(node.Body))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Body"),
						Serialize(node.Body)));
			}
			if (ShouldSerialize(node.Locals))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Locals"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.LocalCollection", node.Locals)));
			}
			if (ShouldSerialize(node.ImplementationFlags))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ImplementationFlags"),
						Serialize(node.ImplementationFlags)));
			}
			if (ShouldSerialize(node.ExplicitInfo))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ExplicitInfo"),
						Serialize(node.ExplicitInfo)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnParameterDeclaration(Boo.Lang.Compiler.Ast.ParameterDeclaration node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ParameterDeclaration"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnGenericParameterDeclaration(Boo.Lang.Compiler.Ast.GenericParameterDeclaration node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.GenericParameterDeclaration"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.BaseTypes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "BaseTypes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeReferenceCollection", node.BaseTypes)));
			}
			if (ShouldSerialize(node.Constraints))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Constraints"),
						Serialize(node.Constraints)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnDeclaration(Boo.Lang.Compiler.Ast.Declaration node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Declaration"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnAttribute(Boo.Lang.Compiler.Ast.Attribute node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Attribute"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Arguments))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Arguments"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionCollection", node.Arguments)));
			}
			if (ShouldSerialize(node.NamedArguments))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "NamedArguments"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionPairCollection", node.NamedArguments)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnStatementModifier(Boo.Lang.Compiler.Ast.StatementModifier node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.StatementModifier"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			if (ShouldSerialize(node.Condition))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Condition"),
						Serialize(node.Condition)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnGotoStatement(Boo.Lang.Compiler.Ast.GotoStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.GotoStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Label))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Label"),
						Serialize(node.Label)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnLabelStatement(Boo.Lang.Compiler.Ast.LabelStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.LabelStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnBlock(Boo.Lang.Compiler.Ast.Block node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Block"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Statements))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Statements"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.StatementCollection", node.Statements)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnDeclarationStatement(Boo.Lang.Compiler.Ast.DeclarationStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.DeclarationStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Declaration))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Declaration"),
						Serialize(node.Declaration)));
			}
			if (ShouldSerialize(node.Initializer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Initializer"),
						Serialize(node.Initializer)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnMacroStatement(Boo.Lang.Compiler.Ast.MacroStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.MacroStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Arguments))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Arguments"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionCollection", node.Arguments)));
			}
			if (ShouldSerialize(node.Body))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Body"),
						Serialize(node.Body)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnTryStatement(Boo.Lang.Compiler.Ast.TryStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.TryStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.ProtectedBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ProtectedBlock"),
						Serialize(node.ProtectedBlock)));
			}
			if (ShouldSerialize(node.ExceptionHandlers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ExceptionHandlers"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExceptionHandlerCollection", node.ExceptionHandlers)));
			}
			if (ShouldSerialize(node.FailureBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "FailureBlock"),
						Serialize(node.FailureBlock)));
			}
			if (ShouldSerialize(node.EnsureBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "EnsureBlock"),
						Serialize(node.EnsureBlock)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnExceptionHandler(Boo.Lang.Compiler.Ast.ExceptionHandler node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ExceptionHandler"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Declaration))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Declaration"),
						Serialize(node.Declaration)));
			}
			if (ShouldSerialize(node.FilterCondition))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "FilterCondition"),
						Serialize(node.FilterCondition)));
			}
			if (ShouldSerialize(node.Flags))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Flags"),
						Serialize(node.Flags)));
			}
			if (ShouldSerialize(node.Block))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Block"),
						Serialize(node.Block)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnIfStatement(Boo.Lang.Compiler.Ast.IfStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.IfStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Condition))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Condition"),
						Serialize(node.Condition)));
			}
			if (ShouldSerialize(node.TrueBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "TrueBlock"),
						Serialize(node.TrueBlock)));
			}
			if (ShouldSerialize(node.FalseBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "FalseBlock"),
						Serialize(node.FalseBlock)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnUnlessStatement(Boo.Lang.Compiler.Ast.UnlessStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.UnlessStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Condition))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Condition"),
						Serialize(node.Condition)));
			}
			if (ShouldSerialize(node.Block))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Block"),
						Serialize(node.Block)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnForStatement(Boo.Lang.Compiler.Ast.ForStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ForStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Declarations))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Declarations"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.DeclarationCollection", node.Declarations)));
			}
			if (ShouldSerialize(node.Iterator))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Iterator"),
						Serialize(node.Iterator)));
			}
			if (ShouldSerialize(node.Block))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Block"),
						Serialize(node.Block)));
			}
			if (ShouldSerialize(node.OrBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "OrBlock"),
						Serialize(node.OrBlock)));
			}
			if (ShouldSerialize(node.ThenBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ThenBlock"),
						Serialize(node.ThenBlock)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnWhileStatement(Boo.Lang.Compiler.Ast.WhileStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.WhileStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Condition))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Condition"),
						Serialize(node.Condition)));
			}
			if (ShouldSerialize(node.Block))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Block"),
						Serialize(node.Block)));
			}
			if (ShouldSerialize(node.OrBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "OrBlock"),
						Serialize(node.OrBlock)));
			}
			if (ShouldSerialize(node.ThenBlock))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ThenBlock"),
						Serialize(node.ThenBlock)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnBreakStatement(Boo.Lang.Compiler.Ast.BreakStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.BreakStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnContinueStatement(Boo.Lang.Compiler.Ast.ContinueStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ContinueStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnReturnStatement(Boo.Lang.Compiler.Ast.ReturnStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ReturnStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Expression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Expression"),
						Serialize(node.Expression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnYieldStatement(Boo.Lang.Compiler.Ast.YieldStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.YieldStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Expression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Expression"),
						Serialize(node.Expression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnRaiseStatement(Boo.Lang.Compiler.Ast.RaiseStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.RaiseStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Exception))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Exception"),
						Serialize(node.Exception)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnUnpackStatement(Boo.Lang.Compiler.Ast.UnpackStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.UnpackStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			if (ShouldSerialize(node.Declarations))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Declarations"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.DeclarationCollection", node.Declarations)));
			}
			if (ShouldSerialize(node.Expression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Expression"),
						Serialize(node.Expression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnExpressionPair(Boo.Lang.Compiler.Ast.ExpressionPair node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ExpressionPair"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.First))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "First"),
						Serialize(node.First)));
			}
			if (ShouldSerialize(node.Second))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Second"),
						Serialize(node.Second)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnMethodInvocationExpression(Boo.Lang.Compiler.Ast.MethodInvocationExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.MethodInvocationExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Target))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Target"),
						Serialize(node.Target)));
			}
			if (ShouldSerialize(node.Arguments))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Arguments"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionCollection", node.Arguments)));
			}
			if (ShouldSerialize(node.NamedArguments))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "NamedArguments"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionPairCollection", node.NamedArguments)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnUnaryExpression(Boo.Lang.Compiler.Ast.UnaryExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.UnaryExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Operator))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Operator"),
						Serialize(node.Operator)));
			}
			if (ShouldSerialize(node.Operand))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Operand"),
						Serialize(node.Operand)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnBinaryExpression(Boo.Lang.Compiler.Ast.BinaryExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.BinaryExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Operator))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Operator"),
						Serialize(node.Operator)));
			}
			if (ShouldSerialize(node.Left))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Left"),
						Serialize(node.Left)));
			}
			if (ShouldSerialize(node.Right))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Right"),
						Serialize(node.Right)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnConditionalExpression(Boo.Lang.Compiler.Ast.ConditionalExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ConditionalExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Condition))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Condition"),
						Serialize(node.Condition)));
			}
			if (ShouldSerialize(node.TrueValue))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "TrueValue"),
						Serialize(node.TrueValue)));
			}
			if (ShouldSerialize(node.FalseValue))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "FalseValue"),
						Serialize(node.FalseValue)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnReferenceExpression(Boo.Lang.Compiler.Ast.ReferenceExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ReferenceExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnMemberReferenceExpression(Boo.Lang.Compiler.Ast.MemberReferenceExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.MemberReferenceExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Target))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Target"),
						Serialize(node.Target)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnGenericReferenceExpression(Boo.Lang.Compiler.Ast.GenericReferenceExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.GenericReferenceExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Target))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Target"),
						Serialize(node.Target)));
			}
			if (ShouldSerialize(node.GenericArguments))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "GenericArguments"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.TypeReferenceCollection", node.GenericArguments)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnStringLiteralExpression(Boo.Lang.Compiler.Ast.StringLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.StringLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Value))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Value"),
						Serialize(node.Value)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnCharLiteralExpression(Boo.Lang.Compiler.Ast.CharLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.CharLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Value))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Value"),
						Serialize(node.Value)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnTimeSpanLiteralExpression(Boo.Lang.Compiler.Ast.TimeSpanLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.TimeSpanLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Value))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Value"),
						Serialize(node.Value)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnIntegerLiteralExpression(Boo.Lang.Compiler.Ast.IntegerLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.IntegerLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Value))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Value"),
						Serialize(node.Value)));
			}
			if (ShouldSerialize(node.IsLong))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsLong"),
						Serialize(node.IsLong)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnDoubleLiteralExpression(Boo.Lang.Compiler.Ast.DoubleLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.DoubleLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Value))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Value"),
						Serialize(node.Value)));
			}
			if (ShouldSerialize(node.IsSingle))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsSingle"),
						Serialize(node.IsSingle)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnNullLiteralExpression(Boo.Lang.Compiler.Ast.NullLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.NullLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnSelfLiteralExpression(Boo.Lang.Compiler.Ast.SelfLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SelfLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnSuperLiteralExpression(Boo.Lang.Compiler.Ast.SuperLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SuperLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnBoolLiteralExpression(Boo.Lang.Compiler.Ast.BoolLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.BoolLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Value))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Value"),
						Serialize(node.Value)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnRELiteralExpression(Boo.Lang.Compiler.Ast.RELiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.RELiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Value))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Value"),
						Serialize(node.Value)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		internal void SerializeSpliceExpression(Boo.Lang.Compiler.Ast.SpliceExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SpliceExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Expression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Expression"),
						Serialize(node.Expression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		internal void SerializeSpliceTypeReference(Boo.Lang.Compiler.Ast.SpliceTypeReference node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SpliceTypeReference"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.IsPointer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "IsPointer"),
						Serialize(node.IsPointer)));
			}
			if (ShouldSerialize(node.Expression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Expression"),
						Serialize(node.Expression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		internal void SerializeSpliceMemberReferenceExpression(Boo.Lang.Compiler.Ast.SpliceMemberReferenceExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SpliceMemberReferenceExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Target))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Target"),
						Serialize(node.Target)));
			}
			if (ShouldSerialize(node.NameExpression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "NameExpression"),
						Serialize(node.NameExpression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		internal void SerializeSpliceTypeMember(Boo.Lang.Compiler.Ast.SpliceTypeMember node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SpliceTypeMember"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.TypeMember))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "TypeMember"),
						Serialize(node.TypeMember)));
			}
			if (ShouldSerialize(node.NameExpression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "NameExpression"),
						Serialize(node.NameExpression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		internal void SerializeSpliceTypeDefinitionBody(Boo.Lang.Compiler.Ast.SpliceTypeDefinitionBody node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SpliceTypeDefinitionBody"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Expression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Expression"),
						Serialize(node.Expression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		internal void SerializeSpliceParameterDeclaration(Boo.Lang.Compiler.Ast.SpliceParameterDeclaration node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SpliceParameterDeclaration"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.ParameterDeclaration))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "ParameterDeclaration"),
						Serialize(node.ParameterDeclaration)));
			}
			if (ShouldSerialize(node.NameExpression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "NameExpression"),
						Serialize(node.NameExpression)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnExpressionInterpolationExpression(Boo.Lang.Compiler.Ast.ExpressionInterpolationExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ExpressionInterpolationExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Expressions))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Expressions"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionCollection", node.Expressions)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnHashLiteralExpression(Boo.Lang.Compiler.Ast.HashLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.HashLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Items))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Items"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionPairCollection", node.Items)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnListLiteralExpression(Boo.Lang.Compiler.Ast.ListLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ListLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Items))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Items"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionCollection", node.Items)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnCollectionInitializationExpression(Boo.Lang.Compiler.Ast.CollectionInitializationExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.CollectionInitializationExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Collection))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Collection"),
						Serialize(node.Collection)));
			}
			if (ShouldSerialize(node.Initializer))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Initializer"),
						Serialize(node.Initializer)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnArrayLiteralExpression(Boo.Lang.Compiler.Ast.ArrayLiteralExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ArrayLiteralExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Items))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Items"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.ExpressionCollection", node.Items)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnGeneratorExpression(Boo.Lang.Compiler.Ast.GeneratorExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.GeneratorExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Expression))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Expression"),
						Serialize(node.Expression)));
			}
			if (ShouldSerialize(node.Declarations))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Declarations"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.DeclarationCollection", node.Declarations)));
			}
			if (ShouldSerialize(node.Iterator))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Iterator"),
						Serialize(node.Iterator)));
			}
			if (ShouldSerialize(node.Filter))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Filter"),
						Serialize(node.Filter)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnExtendedGeneratorExpression(Boo.Lang.Compiler.Ast.ExtendedGeneratorExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.ExtendedGeneratorExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Items))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Items"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.GeneratorExpressionCollection", node.Items)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnSlice(Boo.Lang.Compiler.Ast.Slice node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.Slice"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Begin))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Begin"),
						Serialize(node.Begin)));
			}
			if (ShouldSerialize(node.End))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "End"),
						Serialize(node.End)));
			}
			if (ShouldSerialize(node.Step))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Step"),
						Serialize(node.Step)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnSlicingExpression(Boo.Lang.Compiler.Ast.SlicingExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.SlicingExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Target))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Target"),
						Serialize(node.Target)));
			}
			if (ShouldSerialize(node.Indices))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Indices"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.SliceCollection", node.Indices)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnTryCastExpression(Boo.Lang.Compiler.Ast.TryCastExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.TryCastExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Target))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Target"),
						Serialize(node.Target)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnCastExpression(Boo.Lang.Compiler.Ast.CastExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.CastExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Target))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Target"),
						Serialize(node.Target)));
			}
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnTypeofExpression(Boo.Lang.Compiler.Ast.TypeofExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.TypeofExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Type))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Type"),
						Serialize(node.Type)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnCustomStatement(Boo.Lang.Compiler.Ast.CustomStatement node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.CustomStatement"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifier))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifier"),
						Serialize(node.Modifier)));
			}
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnCustomExpression(Boo.Lang.Compiler.Ast.CustomExpression node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.CustomExpression"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			Push(mie);
		}

		[System.CodeDom.Compiler.GeneratedCodeAttribute("astgen.boo", "1")]
		override public void OnStatementTypeMember(Boo.Lang.Compiler.Ast.StatementTypeMember node)
		{
			MethodInvocationExpression mie = new MethodInvocationExpression(
					node.LexicalInfo,
					CreateReference(node, "Boo.Lang.Compiler.Ast.StatementTypeMember"));
			mie.Arguments.Add(Serialize(node.LexicalInfo));
			if (ShouldSerialize(node.Modifiers))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Modifiers"),
						Serialize(node.Modifiers)));
			}
			if (ShouldSerialize(node.Name))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Name"),
						Serialize(node.Name)));
			}
			if (ShouldSerialize(node.Attributes))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Attributes"),
						SerializeCollection(node, "Boo.Lang.Compiler.Ast.AttributeCollection", node.Attributes)));
			}
			if (ShouldSerialize(node.Statement))
			{
				mie.NamedArguments.Add(
					new ExpressionPair(
						CreateReference(node, "Statement"),
						Serialize(node.Statement)));
			}
			Push(mie);
		}

	}
}

