namespace spectra_plot{
  enum signal_type {
    IR,
    CNMR_DECOUPLED,
    HNMR
  };


  enum point_type {
    POINT,
    SPIKE,
    GAUSSIAN
  };


  class plot_point{
  public:
    enum  point_type _type;
    float  _x;
    float  _y;
    float  _sigma;
  };


  void save_as_native_file_cb(Fl_Widget* w, void* v);

  class plot_window: public Fl_Double_Window, public finestra_pr {
    friend void spectra_plot::save_as_native_file_cb(Fl_Widget* w, void* v);
  public:
    
    plot_window(signal_type type_plot=IR);
    
    virtual ~plot_window();

    virtual void draw();

    void add_spike(float x, float y);
    void add_group(gruppo to_add, float x, float y);

    virtual Fl_Scroll*  ritorna_scroll();
    virtual immagine*   ritorna_immagine();
    virtual mol_canvas* ritorna_mol_canvas();





  protected:
    void draw_axis();

    void draw_scale_y();

    void draw_scale_x();

    void draw_points();

    void draw_points_IR();

    void draw_groups();

    float remap_y(float old);

    float de_remap_y(float old);

    float remap_x(float old,signal_type t=CNMR_DECOUPLED);

    float de_remap_x(float old);

    float normalize_y(float old);
    
    float de_normalize_y(float old);

    float normalize_x(float old,signal_type t=CNMR_DECOUPLED);

    float de_normalize_x(float old);

    float actual_plot_w();
    float actual_plot_h();

    float actual_plot_x();
    float actual_plot_y();


    float _max_y;
    float _max_x;

    mol_canvas _canvas;
    immagine   _plot;

    

    Fl_Scroll* _placeholder;

    std::vector<plot_point> _data;

    std::vector<gruppo>     _groups;


    Fl_Button  _save_file_b;

    signal_type  _type_plot;

    const static int def_w;
    const static int def_h;

    const static float max_transmittance;

    const static float max_wave_no;

    /**
     *percentage
     */
    const static float def_gap_w;
    /**
     *percentage
     */
    const static float def_gap_h;

    const static char* title;

    const static float axys_div;

    const static float max_group_w;

  };

}


