IF("${CMAKE_BUILD_TYPE}" STREQUAL "DEBUG")
	IF(PERSOSIM)
		IF(NOT JAVA_EXECUTABLE)
			FIND_PACKAGE(Java COMPONENTS Runtime)
			IF(Java_JAVA_EXECUTABLE)
				SET(JAVA_EXECUTABLE "${Java_JAVA_EXECUTABLE}")
			ENDIF()
		ENDIF()

		IF(JAVA_EXECUTABLE)
			MESSAGE(STATUS "PersoSim based tests enabled, using PersoSim Jar: ${PERSOSIM}")
			MESSAGE(STATUS "Java: ${JAVA_EXECUTABLE}")
			ADD_DEFINITIONS(-DPERSOSIM_EXECUTABLE=\"\\\"${PERSOSIM}\\\"\" -DJAVA_EXECUTABLE=\"\\\"${JAVA_EXECUTABLE}\\\"\")
			SET(CMAKE_AUTOMOC_MOC_OPTIONS ${CMAKE_AUTOMOC_MOC_OPTIONS} -DPERSOSIM_EXECUTABLE=\"\\\"${PERSOSIM}\\\"\" -DJAVA_EXECUTABLE=\"\\\"${JAVA_EXECUTABLE}\\\"\")
		ELSE()
			MESSAGE(STATUS "Java not found! PersoSim based tests disabled.")
			UNSET(PERSOSIM)
		ENDIF()
	ELSE()
		MESSAGE(STATUS "PersoSim based tests disabled")
	ENDIF()
ENDIF()
