/*
 * This file was automatically generated by EvoSuite
 * Thu Sep 20 12:22:09 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.GenbankStreamSequence;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.PositionalAsymmetryAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, useJEE = true) 
public class PositionalAsymmetryAlgorithm_ESTest extends PositionalAsymmetryAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("T#4o9Gg';^v");
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultStepSize(10);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertNull(integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn((Bases) null).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertNotNull(positionalAsymmetryAlgorithm0);
      
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultStepSize(5000);
      assertEquals(500, (int)integer0);
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertNotNull(integer0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("");
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getOtherCount());
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(0, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getCCount());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      float[] floatArray0 = new float[6];
      // Undeclared exception!
      positionalAsymmetryAlgorithm0.getValues(5, 1048576, floatArray0);
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      float[] floatArray0 = new float[1];
      // Undeclared exception!
      try { 
        positionalAsymmetryAlgorithm0.getValues(1, 29, floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.sequence.Bases", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, true).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      float[] floatArray0 = new float[2];
      // Undeclared exception!
      try { 
        positionalAsymmetryAlgorithm0.getValues((-5), (-50), floatArray0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: -5 > end: -50
         //
         verifyException("uk.ac.sanger.artemis.plot.PositionalAsymmetryAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("cBbDFu|V)fD!S", "cBbDFu|V)fD!S");
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(fastaStreamSequence0);
      
      Bases bases0 = new Bases(fastaStreamSequence0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(0, fastaStreamSequence0.getACount());
      assertEquals(0, fastaStreamSequence0.getTCount());
      assertEquals(12, fastaStreamSequence0.getOtherCount());
      assertEquals(13, fastaStreamSequence0.length());
      assertEquals(0, fastaStreamSequence0.getGCount());
      assertEquals(1, fastaStreamSequence0.getCCount());
      assertEquals(4, fastaStreamSequence0.getFormatType());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      float[] floatArray0 = new float[0];
      // Undeclared exception!
      try { 
        positionalAsymmetryAlgorithm0.getValues(1, 2, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // 0
         //
         verifyException("uk.ac.sanger.artemis.plot.PositionalAsymmetryAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = null;
      try {
        positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.PositionalAsymmetryAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("T#4o9Gg';^v");
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultStepSize(29);
      assertEquals(2, (int)integer0);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("T#4o9Gg';^v");
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultStepSize(2);
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertNull(integer0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(1, Bases.FORWARD);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("T#4o9Gg';^v");
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultMinWindowSize();
      assertEquals(10, (int)integer0);
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNotNull(integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("T#4o9Gg';^v");
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5000, (int)integer0);
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(integer0);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("T#4o9Gg';^v");
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertNotNull(bases0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      
      Integer integer0 = positionalAsymmetryAlgorithm0.getDefaultWindowSize();
      assertEquals(500, (int)integer0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(integer0);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("T#4o9Gg';^v");
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      
      Strand strand0 = bases0.getReverseStrand();
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(11, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
      
      genbankStreamSequence0.setFromChar(bases0.letter_index);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(5, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getOtherCount());
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getTCount());
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      
      float[] floatArray0 = new float[1];
      positionalAsymmetryAlgorithm0.getValues(1, 29, floatArray0);
      assertEquals(1, floatArray0.length);
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(1, genbankStreamSequence0.getACount());
      assertEquals(5, genbankStreamSequence0.length());
      assertEquals(1, genbankStreamSequence0.getOtherCount());
      assertEquals(1, genbankStreamSequence0.getCCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(1, genbankStreamSequence0.getTCount());
      assertFalse(strand0.isForwardStrand());
      assertEquals(2, strand0.getDirection());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertArrayEquals(new float[] {0.0F}, floatArray0, 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(1, Strand.FORWARD);
      assertEquals(2, Strand.REVERSE);
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("?&?]");
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(4, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(4, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertNotNull(rawStreamSequence0);
      
      Bases bases0 = new Bases(rawStreamSequence0);
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(4, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(4, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      
      Strand strand0 = bases0.getForwardStrand();
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(4, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(4, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertNotNull(strand0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(0, rawStreamSequence0.getCCount());
      assertEquals(4, rawStreamSequence0.length());
      assertEquals(0, rawStreamSequence0.getGCount());
      assertEquals(3, rawStreamSequence0.getFormatType());
      assertEquals(4, rawStreamSequence0.getOtherCount());
      assertEquals(0, rawStreamSequence0.getACount());
      assertEquals(0, rawStreamSequence0.getTCount());
      assertEquals(1, strand0.getDirection());
      assertTrue(strand0.isForwardStrand());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(2, Strand.REVERSE);
      assertEquals(1, Strand.FORWARD);
      
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      GenbankStreamSequence genbankStreamSequence0 = new GenbankStreamSequence("T#4o9Gg';^v");
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.length());
      assertNotNull(genbankStreamSequence0);
      
      Bases bases0 = new Bases(genbankStreamSequence0);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.length());
      assertNotNull(bases0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(false, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.length());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      
      int int0 = positionalAsymmetryAlgorithm0.getValueCount();
      assertEquals(1, int0);
      assertEquals(10, genbankStreamSequence0.getOtherCount());
      assertNull(genbankStreamSequence0.getHeader());
      assertEquals(0, genbankStreamSequence0.getCCount());
      assertEquals(1, genbankStreamSequence0.getGCount());
      assertEquals(0, genbankStreamSequence0.getACount());
      assertEquals(2, genbankStreamSequence0.getFormatType());
      assertEquals(0, genbankStreamSequence0.getTCount());
      assertEquals(11, genbankStreamSequence0.length());
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("Reverse Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertEquals(2, Bases.REVERSE);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      assertNotNull(bases0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Strand strand0 = mock(Strand.class, new ViolatedAssumptionAnswer());
      doReturn(bases0).when(strand0).getBases();
      doReturn(true, false).when(strand0).isForwardStrand();
      PositionalAsymmetryAlgorithm positionalAsymmetryAlgorithm0 = new PositionalAsymmetryAlgorithm(strand0);
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(positionalAsymmetryAlgorithm0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
      
      Float float0 = positionalAsymmetryAlgorithm0.getMinimumInternal();
      assertEquals(0.0F, (float)float0, 0.01F);
      assertNull(positionalAsymmetryAlgorithm0.getAverage());
      assertEquals(1.4E-45F, positionalAsymmetryAlgorithm0.getUserMin(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isRevCompDisplay());
      assertEquals(1, positionalAsymmetryAlgorithm0.getValueCount());
      assertEquals("Positional Asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmName());
      assertEquals(3.4028235E38F, positionalAsymmetryAlgorithm0.getUserMax(), 0.01F);
      assertFalse(positionalAsymmetryAlgorithm0.isUserMaxMin());
      assertEquals("positional_asymmetry", positionalAsymmetryAlgorithm0.getAlgorithmShortName());
      assertTrue(positionalAsymmetryAlgorithm0.scalingFlag());
      assertNotNull(float0);
      assertEquals(1, Bases.FORWARD);
      assertEquals((-5), Bases.MIN_PRIORITY);
      assertEquals(0, Bases.MEDIUM_PRIORITY);
      assertEquals(5, Bases.MAX_PRIORITY);
      assertEquals(2, Bases.REVERSE);
  }
}
