/*
 * Argus Client Software.  Tools to read, analyze and manage Argus data.
 * Copyright (c) 2000-2003 QoSient, LLC
 * All rights reserved.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*  ranonymize.h */

#ifndef RaNonymize_h
#define RaNonymize_h

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <ctype.h>
#include <stdarg.h>

#include <sys/types.h>
#include <sys/socket.h>

#include <netinet/in.h>
#include <net/if.h>

#include <netinet/if_ether.h>
#include <ethertype.h>



#ifndef MAXSTRLEN
#define MAXSTRLEN		1024
#endif


#ifndef MAXPATHNAMELEN
#define MAXPATHNAMELEN		BUFSIZ
#endif


#if defined(RaMap)

void RaMapInit (void);
void RaMapShutDown (void);

int RaMapParseConversionFile (char *);
void RaMapInventory(void *, int, int);

#else /* defined(RaMap) */

extern void RaMapInit (void);
extern void RaMapShutDown (void);

int RaMapParseConversionFile (char *);
extern void RaMapInventory(void *, int, int);

#endif /* defined(RaMap) */
#endif /* RaMap_h */

