# Common rules for contributing to acme.sh



### 1. The file shebang must be `sh` not `bash`

acme.sh is a `unix shell` script,  not just a `bash` script.

If you want to contribute your script, the shebang must be: 
```sh
#!/usr/bin/env sh
```
After the installation, acme.sh could change the shebang to bash to get better performance if you have bash on your machine.

Of course, if you just use it on your own, it can be any valid shebang on your machine. It could be `sh` or `bash`, it's up to you.



### 2. Please create a new issue for future bugs
Please report a new issue here: `" Report bugs to xxxx dns api"`  https://github.com/Neilpang/acme.sh/issues

And please watch to that issue. Any future bug will be reported there.

Example: https://github.com/Neilpang/acme.sh/issues/2057


### 3. Cross-Platform Compatibility Guide

1. Don't use `grep -o` options, please use `_egrep_o()` function instead, other grep options may be used with caution.
2. Don't use `curl` or `wget`,  please use `_get()` or `_post()` function instead.  The `_post()` function can send `POST`, `PUT` or `UPDATE` requests.
3. Do not use `sed -e`, which causes a problem in OS X and BSD.
4. Do not use `sed` with labels, which causes `Label too long` problem in Solaris.
5. Do not use `sed` with newlines (`\n`), which causes a problem in OS X and BSD.
6. Do not use `grep -E` option.


If you need a BSD or Solaris development environment, please head to [vmactions](https://github.com/vmactions). For example, you can use [solaris-shell](https://github.com/vmactions/shell-solaris) to get a shell environment in Solaris.

## Style Guidelines
acme.sh uses shellcheck for new commits and also enforces style guidelines.  
To avoid the most common travis failures:  

* Use indentation with 2 spaces 
* remove trailing spaces 
* Doublequote variables  (use _debug txtvalue "$txtvalue" instead of  _debug txtvalue=$txtvalue)
* Always check the travis results after a commit 
* Consider using shellcheck (https://www.shellcheck.net/) before commiting 
* `shfmt -l -w -i 2 .` will re-indent your files


