The ACME protocol supported the `NotBefore` and `NotAfter` fields of the cert.
And some of the CAs supported this feature. (The Letsencrypt CA doesn't support it for now)


There are 2 command options to use:

1. The `--valid-to <date time>` option, which is for `NotAfter` field.
2. The `--valid-from <date time>` option, which is for `NotBefore` field.



Usage: 

### 1.  Set the lifetime of the cert:

```
acme.sh --issue  -d  example.com  -dns dns_cf    --valid-to  "2022-04-01T08:10:33Z"
```

The value of `--valid-to` is an absolute date time in the future.   The issued cert will expire on that time(`NotAfter`).

Please be careful about the date time format,  it Must be the exact format in UTC used above.



You can also use a relative date time format:

```
# This cert will only be valid for `10` days.

acme.sh  --issue  -d example.com --dns dns_cf   --valid-to  "+10d"


# This cert will be valid for `30` hours.

acme.sh  --issue  -d example.com --dns dns_cf   --valid-to  "+30h"

```

Please be careful about the format,  there are only `+*d` (for days) and `+*h` (for hours) supported for now. Any other format will not be accepted.



## If you use the absolute format for `--valid-to  "2022-04-01T08:10:33Z"`,   the cert will NOT be renewed automatically when it expires.  

## If you want the cert to be renewed automatically, please use the relative format:
  1. `--valid-to  +20d`(the cert will be renewed every 19 days).   If the lifetime is longer than one day, it will renew at one day before.
  2. `--valid-to  +11h`(the cert will be renewed every 10 hours).  If the lifttime is less than 24 hourst, it will renew at one hour before.

## Of course, if you don't use `--valid-to` parameter at all, the cert will be renewed every `60 days` as before.




### 2.  Set the beginning time of the cert:


```
acme.sh  --issue  -d example.com --dns dns_cf   --valid-from  "2022-04-01T08:10:33Z"

```

The cert time will be valid starting from `"2022-04-01T08:10:33Z"`.

You can also use the relative time format:

```

#The cert will be valid in 2 hours from now:

acme.sh  --issue  -d example.com --dns dns_cf   --valid-from  "+2h"


#The cert will be valid in 1 day from now:

acme.sh  --issue  -d example.com --dns dns_cf   --valid-from  "+1d"


```




### 3.  You can use them both at the same time:

```
# The cert will be valid from `"2022-04-01T08:10:33Z"`, and then live for 40 days to expire:

acme.sh  --issue  -d example.com --dns dns_cf   --valid-from  "2022-04-01T08:10:33Z"   --valid-to "+40d"


# The cert will be valid in 2 hours, and then live for 50 days to expire:

acme.sh  --issue  -d example.com --dns dns_cf   --valid-from  "+2h"  --valid-to "+50d"

```




### 4. If the lifetime is measured in hours,  you need to change the default crontab to run `acme.sh` every an hour:

```
0 * * * * "/root/.acme.sh"/acme.sh --cron --home "/root/.acme.sh" > /dev/null
```




