!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawmkgrad
!! NAME
!! pawmkgrad
!!
!! FUNCTION
!! PAW only:
!! Extract, from a given density (in abinit format),
!!          - the spin-up and spin-down and total densities
!!          - the spin-up and spin-down and total gradient(s)
!!
!! COPYRIGHT
!! Copyright (C) 2001-2007 ABINIT group (FJ, MT)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt.
!!
!! INPUTS
!!  ixc= choice of exchange-correlation scheme
!!  ngrad= 1 without gradients; 2 with gradients
!!  nrad= number of radial points
!!  nspden=number of spin-density components
!!  rhonow(nrad,nspden,ngrad*ngrad)=
!!    electron (spin)-density in real space and its gradient (Abinit format),
!!      rhonow(:,:,1)  =electron density in electrons/bohr**3
!!      rhonow(:,:,2:4)=gradient of electron density in el./bohr**4
!!
!! OUTPUT
!!  grho2_updn(nrad,2*nspden-1)=the square of the gradients of spin-up, spin-down, and total density
!!  rho_updn(npts,nspden)=the spin-up and spin-down densities
!!
!! NOTES
!!    If nspden=1, only the spin-up density must be given.
!!                 In the calling routine, the spin-down density must
!!                 be equal to the spin-up density,
!!                 and both are half the total density.
!!    If nspden=2, the spin-up and spin-down density must be given.
!!
!! PARENTS
!!      pawxcm
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine pawmkgrad(grho2_updn,ixc,ngrad,nrad,nspden,rhonow,rho_updn)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: ixc,ngrad,nrad,nspden
!arrays
 real(dp),intent(in) :: rhonow(nrad,nspden,ngrad*ngrad)
 real(dp),intent(out) :: grho2_updn(nrad,2*nspden-1),rho_updn(nrad,nspden)

!Local variables ------------------------------
!scalars
 integer :: ir

! *************************************************************************

 do ir=1,nrad
  if (nspden==1)then
   rho_updn(ir,1)=rhonow(ir,1,1)*half
   if(ixc>=11 .and. ixc<=16) grho2_updn(ir,1)=quarter*rhonow(ir,1,2)**2
  else
   rho_updn(ir,1)=rhonow(ir,2,1)
   rho_updn(ir,2)=rhonow(ir,1,1)-rhonow(ir,2,1)
   if(ixc>=11 .and. ixc<=16)then
    grho2_updn(ir,1)=rhonow(ir,2,2)**2
    grho2_updn(ir,2)=(rhonow(ir,1,2)-rhonow(ir,2,2)) **2
    grho2_updn(ir,3)=rhonow(ir,1,2)**2
   end if
  end if
 end do

end subroutine pawmkgrad
!!***
