#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Slipways
# send your bug reports to contact@dotslashplay.it
###

script_version=20230322.1

GAME_ID='slipways'
GAME_NAME='Slipways'

ARCHIVE_BASE_0='setup_slipways_1.3-1106-win_(64bit)_(61549).exe'
ARCHIVE_BASE_0_MD5='f14169a08342feaeb87b0420d7b5d65d'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='840000'
ARCHIVE_BASE_0_VERSION='1.3-gog61549'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/slipways'

UNITY3D_NAME='slipways'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES="
monobleedingedge
unityplayer.dll
${UNITY3D_NAME}.exe
${UNITY3D_NAME}_data/plugins"
CONTENT_GAME_DATA_FILES="
${UNITY3D_NAME}_data
data"

APP_WINE_LINK_DIRS='
userdata:users/${USER}/AppData/LocalLow/Beetlewing/Slipways'
USER_PERSISTENT_DIRECTORIES='
userdata'

APP_MAIN_EXE="${UNITY3D_NAME}.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"

# Load common functions

target_version='2.22'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

PKG='PKG_DATA'
icons_inclusion

# Include game data

content_inclusion_default

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

PKG='PKG_BIN'
launchers_write

# Build packages

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
