#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Detective Gallo
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220831.2

GAME_ID='detective-gallo'
GAME_NAME='Detective Gallo'

ARCHIVE_BASE_0='setup_detective_gallo_1.21_(29213).exe'
ARCHIVE_BASE_0_MD5='8e11f1d9d90468d1835cc68da7acb604'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1='setup_detective_gallo_1.21_(29213)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='93b24aafa234dd6e6dd053df5f3f594a'
ARCHIVE_BASE_0_SIZE='4500000'
ARCHIVE_BASE_0_VERSION='1.21-gog29213'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/detective_gallo'

CONTENT_PATH_DEFAULT='.'
ARCHIVE_GAME_MAIN_FILES='
acsetup.cfg
agsd3dvsync.dll
*.0??
*.exe
*.vox
*.tra'
ARCHIVE_DOC_MAIN_FILES='
docs'

APP_MAIN_TYPE='scummvm'
APP_MAIN_SCUMMID='ags:detectivegallo'
APP_MAIN_ICON='detective gallo.exe'

PKG_MAIN_DEPS='scummvm'

# Load common functions

target_version='2.17'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'

# Include game icons

icons_inclusion

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

launchers_write

# Build package

write_metadata
build_pkg

# Print instructions

print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
