/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#ifndef OPENDRIM_TCPPROTOCOLENDPOINTACCESS_H_
#define OPENDRIM_TCPPROTOCOLENDPOINTACCESS_H_

#include "SSH_Common.h"

#include "OpenDRIM_TCPProtocolEndpoint.h"

int SSH_OpenDRIM_TCPProtocolEndpoint_load(const CMPIBroker* broker, string& errorMessage);

int SSH_OpenDRIM_TCPProtocolEndpoint_unload(string& errorMessage);

int SSH_OpenDRIM_TCPProtocolEndpoint_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_TCPProtocolEndpoint>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SSH_OpenDRIM_TCPProtocolEndpoint_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_TCPProtocolEndpoint& instance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_TCPProtocolEndpoint_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& newInstance, const OpenDRIM_TCPProtocolEndpoint& oldInstance, const char** properties, string& errorMessage);

int SSH_OpenDRIM_TCPProtocolEndpoint_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& instance, string& errorMessage);

int SSH_OpenDRIM_TCPProtocolEndpoint_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& instance, string& errorMessage);

int SSH_OpenDRIM_TCPProtocolEndpoint_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& instance, unsigned int& returnValue, const OpenDRIM_TCPProtocolEndpoint_RequestStateChange_In& in, OpenDRIM_TCPProtocolEndpoint_RequestStateChange_Out& out, string& errorMessage);

int SSH_OpenDRIM_TCPProtocolEndpoint_BroadcastReset(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_TCPProtocolEndpoint& instance, unsigned int& returnValue, string& errorMessage);

int SSH_OpenDRIM_TCPProtocolEndpoint_populate(OpenDRIM_TCPProtocolEndpoint& instance, string& errorMessage);

#endif /*OPENDRIM_TCPPROTOCOLENDPOINTACCESS_H_*/
