/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module;

import edu.harvard.hul.ois.jhove.Agent;
import edu.harvard.hul.ois.jhove.AgentType;
import edu.harvard.hul.ois.jhove.Checksummer;
import edu.harvard.hul.ois.jhove.Document;
import edu.harvard.hul.ois.jhove.DocumentType;
import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.ExternalSignature;
import edu.harvard.hul.ois.jhove.Identifier;
import edu.harvard.hul.ois.jhove.IdentifierType;
import edu.harvard.hul.ois.jhove.InternalSignature;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RAFInputStream;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.Signature;
import edu.harvard.hul.ois.jhove.SignatureType;
import edu.harvard.hul.ois.jhove.SignatureUseType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHeader;
import edu.harvard.hul.ois.jhove.module.jpeg2000.Codestream;
import edu.harvard.hul.ois.jhove.module.jpeg2000.FileTypeBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.TopLevelBoxHolder;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Jpeg2000Module
extends ModuleBase {
    private static final String NAME = "JPEG2000-hul";
    private static final String RELEASE = "1.3";
    private static final int[] DATE = new int[]{2007, 1, 8};
    private static final String[] FORMAT = new String[]{"JPEG 2000", "JP2", "JPX"};
    private static final String COVERAGE = "JP2 (ISO/IEC 15444-1:2000/ITU-T Rec. T.800 (200)), JPX (ISO/IEC 15444-2:2004)";
    private static final String[] MIMETYPE = new String[]{"image/jp2", "image/jpx"};
    private static final String WELLFORMED = "The required Signature and File Type box structures are the first two boxes in the file; all boxes required by a given profile exist in the file; all box structures are well-formed (a four byte unsigned integer Box Length, followed by a four byte unsigned integer Box type, followed by a eight byte unsigned integer Box Length, followed by the Box Contents); no data exist before the first byte of the first box or after the last byte of the last box";
    private static final String VALIDITY = "The file is well-formed";
    private static final String REPINFO = "Properties capturing the technical attributes of the JPEG 2000 image from all boxes";
    private static final String NOTE = null;
    private static final String RIGHTS = "Copyright 2004-2007 by JSTOR and the President and Fellows of Harvard College. Released under the GNU Lesser General Public License.";
    protected NisoImageMetadata _niso;
    protected NisoImageMetadata _defaultNiso;
    protected DataInputStream _dstream;
    protected RandomAccessFile _raf;
    protected RAFInputStream _rafStream;
    protected List _propList;
    protected List codestreams;
    protected List binaryFilterProps;
    protected List associationProps;
    protected List digitalSigProps;
    protected int nCodestreams;
    protected int nCodestreamHeaders;
    protected List colorSpecs;
    protected List uuids;
    protected List composLayers;
    protected List uuidInfos;
    protected List xmlList;
    protected boolean jp2HdrSeen;
    protected boolean rreqSeen;
    protected boolean colorSpecSeen;
    protected boolean imageHeaderSeen;
    protected boolean jp2Compliant;
    protected boolean jpxCompliant;
    protected Codestream curCodestream;
    protected boolean filterMode;
    private static final int[] sigByte = new int[]{0, 0, 0, 12, 106, 80, 32, 32, 13, 10, 135, 10};

    public Jpeg2000Module() {
        super(NAME, RELEASE, DATE, FORMAT, COVERAGE, MIMETYPE, WELLFORMED, VALIDITY, REPINFO, NOTE, RIGHTS, true);
        Agent agent = new Agent("Harvard University Library", AgentType.EDUCATIONAL);
        agent.setAddress("Office for Information Systems, 90 Mt. Auburn St., Cambridge, MA 02138");
        agent.setTelephone("+1 (617) 495-3724");
        agent.setEmail("jhove-support@hulmail.harvard.edu");
        this._vendor = agent;
        Document document = new Document("Information technology -- JPEG 2000 image coding system -- Part 1: Code coding system", DocumentType.STANDARD);
        Agent agent2 = new Agent("ISO", AgentType.STANDARD);
        agent2.setAddress("1, rue de Varembe, Casa postale 56, CH-1211, Geneva 20, Switzerland");
        agent2.setTelephone("+41 22 749 01 11");
        agent2.setFax("+41 22 733 34 30");
        agent2.setEmail("iso@iso.ch");
        agent2.setWeb("http://www.iso.org/");
        document.setAuthor(agent2);
        document.setIdentifier(new Identifier("ISO/IEC 15444-1:2000", IdentifierType.ISO));
        document.setDate("2002-07-31");
        this._specification.add(document);
        document = new Document("Information technology -- JPEG 2000 image coding system -- Part 2: Extensions", DocumentType.STANDARD);
        document.setAuthor(agent2);
        document.setIdentifier(new Identifier("ISO/IEC 15444-2:2004", IdentifierType.ISO));
        document.setDate("2004-05-15");
        this._specification.add(document);
        document = new Document("MIME Type Registrations for JPEG 2000 (ISO/IEC 15444) RFC 3745", DocumentType.RFC);
        Agent agent3 = new Agent("IETF", AgentType.STANDARD);
        agent3.setWeb("http://www.ietf.org");
        document.setPublisher(agent3);
        agent = new Agent("D. Singer", AgentType.OTHER);
        document.setAuthor(agent);
        agent = new Agent("R. Clark", AgentType.OTHER);
        document.setAuthor(agent);
        agent = new Agent("D. Lee", AgentType.OTHER);
        document.setAuthor(agent);
        document.setDate("2004-04");
        Identifier identifier = new Identifier("http://www.ietf.org/rfc/rfc3745.txt", IdentifierType.URL);
        document.setIdentifier(identifier);
        this._specification.add(document);
        document = new Document("ITU-T Rec. T.800 (2002), Information technology -- JPEG 2000 image coding system: Core coding system", DocumentType.STANDARD);
        Agent agent4 = new Agent("ITU", AgentType.STANDARD);
        agent4.setAddress("ITU, Place des Nations, CH-1211 Geneva 20 Switzerland");
        agent4.setTelephone("+41 22 730 51 11");
        agent4.setFax("+41 22 730 6500");
        agent4.setEmail("itumail@itu.int");
        agent4.setWeb("http://www.itu.int/home/");
        document.setAuthor(agent4);
        document.setDate("2002-08");
        identifier = new Identifier("ITU-T Rec. T.800 (2002)", IdentifierType.ITU);
        document.setIdentifier(identifier);
        this._specification.add(document);
        Signature signature = new InternalSignature(sigByte, SignatureType.MAGIC, SignatureUseType.MANDATORY, 0, "");
        this._signature.add(signature);
        signature = new ExternalSignature(".jp2", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(signature);
        signature = new ExternalSignature(".jpx", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(signature);
        signature = new ExternalSignature(".jpf", SignatureType.EXTENSION, SignatureUseType.OPTIONAL);
        this._signature.add(signature);
        signature = new ExternalSignature("jp2 ", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(signature);
        signature = new ExternalSignature("jpx ", SignatureType.FILETYPE, SignatureUseType.OPTIONAL);
        this._signature.add(signature);
        this._bigEndian = true;
    }

    @Override
    public final void parse(RandomAccessFile randomAccessFile, RepInfo repInfo) throws IOException {
        this.initParse();
        this._rafStream = new RAFInputStream(randomAccessFile, this._je != null ? this._je.getBufferSize() : 0);
        this._dstream = new DataInputStream(this._rafStream);
        repInfo.setFormat(this._format[0]);
        repInfo.setMimeType(this._mimeType[0]);
        repInfo.setModule(this);
        this._propList = new ArrayList(12);
        Property property = new Property("JPEG2000Metadata", PropertyType.PROPERTY, PropertyArity.LIST, this._propList);
        this._raf = randomAccessFile;
        int n = 0;
        boolean bl = false;
        try {
            for (n = 0; n < 12; ++n) {
                int n2 = Jpeg2000Module.readUnsignedByte(this._dstream, this);
                if (n2 == sigByte[n]) continue;
                bl = true;
                break;
            }
        }
        catch (IOException iOException) {
            bl = true;
        }
        if (bl) {
            repInfo.setMessage(new ErrorMessage("No JPEG 2000 header", n));
            repInfo.setWellFormed(false);
            return;
        }
        repInfo.setSigMatch(this._name);
        if (!this.readFileTypeBox(repInfo)) {
            return;
        }
        if (!this.readBoxes(repInfo)) {
            return;
        }
        if (repInfo.getWellFormed() == 0) {
            return;
        }
        repInfo.setProperty(property);
        if (this._je != null && this._je.getChecksumFlag() && repInfo.getChecksum().size() == 0) {
            Checksummer checksummer = new Checksummer();
            this.calcRAChecksum(checksummer, randomAccessFile);
            this.setChecksums(checksummer, repInfo);
        }
        if (!this.rreqSeen || repInfo.getValid() != 1) {
            this.jpxCompliant = false;
        }
        if (!this.imageHeaderSeen || !this.colorSpecSeen || repInfo.getValid() != 1) {
            this.jp2Compliant = false;
        }
        if (this.jp2Compliant) {
            repInfo.setProfile("JP2");
        }
        if (this.jpxCompliant) {
            repInfo.setProfile("JPX");
            String string = this._mimeType[1];
            repInfo.setMimeType(string);
            this.curCodestream.getNiso().setMimeType(string);
            this._defaultNiso.setMimeType(string);
        }
        if (!this.colorSpecs.isEmpty()) {
            this._propList.add(new Property("ColorSpecs", PropertyType.PROPERTY, PropertyArity.LIST, this.colorSpecs));
        }
        if (!this.binaryFilterProps.isEmpty()) {
            this._propList.add(new Property("BinaryFilters", PropertyType.PROPERTY, PropertyArity.LIST, this.binaryFilterProps));
        }
        if (!this.associationProps.isEmpty()) {
            this._propList.add(new Property("Associations", PropertyType.PROPERTY, PropertyArity.LIST, this.associationProps));
        }
        if (!this.digitalSigProps.isEmpty()) {
            this._propList.add(new Property("DigitalSignatures", PropertyType.PROPERTY, PropertyArity.LIST, this.digitalSigProps));
        }
        if (!this.uuids.isEmpty()) {
            this._propList.add(new Property("UUIDs", PropertyType.PROPERTY, PropertyArity.LIST, this.uuids));
        }
        if (!this.composLayers.isEmpty()) {
            this._propList.add(new Property("CompositingLayers", PropertyType.PROPERTY, PropertyArity.LIST, this.composLayers));
        }
        if (!this.uuidInfos.isEmpty()) {
            this._propList.add(new Property("UUIDInfoBoxes", PropertyType.PROPERTY, PropertyArity.LIST, this.uuidInfos));
        }
        if (!this.codestreams.isEmpty()) {
            ArrayList<Property> arrayList = new ArrayList<Property>(this.codestreams.size());
            ListIterator listIterator = this.codestreams.listIterator();
            while (listIterator.hasNext()) {
                Codestream codestream = (Codestream)listIterator.next();
                arrayList.add(codestream.makeProperty());
            }
            this._propList.add(new Property("Codestreams", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        }
        if (!this.xmlList.isEmpty()) {
            this._propList.add(new Property("XML", PropertyType.STRING, PropertyArity.LIST, this.xmlList));
        }
    }

    public long getFilePos() {
        try {
            return this._rafStream.getFilePos();
        }
        catch (IOException iOException) {
            return 0L;
        }
    }

    public void seek(long l) throws IOException {
        this._rafStream.seek(l);
    }

    public NisoImageMetadata getDefaultNiso() {
        return this._defaultNiso;
    }

    public NisoImageMetadata getCurrentNiso() {
        if (this.curCodestream == null) {
            return this._defaultNiso;
        }
        return this.curCodestream.getNiso();
    }

    public Codestream getCodestream(int n) {
        Codestream codestream;
        if (n < this.codestreams.size()) {
            codestream = (Codestream)this.codestreams.get(n);
        } else {
            codestream = new Codestream();
            codestream.setDefaultNiso(this._defaultNiso);
            this.codestreams.add(codestream);
        }
        this.curCodestream = codestream;
        return codestream;
    }

    public int getNCodestreams() {
        return this.nCodestreams;
    }

    public int getNCodestreamHeaders() {
        return this.nCodestreamHeaders;
    }

    public boolean isJP2HdrSeen() {
        return this.jp2HdrSeen;
    }

    public void setNCodestreams(int n) {
        this.nCodestreams = n;
    }

    public void setNCodestreamHeaders(int n) {
        this.nCodestreamHeaders = n;
    }

    public void setJP2HdrSeen(boolean bl) {
        this.jp2HdrSeen = bl;
    }

    public void setRReqSeen(boolean bl) {
        this.rreqSeen = bl;
    }

    public void setColorSpecSeen(boolean bl) {
        this.colorSpecSeen = bl;
    }

    public void setImageHeaderSeen(boolean bl) {
        this.imageHeaderSeen = bl;
    }

    public void setJP2Compliant(boolean bl) {
        this.jp2Compliant = bl;
        if (this.jp2Compliant && this.jpxCompliant) {
            this._defaultNiso.setMimeType(MIMETYPE[1]);
        }
    }

    public void setJPXCompliant(boolean bl) {
        this.jpxCompliant = bl;
    }

    public void addProperty(Property property) {
        this._propList.add(property);
    }

    public void addColorSpec(Property property) {
        this.colorSpecs.add(property);
    }

    public void addBinaryFilterProp(Property property) {
        this.binaryFilterProps.add(property);
    }

    public void addAssociationProp(Property property) {
        this.associationProps.add(property);
    }

    public void addDigitalSignatureProp(Property property) {
        this.digitalSigProps.add(property);
    }

    public void addUUID(Property property) {
        this.uuids.add(property);
    }

    public void addUUIDInfo(Property property) {
        this.uuidInfos.add(property);
    }

    public void addComposLayer(Property property) {
        this.composLayers.add(property);
    }

    public void addXML(String string) {
        this.xmlList.add(string);
    }

    public String read4Chars(DataInputStream dataInputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            int n = Jpeg2000Module.readUnsignedByte(dataInputStream, this);
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public int readUnsignedShort(DataInputStream dataInputStream) throws IOException {
        return Jpeg2000Module.readUnsignedShort(dataInputStream, true, this);
    }

    public long readUnsignedInt(DataInputStream dataInputStream) throws IOException {
        return Jpeg2000Module.readUnsignedInt(dataInputStream, true, this);
    }

    public long readSignedLong(DataInputStream dataInputStream) throws IOException {
        return Jpeg2000Module.readSignedLong(dataInputStream, true, this);
    }

    @Override
    protected void initParse() {
        super.initParse();
        this.colorSpecs = new LinkedList();
        this.binaryFilterProps = new LinkedList();
        this.associationProps = new LinkedList();
        this.digitalSigProps = new LinkedList();
        this.uuids = new LinkedList();
        this.uuidInfos = new LinkedList();
        this.composLayers = new LinkedList();
        this.xmlList = new LinkedList();
        this.codestreams = new LinkedList();
        this.curCodestream = null;
        this.nCodestreams = 0;
        this.nCodestreamHeaders = 0;
        this.jp2HdrSeen = false;
        this.rreqSeen = false;
        this.filterMode = false;
        this._defaultNiso = new NisoImageMetadata();
        this._defaultNiso.setByteOrder("big-endian");
        this._defaultNiso.setMimeType(MIMETYPE[0]);
        this.jp2Compliant = true;
        this.jpxCompliant = true;
    }

    protected boolean readBoxes(RepInfo repInfo) throws IOException {
        JP2Box jP2Box;
        TopLevelBoxHolder topLevelBoxHolder = new TopLevelBoxHolder(this, this._raf, repInfo, this._dstream);
        while (topLevelBoxHolder.hasNext() && (jP2Box = (JP2Box)topLevelBoxHolder.next()) != null) {
            if (jP2Box.readBox()) continue;
            return false;
        }
        return true;
    }

    protected boolean readFileTypeBox(RepInfo repInfo) throws IOException {
        BoxHeader boxHeader = new BoxHeader(this, this._dstream);
        boxHeader.readHeader();
        if (!"ftyp".equals(boxHeader.getType())) {
            repInfo.setMessage(new ErrorMessage("Expected File Type Box, got " + boxHeader.getType(), this._nByte));
            repInfo.setWellFormed(false);
            return false;
        }
        FileTypeBox fileTypeBox = new FileTypeBox(this._raf);
        fileTypeBox.setBoxHeader(boxHeader);
        fileTypeBox.setDataInputStream(this._dstream);
        fileTypeBox.setRandomAccessFile(this._raf);
        fileTypeBox.setModule(this);
        fileTypeBox.setRepInfo(repInfo);
        return fileTypeBox.readBox();
    }

    protected boolean skipOverBox(BoxHeader boxHeader, RepInfo repInfo, DataInputStream dataInputStream) throws IOException {
        if (boxHeader.getLength() != 0L) {
            this.skipBytes(dataInputStream, (int)boxHeader.getDataLength(), this);
        }
        return true;
    }
}

