/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import edu.harvard.hul.ois.jhove.module.wave.ExifInfo;
import java.io.DataInputStream;
import java.io.IOException;

public class ExifStringChunk
extends Chunk {
    private String id;

    public ExifStringChunk(ModuleBase moduleBase, ChunkHeader chunkHeader, DataInputStream dataInputStream) {
        super(moduleBase, chunkHeader, dataInputStream);
        this.id = chunkHeader.getID();
    }

    @Override
    public boolean readChunk(RepInfo repInfo) throws IOException {
        WaveModule waveModule = (WaveModule)this._module;
        byte[] byArray = new byte[(int)this.bytesLeft];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])byArray, (ModuleBase)waveModule);
        String string = new String(byArray).trim();
        ExifInfo exifInfo = waveModule.getExifInfo();
        if ("erel".equals(this.id)) {
            exifInfo.setRelatedImageFile(string);
        } else if ("etim".equals(this.id)) {
            exifInfo.setTimeCreated(string);
        } else if ("ecor".equals(this.id)) {
            exifInfo.setManufacturer(string);
        } else if ("emdl".equals(this.id)) {
            exifInfo.setModel(string);
        }
        waveModule.getExifInfo().setRelatedImageFile(string);
        return true;
    }
}

