/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.pdf;

import edu.harvard.hul.ois.jhove.module.pdf.Stream;
import edu.harvard.hul.ois.jhove.module.pdf.Tokenizer;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileTokenizer
extends Tokenizer {
    private long _fileBufferPositionOffset;
    private byte[] _fileBuffer;
    private static final int FILEBUFSIZE = 4096;
    private int _fileBufferBytes;
    private int _fileBufferOffset;

    public FileTokenizer(RandomAccessFile randomAccessFile) {
        this._file = randomAccessFile;
        this._fileBufferPositionOffset = -1L;
        this._fileBuffer = new byte[4096];
        this.initFileBuffer();
    }

    private void initFileBuffer() {
        this._fileBufferBytes = 0;
        this._fileBufferOffset = 0;
    }

    public long getFilePos() throws IOException {
        return this._fileBufferPositionOffset + (long)this._fileBufferOffset;
    }

    @Override
    public int readChar() throws IOException {
        if (this._fileBufferOffset >= this._fileBufferBytes) {
            if (this._fileBufferBytes > 0) {
                long l = this._fileBufferPositionOffset + (long)this._fileBufferOffset;
                this._file.seek(l);
                this._fileBufferPositionOffset = l;
            }
            this._fileBufferBytes = this._file.read(this._fileBuffer);
            if (this._fileBufferBytes <= 0) {
                throw new EOFException();
            }
            this._fileBufferOffset = 0;
        }
        return this._fileBuffer[this._fileBufferOffset++] & 0xFF;
    }

    @Override
    public void seek(long l) throws IOException {
        if (this._fileBufferPositionOffset >= 0L && l >= this._fileBufferPositionOffset && l < this._fileBufferPositionOffset + (long)this._fileBufferBytes) {
            this._fileBufferOffset = (int)(l - this._fileBufferPositionOffset);
        } else {
            this._file.seek(l);
            this.initFileBuffer();
            this._fileBufferPositionOffset = l;
        }
        this.seekReset(l);
    }

    @Override
    public void backupChar() {
        --this._fileBufferOffset;
    }

    @Override
    protected void initStream(Stream stream) throws IOException {
        stream.setOffset(this.getFilePos());
    }

    @Override
    protected void setStreamOffset(Stream stream) throws IOException {
        if (stream.getOffset() < 0L) {
            stream.setOffset(this.getFilePos());
        }
    }
}

