/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ColorGroupBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2HeaderBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Strings;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;

public class ColorSpecBox
extends JP2Box {
    public ColorSpecBox(RandomAccessFile randomAccessFile, BoxHolder boxHolder) {
        super(randomAccessFile, boxHolder);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof JP2HeaderBox) && !(this._parentBox instanceof ColorGroupBox)) {
            this.wrongBoxContext();
            return false;
        }
        this.initBytesRead();
        int n = (int)this._boxHeader.getDataLength();
        ArrayList<Property> arrayList = new ArrayList<Property>(2);
        Property property = new Property("ColorSpec", PropertyType.PROPERTY, PropertyArity.LIST, arrayList);
        int n2 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        if (n2 > 2) {
            this._module.setJP2Compliant(false);
        }
        arrayList.add(this._module.addIntegerProperty("Method", n2, JP2Strings.methodStr));
        int n3 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        arrayList.add(new Property("Precedence", PropertyType.INTEGER, (Object)new Integer(n3)));
        int n4 = ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module);
        if (n4 == 0) {
            this._module.setJPXCompliant(false);
            arrayList.add(new Property("Approx", PropertyType.INTEGER, (Object)new Integer(0)));
        } else {
            this._module.setJP2Compliant(false);
            arrayList.add(this._module.addIntegerProperty("Approx", n4, JP2Strings.approxStr, JP2Strings.approxIdx));
        }
        if (n2 == 1) {
            long l = this._module.readUnsignedInt(this._dstrm);
            this._module.skipBytes(this._dstrm, n - 7, this._module);
            Property property2 = this._module.addIntegerProperty("EnumCS", (int)l, JP2Strings.enumCSStr);
            arrayList.add(property2);
        } else if (n2 == 2) {
            this._module.skipBytes(this._dstrm, 128, this._module);
            long l = this._module.readUnsignedInt(this._dstrm);
            HashSet<String> hashSet = new HashSet<String>();
            int n5 = 0;
            while ((long)n5 < l) {
                hashSet.add(this._module.read4Chars(this._dstrm));
                this._module.skipBytes(this._dstrm, 8, this._module);
                ++n5;
            }
            if (hashSet.contains("desc") && hashSet.contains("kTRC") && hashSet.contains("wtpt") && hashSet.contains("cprt")) {
                arrayList.add(new Property("RestrictedICCProfile", PropertyType.STRING, (Object)"Monochrome Input Profile"));
            } else if (hashSet.contains("desc") && hashSet.contains("rXYZ") && hashSet.contains("gXYZ") && hashSet.contains("bXYZ") && hashSet.contains("rTRC") && hashSet.contains("gTRC") && hashSet.contains("bTRC") && hashSet.contains("wtpt") && hashSet.contains("cprt")) {
                arrayList.add(new Property("RestrictedICCProfile", PropertyType.STRING, (Object)"Three-Component Matrix-Based Input Profile"));
            } else {
                this._repInfo.setMessage((Message)new ErrorMessage("Color spec box with method 2 has unrecognized ICC profile", this.filePos));
                this._repInfo.setValid(false);
            }
        } else {
            this._module.setJP2Compliant(false);
        }
        if (this._parentBox instanceof JP2HeaderBox) {
            this._module.addColorSpec(property);
        } else if (this._parentBox instanceof ColorGroupBox) {
            ((ColorGroupBox)this._parentBox).addColorSpec(property);
        }
        if (this._boxHeader.getLength() != 0L) {
            this._module.skipBytes(this._dstrm, (int)((long)n - (this._module.getFilePos() - this.startBytesRead)), this._module);
        }
        this.finalizeBytesRead();
        this._module.setColorSpecSeen(true);
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Color Specification Box";
    }
}

