/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.ListIterator;

public class ObjectIdentifier {
    private List _moduleList;

    public ObjectIdentifier(List list) {
        this._moduleList = list;
    }

    public void identify(File file, RepInfo repInfo, String string, boolean bl, boolean bl2) throws IOException {
        ListIterator listIterator = this._moduleList.listIterator();
        while (listIterator.hasNext()) {
            RepInfo repInfo2 = (RepInfo)repInfo.clone();
            Module module = (Module)listIterator.next();
            try {
                Closeable closeable;
                if (!module.hasFeature("edu.harvard.hul.ois.jhove.canValidate")) continue;
                if (module.isRandomAccess()) {
                    closeable = new RandomAccessFile(file, "r");
                    module.param(string);
                    if (bl) {
                        module.setVerbosity(1);
                    }
                    if (bl2) {
                        module.checkSignatures(file, (RandomAccessFile)closeable, repInfo2);
                    } else {
                        module.parse((RandomAccessFile)closeable, repInfo2);
                    }
                    ((RandomAccessFile)closeable).close();
                } else {
                    closeable = new FileInputStream(file);
                    module.param(string);
                    if (bl2) {
                        module.checkSignatures(file, (InputStream)closeable, repInfo2);
                    } else {
                        int n = module.parse((InputStream)closeable, repInfo2, 0);
                        while (n != 0) {
                            ((InputStream)closeable).close();
                            closeable = new FileInputStream(file);
                            n = module.parse((InputStream)closeable, repInfo2, n);
                        }
                    }
                    ((InputStream)closeable).close();
                }
            }
            catch (Exception exception) {
                continue;
            }
            if (repInfo2.getWellFormed() != 1) continue;
            repInfo.copy(repInfo2);
            break;
        }
    }
}

