/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils;

import cern.jet.math.Arithmetic;
import cern.jet.random.Normal;
import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.NormalDistribution;
import org.apache.commons.math.distribution.NormalDistributionImpl;
import org.broadinstitute.gatk.engine.GenomeAnalysisEngine;
import org.broadinstitute.gatk.utils.collections.Pair;
import org.broadinstitute.gatk.utils.exceptions.GATKException;

public class MannWhitneyU {
    private static Normal STANDARD_NORMAL = new Normal(0.0, 1.0, null);
    private static NormalDistribution APACHE_NORMAL = new NormalDistributionImpl(0.0, 1.0, 0.01);
    private static double LNSQRT2PI = Math.log(Math.sqrt(Math.PI * 2));
    private TreeSet<Pair<Number, USet>> observations;
    private int sizeSet1;
    private int sizeSet2;
    private ExactMode exactMode;

    public MannWhitneyU(ExactMode mode, boolean dither) {
        this.observations = dither ? new TreeSet<Pair<Number, USet>>(new DitheringComparator()) : new TreeSet<Pair<Number, USet>>(new NumberedPairComparator());
        this.sizeSet1 = 0;
        this.sizeSet2 = 0;
        this.exactMode = mode;
    }

    public MannWhitneyU() {
        this(ExactMode.POINT, true);
    }

    public MannWhitneyU(boolean dither) {
        this(ExactMode.POINT, dither);
    }

    public MannWhitneyU(ExactMode mode) {
        this(mode, true);
    }

    public void add(Number n, USet set) {
        this.observations.add(new Pair<Number, USet>(n, set));
        if (set == USet.SET1) {
            ++this.sizeSet1;
        } else {
            ++this.sizeSet2;
        }
    }

    public Pair<Long, Long> getR1R2() {
        long u1 = MannWhitneyU.calculateOneSidedU(this.observations, USet.SET1);
        long n1 = this.sizeSet1 * (this.sizeSet1 + 1) / 2;
        long r1 = u1 + n1;
        long n2 = this.sizeSet2 * (this.sizeSet2 + 1) / 2;
        long u2 = n1 * n2 - u1;
        long r2 = u2 + n2;
        return new Pair<Long, Long>(r1, r2);
    }

    @Requires(value={"lessThanOther != null"})
    @Ensures(value={"validateObservations(observations) || Double.isNaN(result.getFirst())", "result != null", "! Double.isInfinite(result.getFirst())", "! Double.isInfinite(result.getSecond())"})
    public Pair<Double, Double> runOneSidedTest(USet lessThanOther) {
        int m;
        long u = MannWhitneyU.calculateOneSidedU(this.observations, lessThanOther);
        int n = lessThanOther == USet.SET1 ? this.sizeSet1 : this.sizeSet2;
        int n2 = m = lessThanOther == USet.SET1 ? this.sizeSet2 : this.sizeSet1;
        if (n == 0 || m == 0) {
            return new Pair<Double, Double>(Double.NaN, Double.NaN);
        }
        return MannWhitneyU.calculateP(n, m, u, false, this.exactMode);
    }

    @Ensures(value={"result != null", "! Double.isInfinite(result.getFirst())", "! Double.isInfinite(result.getSecond())"})
    public Pair<Double, Double> runTwoSidedTest() {
        int m;
        Pair<Long, USet> uPair = MannWhitneyU.calculateTwoSidedU(this.observations);
        long u = (Long)uPair.first;
        int n = uPair.second == USet.SET1 ? this.sizeSet1 : this.sizeSet2;
        int n2 = m = uPair.second == USet.SET1 ? this.sizeSet2 : this.sizeSet1;
        if (n == 0 || m == 0) {
            return new Pair<Double, Double>(Double.NaN, Double.NaN);
        }
        return MannWhitneyU.calculateP(n, m, u, true, this.exactMode);
    }

    @Requires(value={"m > 0", "n > 0"})
    @Ensures(value={"result != null", "! Double.isInfinite(result.getFirst())", "! Double.isInfinite(result.getSecond())"})
    protected static Pair<Double, Double> calculateP(int n, int m, long u, boolean twoSided, ExactMode exactMode) {
        Pair<Double, Double> zandP = n > 8 && m > 8 ? MannWhitneyU.calculatePNormalApproximation(n, m, u, twoSided) : (n > 5 && m > 7 ? MannWhitneyU.calculatePNormalApproximation(n, m, u, twoSided) : (n > 8 || m > 8 ? MannWhitneyU.calculatePFromTable(n, m, u, twoSided) : MannWhitneyU.calculatePRecursively(n, m, u, twoSided, exactMode)));
        return zandP;
    }

    public static Pair<Double, Double> calculatePFromTable(int n, int m, long u, boolean twoSided) {
        return MannWhitneyU.calculatePNormalApproximation(n, m, u, twoSided);
    }

    @Requires(value={"m > 0", "n > 0"})
    @Ensures(value={"result != null", "! Double.isInfinite(result.getFirst())", "! Double.isInfinite(result.getSecond())"})
    public static Pair<Double, Double> calculatePNormalApproximation(int n, int m, long u, boolean twoSided) {
        double z = MannWhitneyU.getZApprox(n, m, u);
        if (twoSided) {
            return new Pair<Double, Double>(z, 2.0 * (z < 0.0 ? STANDARD_NORMAL.cdf(z) : 1.0 - STANDARD_NORMAL.cdf(z)));
        }
        return new Pair<Double, Double>(z, STANDARD_NORMAL.cdf(z));
    }

    @Requires(value={"m > 0", "n > 0"})
    @Ensures(value={"! Double.isNaN(result)", "! Double.isInfinite(result)"})
    private static double getZApprox(int n, int m, long u) {
        double mean = ((double)((long)m * (long)n) + 1.0) / 2.0;
        double var = (double)((long)n * (long)m) * ((double)(n + m) + 1.0) / 12.0;
        double z = ((double)u - mean) / Math.sqrt(var);
        return z;
    }

    public static double calculatePUniformApproximation(int n, int m, long u) {
        long R = u + (long)(n * (n + 1) / 2);
        double a = Math.sqrt(m * (n + m + 1));
        double b = (double)n / 2.0 * (1.0 - Math.sqrt((n + m + 1) / m));
        double z = b + (double)R / a;
        if (z < 0.0) {
            return 1.0;
        }
        if (z > (double)n) {
            return 0.0;
        }
        if (z > (double)n / 2.0) {
            return 1.0 - 1.0 / Arithmetic.factorial((int)n) * MannWhitneyU.uniformSumHelper(z, (int)Math.floor(z), n, 0);
        }
        return 1.0 / Arithmetic.factorial((int)n) * MannWhitneyU.uniformSumHelper(z, (int)Math.floor(z), n, 0);
    }

    private static double uniformSumHelper(double z, int m, int n, int k) {
        if (k > m) {
            return 0.0;
        }
        int coef = k % 2 == 0 ? 1 : -1;
        return (double)coef * Arithmetic.binomial((long)n, (long)k) * Math.pow(z - (double)k, n) + MannWhitneyU.uniformSumHelper(z, m, n, k + 1);
    }

    @Requires(value={"observed != null", "observed.size() > 0"})
    @Ensures(value={"result != null", "result.first > 0"})
    public static Pair<Long, USet> calculateTwoSidedU(TreeSet<Pair<Number, USet>> observed) {
        int set1SeenSoFar = 0;
        int set2SeenSoFar = 0;
        long uSet1DomSet2 = 0L;
        long uSet2DomSet1 = 0L;
        USet previous = null;
        for (Pair<Number, USet> dataPoint : observed) {
            if (dataPoint.second == USet.SET1) {
                ++set1SeenSoFar;
            } else {
                ++set2SeenSoFar;
            }
            if (previous != null) {
                if (dataPoint.second == USet.SET1) {
                    uSet2DomSet1 += (long)set2SeenSoFar;
                } else {
                    uSet1DomSet2 += (long)set1SeenSoFar;
                }
            }
            previous = (USet)((Object)dataPoint.second);
        }
        return uSet1DomSet2 < uSet2DomSet1 ? new Pair<Long, USet>(uSet1DomSet2, USet.SET1) : new Pair<Long, USet>(uSet2DomSet1, USet.SET2);
    }

    @Requires(value={"observed != null", "dominator != null", "observed.size() > 0"})
    @Ensures(value={"result >= 0"})
    public static long calculateOneSidedU(TreeSet<Pair<Number, USet>> observed, USet dominator) {
        long otherBeforeDominator = 0L;
        int otherSeenSoFar = 0;
        for (Pair<Number, USet> dataPoint : observed) {
            if (dataPoint.second != dominator) {
                ++otherSeenSoFar;
                continue;
            }
            otherBeforeDominator += (long)otherSeenSoFar;
        }
        return otherBeforeDominator;
    }

    @Requires(value={"m > 0", "n > 0", "u >= 0"})
    @Ensures(value={"result != null", "! Double.isInfinite(result.getFirst())", "! Double.isInfinite(result.getSecond())"})
    public static Pair<Double, Double> calculatePRecursively(int n, int m, long u, boolean twoSided, ExactMode mode) {
        double z;
        if (m > 8 && n > 5) {
            throw new GATKException(String.format("Please use the appropriate (normal or sum of uniform) approximation. Values n: %d, m: %d", n, m));
        }
        double p = mode == ExactMode.POINT ? MannWhitneyU.cpr(n, m, u) : MannWhitneyU.cumulativeCPR(n, m, u);
        try {
            double sd;
            z = mode == ExactMode.CUMULATIVE ? APACHE_NORMAL.inverseCumulativeProbability(p) : (p > 1.0 / Math.sqrt((sd = Math.sqrt((1.0 + 1.0 / (double)(1 + n + m)) * (double)(n * m) * (1.0 + (double)n + (double)m) / 12.0)) * sd * 2.0 * Math.PI) ? 0.0 : (u >= (long)(n * m / 2) ? Math.sqrt(-2.0 * (Math.log(sd) + Math.log(p) + LNSQRT2PI)) : -Math.sqrt(-2.0 * (Math.log(sd) + Math.log(p) + LNSQRT2PI))));
        }
        catch (MathException me) {
            throw new GATKException("A math exception occurred in inverting the probability", me);
        }
        return new Pair<Double, Double>(z, twoSided ? 2.0 * p : p);
    }

    protected static double calculatePRecursivelyDoNotCheckValuesEvenThoughItIsSlow(int n, int m, long u) {
        return MannWhitneyU.cpr(n, m, u);
    }

    protected static long countSequences(int n, int m, long u) {
        if (u < 0L) {
            return 0L;
        }
        if (m == 0 || n == 0) {
            return u == 0L ? 1L : 0L;
        }
        return MannWhitneyU.countSequences(n - 1, m, u - (long)m) + MannWhitneyU.countSequences(n, m - 1, u);
    }

    private static double cpr(int n, int m, long u) {
        if (u < 0L) {
            return 0.0;
        }
        if (m == 0 || n == 0) {
            return u == 0L ? 1.0 : 0.0;
        }
        return (double)n / (double)(n + m) * MannWhitneyU.cpr(n - 1, m, u - (long)m) + (double)m / (double)(n + m) * MannWhitneyU.cpr(n, m - 1, u);
    }

    private static double cumulativeCPR(int n, int m, long u) {
        double p = 0.0;
        long uSym = u <= (long)(n * m / 2) ? u : (long)n * (long)m - u;
        for (long uu = 0L; uu < uSym; ++uu) {
            p += MannWhitneyU.cpr(n, m, uu);
        }
        return u <= (long)(n * m / 2) ? p : 1.0 - p;
    }

    protected TreeSet<Pair<Number, USet>> getObservations() {
        return this.observations;
    }

    protected Pair<Integer, Integer> getSetSizes() {
        return new Pair<Integer, Integer>(this.sizeSet1, this.sizeSet2);
    }

    protected static boolean validateObservations(TreeSet<Pair<Number, USet>> tree) {
        boolean seen1 = false;
        boolean seen2 = false;
        boolean seenInvalid = false;
        for (Pair<Number, USet> p : tree) {
            if (!seen1 && p.getSecond() == USet.SET1) {
                seen1 = true;
            }
            if (!seen2 && p.getSecond() == USet.SET2) {
                seen2 = true;
            }
            if (!Double.isNaN(p.getFirst().doubleValue()) && !Double.isInfinite(p.getFirst().doubleValue())) continue;
            seenInvalid = true;
        }
        return !seenInvalid && seen1 && seen2;
    }

    public static enum ExactMode {
        POINT,
        CUMULATIVE;

    }

    public static enum USet {
        SET1,
        SET2;

    }

    private static class NumberedPairComparator
    implements Comparator<Pair<Number, USet>>,
    Serializable {
        @Override
        public boolean equals(Object other) {
            return false;
        }

        @Override
        public int compare(Pair<Number, USet> left, Pair<Number, USet> right) {
            return Double.compare(((Number)left.first).doubleValue(), ((Number)right.first).doubleValue());
        }
    }

    private static class DitheringComparator
    implements Comparator<Pair<Number, USet>>,
    Serializable {
        @Override
        public boolean equals(Object other) {
            return false;
        }

        @Override
        public int compare(Pair<Number, USet> left, Pair<Number, USet> right) {
            double comp = Double.compare(((Number)left.first).doubleValue(), ((Number)right.first).doubleValue());
            if (comp > 0.0) {
                return 1;
            }
            if (comp < 0.0) {
                return -1;
            }
            return GenomeAnalysisEngine.getRandomGenerator().nextBoolean() ? -1 : 1;
        }
    }
}

