/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.format;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.ComponentFormatterTemplate;
import org.fest.util.Arrays;
import org.fest.util.Collections;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IntrospectionComponentFormatter
extends ComponentFormatterTemplate {
    private final Class<? extends Component> targetType;
    private final List<String> propertyNames;
    private final Map<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();

    public IntrospectionComponentFormatter(Class<? extends Component> targetType, String ... propertyNames) {
        if (targetType == null) {
            throw new NullPointerException("targetType should not be null");
        }
        this.targetType = targetType;
        this.propertyNames = Collections.list((Object[])propertyNames);
        this.populate();
    }

    private void populate() {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(this.targetType, Object.class);
        }
        catch (Exception e) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to get BeanInfo for type ", this.targetType.getName()}), e);
        }
        for (PropertyDescriptor d : beanInfo.getPropertyDescriptors()) {
            this.register(d);
        }
    }

    private void register(PropertyDescriptor d) {
        String name = d.getName();
        if (!this.propertyNames.contains(name)) {
            return;
        }
        this.descriptors.put(name, d);
    }

    @Override
    protected String doFormat(Component c) {
        StringBuilder b = new StringBuilder();
        b.append(c.getClass().getName()).append("[");
        int max = this.propertyNames.size() - 1;
        for (int i = 0; i <= max; ++i) {
            this.appendProperty(b, this.propertyNames.get(i), c);
            if (i >= max) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }

    private void appendProperty(StringBuilder b, String name, Component c) {
        b.append(name).append("=");
        try {
            b.append(this.propertyValue(c, name));
        }
        catch (Exception e) {
            b.append(Strings.concat((Object[])new Object[]{"<Unable to read property [", e.getClass().getName(), ": ", Strings.quote((String)e.getMessage()), "]>"}));
        }
    }

    private Object propertyValue(Component c, String property) throws Exception {
        if ("showing".equals(property)) {
            return c.isShowing();
        }
        PropertyDescriptor descriptor = this.descriptors.get(property);
        Object value = descriptor.getReadMethod().invoke((Object)c, new Object[0]);
        if (this.isOneDimensionalArray(value)) {
            return Arrays.format((Object)value);
        }
        return Strings.quote((Object)value);
    }

    private boolean isOneDimensionalArray(Object o) {
        return o != null && o.getClass().isArray() && !o.getClass().getComponentType().isArray();
    }

    @Override
    public Class<? extends Component> targetType() {
        return this.targetType;
    }

    public String toString() {
        return Strings.concat((Object[])new Object[]{this.getClass().getName(), "[", "propertyNames=", this.propertyNames, "]"});
    }
}

