/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.fixture;

import org.fest.swing.core.MouseButton;
import org.fest.swing.core.MouseClickInfo;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JTreeFixture;
import org.fest.swing.fixture.JTreeNodeFixture;

public class JTreePathFixture
implements JTreeNodeFixture {
    private final String path;
    private final JTreeFixture tree;

    protected JTreePathFixture(JTreeFixture tree, String path) {
        this.tree = tree;
        this.path = path;
    }

    public JTreePathFixture expand() {
        this.tree.expandPath(this.path);
        return this;
    }

    public JTreePathFixture collapse() {
        this.tree.collapsePath(this.path);
        return this;
    }

    public JTreePathFixture select() {
        this.tree.selectPath(this.path);
        return this;
    }

    public JTreePathFixture click() {
        this.tree.clickPath(this.path);
        return this;
    }

    public JTreePathFixture click(MouseButton button) {
        this.tree.clickPath(this.path, button);
        return this;
    }

    public JTreePathFixture click(MouseClickInfo mouseClickInfo) {
        this.tree.clickPath(this.path, mouseClickInfo);
        return this;
    }

    public JTreePathFixture doubleClick() {
        this.tree.doubleClickPath(this.path);
        return this;
    }

    public JTreePathFixture rightClick() {
        this.tree.rightClickPath(this.path);
        return this;
    }

    public JTreePathFixture drag() {
        this.tree.drag(this.path);
        return this;
    }

    public JTreePathFixture drop() {
        this.tree.drop(this.path);
        return this;
    }

    public JPopupMenuFixture showPopupMenu() {
        return this.tree.showPopupMenuAt(this.path);
    }

    public String value() {
        return this.tree.valueAt(this.path);
    }

    public String path() {
        return this.path;
    }
}

