/* $Id: regiondb.h 222139 2020-03-13 00:15:01Z twu $ */
#ifndef REGIONDB_INCLUDED
#define REGIONDB_INCLUDED
#ifdef HAVE_CONFIG_H
#include <config.h>		/* For HAVE_64_BIT */
#endif

typedef struct Regiondb_T *Regiondb_T;

#include <stdio.h>
#include "access.h"
#include "types.h"
#include "mode.h"
#include "genomicpos.h"
#include "bool.h"

#include "compress.h"
#include "genome.h"


#define T Regiondb_T

typedef struct Regiondb_filenames_T *Regiondb_filenames_T;
struct Regiondb_filenames_T {
  char *regiondb_filename;
  char *regiondb_basename_ptr;
  char *regiondb_region1info_ptr;
};


extern void
Regiondb_filenames_free (Regiondb_filenames_T *old);


extern Regiondb_filenames_T
Regiondb_get_filenames (
#ifdef PMAP
		       Alphabet_T *alphabet, Alphabet_T required_alphabet,
#endif
		       Width_T *region1part, Width_T *region1interval,
		       char *genomesubdir, char *fileroot, char *idx_filesuffix, char *snps_root,
		       Width_T required_region1part, Width_T required_interval);


extern T
Regiondb_new_genome (Width_T *region1part, Width_T *region1interval,
		     char *genomesubdir, char *fileroot, char *idx_filesuffix, char *snps_root,
#ifdef PMAP
		     Alphabet_T *alphabet, int *alphabet_size, Alphabet_T required_alphabet,
#endif
		     Width_T required_region1part, Width_T required_interval,
		     Access_mode_T regiondb_access, bool sharedp,
		     bool multiple_sequences_p, bool unload_shared_memory_p);

extern void
Regiondb_free (T *old);

extern Univcoord_T *
Regiondb_get_diagonals (int *nentries, T this, int oligolen,
			char *queryptr, int pos5, int pos3,
			Univcoord_T low, Univcoord_T high, bool plusp, int genestrand,
			Univcoord_T **stream_alloc, int *streamsize_alloc,
			bool remove_repetitive_p);

extern void
Regiondb_setup (int region1part_in, int mode);

#undef T
#endif
