A type has both `packed` and `align` representation hints.

Erroneous code example:

```compile_fail,E0587
#[repr(packed, align(8))] // error!
struct Umbrella(i32);
```

You cannot use `packed` and `align` hints on a same type. If you want to pack a
type to a given size, you should provide a size to packed:

```
#[repr(packed(8))] // ok!
struct Umbrella(i32);
```
