/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafInstallRequestDoc/CMinPackageElemDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafInstallRequestXml/MinPackageElemXml.h"

using namespace Caf;

void MinPackageElemXml::add(
	const SmartPtrCMinPackageElemDoc minPackageElemDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MinPackageElemXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(minPackageElemDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string indexVal =
			CStringConv::toString<int32>(minPackageElemDoc->getIndex());
		CAF_CM_VALIDATE_STRING(indexVal);
		thisXml->addAttribute("index", indexVal);

		const std::string packageNamespaceVal = minPackageElemDoc->getPackageNamespace();
		CAF_CM_VALIDATE_STRING(packageNamespaceVal);
		thisXml->addAttribute("packageNamespace", packageNamespaceVal);

		const std::string packageNameVal = minPackageElemDoc->getPackageName();
		CAF_CM_VALIDATE_STRING(packageNameVal);
		thisXml->addAttribute("packageName", packageNameVal);

		const std::string packageVersionVal = minPackageElemDoc->getPackageVersion();
		CAF_CM_VALIDATE_STRING(packageVersionVal);
		thisXml->addAttribute("packageVersion", packageVersionVal);
	}
	CAF_CM_EXIT;
}

SmartPtrCMinPackageElemDoc MinPackageElemXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("MinPackageElemXml", "parse");

	SmartPtrCMinPackageElemDoc minPackageElemDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::string indexStrVal =
			thisXml->findRequiredAttribute("index");
		int32 indexVal = 0;
		if (! indexStrVal.empty()) {
			indexVal = CStringConv::fromString<int32>(indexStrVal);
		}

		const std::string packageNamespaceStrVal =
			thisXml->findRequiredAttribute("packageNamespace");
		const std::string packageNamespaceVal = packageNamespaceStrVal;

		const std::string packageNameStrVal =
			thisXml->findRequiredAttribute("packageName");
		const std::string packageNameVal = packageNameStrVal;

		const std::string packageVersionStrVal =
			thisXml->findRequiredAttribute("packageVersion");
		const std::string packageVersionVal = packageVersionStrVal;

		minPackageElemDoc.CreateInstance();
		minPackageElemDoc->initialize(
			indexVal,
			packageNamespaceVal,
			packageNameVal,
			packageVersionVal);
	}
	CAF_CM_EXIT;

	return minPackageElemDoc;
}

