/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-local-url-index.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_LOCAL_URL_INDEX_H
#define __UNITY_WEBAPPS_LOCAL_URL_INDEX_H


#define UNITY_WEBAPPS_TYPE_LOCAL_URL_INDEX              (unity_webapps_local_url_index_get_type())
#define UNITY_WEBAPPS_LOCAL_URL_INDEX(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_LOCAL_URL_INDEX, UnityWebappsLocalUrlIndex))
#define UNITY_WEBAPPS_LOCAL_URL_INDEX_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_LOCAL_URL_INDEX, UnityWebappsLocalUrlIndexClass))
#define UNITY_WEBAPPS_IS_LOCAL_URL_INDEX(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_LOCAL_URL_INDEX))
#define UNITY_WEBAPPS_IS_LOCAL_URL_INDEX_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_LOCAL_URL_INDEX))
#define UNITY_WEBAPPS_LOCAL_URL_INDEX_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_LOCAL_URL_INDEX, UnityWebappsLocalUrlIndexClass))

#include "unity-webapps-url-index.h"
#include "unity-webapps-local-available-application.h"
#include "unity-webapps-application-collector.h"

typedef struct _UnityWebappsLocalUrlIndexPrivate UnityWebappsLocalUrlIndexPrivate;

typedef struct _UnityWebappsLocalUrlIndex UnityWebappsLocalUrlIndex;


struct _UnityWebappsLocalUrlIndex {
	UnityWebappsUrlIndex manager;

	UnityWebappsLocalUrlIndexPrivate *priv;
};

typedef struct _UnityWebappsLocalUrlIndexClass UnityWebappsLocalUrlIndexClass;

struct _UnityWebappsLocalUrlIndexClass
{
	UnityWebappsUrlIndexClass parent_class;
};

GType unity_webapps_local_url_index_get_type (void) G_GNUC_CONST;

UnityWebappsUrlIndex *unity_webapps_local_url_index_new (UnityWebappsApplicationCollector *collector);
UnityWebappsUrlIndex *unity_webapps_local_url_index_new_default ();
gboolean unity_webapps_local_url_index_load_applications (UnityWebappsLocalUrlIndex *index);

UnityWebappsLocalAvailableApplication * unity_webapps_local_url_index_get_application_by_name (UnityWebappsLocalUrlIndex *index,
																							   const gchar *name);

#endif
