/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.file.ClassFile;
import alt.jiapi.reflect.JiapiClass;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class Loader {
    public JiapiClass loadClass(InputStream is) throws ClassNotFoundException, IOException {
        ClassFile clazz = ClassFile.parse(is);
        JiapiClass jiapiClass = new JiapiClass(clazz);
        jiapiClass.setLoader(this);
        return jiapiClass;
    }

    public JiapiClass loadClass(String className) throws ClassNotFoundException, IOException {
        return this.loadClass(className, null);
    }

    public JiapiClass loadClass(String className, URL location) throws ClassNotFoundException, IOException {
        JiapiClass jiapiClass = null;
        InputStream is = this.getInputStream(className, location);
        if (is == null) {
            throw new ClassNotFoundException(className);
        }
        ClassFile clazz = ClassFile.parse(is);
        jiapiClass = new JiapiClass(clazz);
        jiapiClass.setLoader(this);
        return jiapiClass;
    }

    private InputStream getInputStream(String name, URL location) throws IOException {
        if (location == null) {
            String resource = "/" + name.replace('.', '/') + ".class";
            return this.getClass().getResourceAsStream(resource);
        }
        return location.openStream();
    }

    public static void main(String[] args) throws Exception {
        Loader l = new Loader();
        JiapiClass clazz = l.loadClass(args[0]);
        System.out.println(clazz);
        if (args.length > 2) {
            clazz.addInterface(args[2]);
        }
        clazz.addField("jiapi_generated");
        if (args.length > 1) {
            clazz.dump(new FileOutputStream(args[1]));
        }
    }
}

