; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx2,+fma | FileCheck %s --check-prefix=X32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2,+fma | FileCheck %s --check-prefix=X64

; This test checks combinations of FNEG and FMA intrinsics

define <8 x float> @test1(<8 x float> %a, <8 x float> %b, <8 x float> %c)  {
; X32-LABEL: test1:
; X32:       # BB#0: # %entry
; X32-NEXT:    vfmsub213ps %ymm2, %ymm1, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test1:
; X64:       # BB#0: # %entry
; X64-NEXT:    vfmsub213ps %ymm2, %ymm1, %ymm0
; X64-NEXT:    retq
entry:
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %0 = tail call <8 x float> @llvm.x86.fma.vfmadd.ps.256(<8 x float> %a, <8 x float> %b, <8 x float> %sub.i) #2
  ret <8 x float> %0
}

declare <8 x float> @llvm.x86.fma.vfmadd.ps.256(<8 x float>, <8 x float>, <8 x float>)

define <4 x float> @test2(<4 x float> %a, <4 x float> %b, <4 x float> %c) {
; X32-LABEL: test2:
; X32:       # BB#0: # %entry
; X32-NEXT:    vfnmsub213ps %xmm2, %xmm1, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test2:
; X64:       # BB#0: # %entry
; X64-NEXT:    vfnmsub213ps %xmm2, %xmm1, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.fma.vfmadd.ps(<4 x float> %a, <4 x float> %b, <4 x float> %c) #2
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %0
  ret <4 x float> %sub.i
}

declare <4 x float> @llvm.x86.fma.vfmadd.ps(<4 x float> %a, <4 x float> %b, <4 x float> %c)

define <4 x float> @test3(<4 x float> %a, <4 x float> %b, <4 x float> %c)  {
; X32-LABEL: test3:
; X32:       # BB#0: # %entry
; X32-NEXT:    vfnmadd213ss %xmm2, %xmm1, %xmm0
; X32-NEXT:    vbroadcastss {{\.LCPI.*}}, %xmm1
; X32-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test3:
; X64:       # BB#0: # %entry
; X64-NEXT:    vfnmadd213ss %xmm2, %xmm1, %xmm0
; X64-NEXT:    vbroadcastss {{.*}}(%rip), %xmm1
; X64-NEXT:    vxorps %xmm1, %xmm0, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <4 x float> @llvm.x86.fma.vfnmadd.ss(<4 x float> %a, <4 x float> %b, <4 x float> %c) #2
  %sub.i = fsub <4 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %0
  ret <4 x float> %sub.i
}

declare <4 x float> @llvm.x86.fma.vfnmadd.ss(<4 x float> %a, <4 x float> %b, <4 x float> %c)

define <8 x float> @test4(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; X32-LABEL: test4:
; X32:       # BB#0: # %entry
; X32-NEXT:    vfnmadd213ps %ymm2, %ymm1, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test4:
; X64:       # BB#0: # %entry
; X64-NEXT:    vfnmadd213ps %ymm2, %ymm1, %ymm0
; X64-NEXT:    retq
entry:
  %0 = tail call <8 x float> @llvm.x86.fma.vfmsub.ps.256(<8 x float> %a, <8 x float> %b, <8 x float> %c) #2
  %sub.i = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %0
  ret <8 x float> %sub.i
}

define <8 x float> @test5(<8 x float> %a, <8 x float> %b, <8 x float> %c) {
; X32-LABEL: test5:
; X32:       # BB#0: # %entry
; X32-NEXT:    vbroadcastss {{\.LCPI.*}}, %ymm3
; X32-NEXT:    vxorps %ymm3, %ymm2, %ymm2
; X32-NEXT:    vfmsub213ps %ymm2, %ymm1, %ymm0
; X32-NEXT:    retl
;
; X64-LABEL: test5:
; X64:       # BB#0: # %entry
; X64-NEXT:    vbroadcastss {{.*}}(%rip), %ymm3
; X64-NEXT:    vxorps %ymm3, %ymm2, %ymm2
; X64-NEXT:    vfmsub213ps %ymm2, %ymm1, %ymm0
; X64-NEXT:    retq
entry:
  %sub.c = fsub <8 x float> <float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00, float -0.000000e+00>, %c
  %0 = tail call <8 x float> @llvm.x86.fma.vfmsub.ps.256(<8 x float> %a, <8 x float> %b, <8 x float> %sub.c) #2
  ret <8 x float> %0
}

declare <8 x float> @llvm.x86.fma.vfmsub.ps.256(<8 x float>, <8 x float>, <8 x float>)


define <2 x double> @test6(<2 x double> %a, <2 x double> %b, <2 x double> %c) {
; X32-LABEL: test6:
; X32:       # BB#0: # %entry
; X32-NEXT:    vfnmsub213pd %xmm2, %xmm1, %xmm0
; X32-NEXT:    retl
;
; X64-LABEL: test6:
; X64:       # BB#0: # %entry
; X64-NEXT:    vfnmsub213pd %xmm2, %xmm1, %xmm0
; X64-NEXT:    retq
entry:
  %0 = tail call <2 x double> @llvm.x86.fma.vfmadd.pd(<2 x double> %a, <2 x double> %b, <2 x double> %c) #2
  %sub.i = fsub <2 x double> <double -0.000000e+00, double -0.000000e+00>, %0
  ret <2 x double> %sub.i
}

declare <2 x double> @llvm.x86.fma.vfmadd.pd(<2 x double> %a, <2 x double> %b, <2 x double> %c)

