//= NVPTXInstPrinter.h - Convert NVPTX MCInst to assembly syntax --*- C++ -*-=//
//
//                     The LLVM Compiler Infrastructure
//
// This file is distributed under the University of Illinois Open Source
// License. See LICENSE.TXT for details.
//
//===----------------------------------------------------------------------===//
//
// This class prints an NVPTX MCInst to .ptx file syntax.
//
//===----------------------------------------------------------------------===//

#ifndef LLVM_LIB_TARGET_NVPTX_INSTPRINTER_NVPTXINSTPRINTER_H
#define LLVM_LIB_TARGET_NVPTX_INSTPRINTER_NVPTXINSTPRINTER_H

#include "llvm/MC/MCInstPrinter.h"
#include "llvm/Support/raw_ostream.h"

namespace llvm {

class MCOperand;
class MCSubtargetInfo;

class NVPTXInstPrinter : public MCInstPrinter {
public:
  NVPTXInstPrinter(const MCAsmInfo &MAI, const MCInstrInfo &MII,
                   const MCRegisterInfo &MRI, const MCSubtargetInfo &STI);

  void printRegName(raw_ostream &OS, unsigned RegNo) const override;
  void printInst(const MCInst *MI, raw_ostream &OS, StringRef Annot) override;

  // Autogenerated by tblgen.
  void printInstruction(const MCInst *MI, raw_ostream &O);
  static const char *getRegisterName(unsigned RegNo);
  // End

  void printOperand(const MCInst *MI, unsigned OpNo, raw_ostream &O);
  void printCvtMode(const MCInst *MI, int OpNum, raw_ostream &O,
                    const char *Modifier = nullptr);
  void printCmpMode(const MCInst *MI, int OpNum, raw_ostream &O,
                    const char *Modifier = nullptr);
  void printLdStCode(const MCInst *MI, int OpNum,
                     raw_ostream &O, const char *Modifier = nullptr);
  void printMemOperand(const MCInst *MI, int OpNum,
                       raw_ostream &O, const char *Modifier = nullptr);
  void printProtoIdent(const MCInst *MI, int OpNum,
                       raw_ostream &O, const char *Modifier = nullptr);
};

}

#endif
