; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out ";*\.cfi_*"
; RUN: llc < %s -mtriple=m68k-linux -verify-machineinstrs | FileCheck %s

define i64 @notll(i64 %x) {
; CHECK-LABEL: notll:
; CHECK:  ; %bb.0:
; CHECK:    move.l (4,%sp), %d0
; CHECK:    not.l %d0
; CHECK:    move.l (8,%sp), %d1
; CHECK:    not.l %d1
; CHECK:    rts
  %not = xor i64 %x, -1
  ret i64 %not
}

define i32 @notl(i32 %x) {
; CHECK-LABEL: notl:
; CHECK:  ; %bb.0:
; CHECK:    move.l (4,%sp), %d0
; CHECK:    not.l %d0
; CHECK:    rts
  %not = xor i32 %x, -1
  ret i32 %not
}

define i16 @nots(i16 %x) {
; CHECK-LABEL: nots:
; CHECK:  ; %bb.0:
; CHECK:    move.w (6,%sp), %d0
; CHECK:    not.w %d0
; CHECK:    rts
  %not = xor i16 %x, -1
  ret i16 %not
}

define i8 @notb(i8 %x) {
; CHECK-LABEL: notb:
; CHECK:  ; %bb.0:
; CHECK:    move.b (7,%sp), %d0
; CHECK:    not.b %d0
; CHECK:    rts
  %not = xor i8 %x, -1
  ret i8 %not
}

define i64 @negll(i64 %x) {
; CHECK-LABEL: negll:
; CHECK:  ; %bb.0:
; CHECK:    move.l (4,%sp), %d0
; CHECK:    move.l (8,%sp), %d1
; CHECK:    neg.l %d1
; CHECK:    negx.l %d0
; CHECK:    rts
  %neg = sub i64 0, %x
  ret i64 %neg
}

define i32 @negl(i32 %x) {
; CHECK-LABEL: negl:
; CHECK:  ; %bb.0:
; CHECK:    move.l (4,%sp), %d0
; CHECK:    neg.l %d0
; CHECK:    rts
  %neg = sub i32 0, %x
  ret i32 %neg
}

define i16 @negs(i16 %x) {
; CHECK-LABEL: negs:
; CHECK:  ; %bb.0:
; CHECK:    move.w (6,%sp), %d0
; CHECK:    neg.w %d0
; CHECK:    rts
  %neg = sub i16 0, %x
  ret i16 %neg
}

define i8 @negb(i8 %x) {
; CHECK-LABEL: negb:
; CHECK:  ; %bb.0:
; CHECK:    move.b (7,%sp), %d0
; CHECK:    neg.b %d0
; CHECK:    rts
  %neg = sub i8 0, %x
  ret i8 %neg
}
