/* SPDX-License-Identifier: GPL-2.0 */
#ifndef __ASM_ARCH_IRQS_H
#define __ASM_ARCH_IRQS_H

#define IRQ_EP93XX_VIC0			1

#define IRQ_EP93XX_COMMRX		(IRQ_EP93XX_VIC0 + 2)
#define IRQ_EP93XX_COMMTX		(IRQ_EP93XX_VIC0 + 3)
#define IRQ_EP93XX_TIMER1		(IRQ_EP93XX_VIC0 + 4)
#define IRQ_EP93XX_TIMER2		(IRQ_EP93XX_VIC0 + 5)
#define IRQ_EP93XX_AACINTR		(IRQ_EP93XX_VIC0 + 6)
#define IRQ_EP93XX_DMAM2P0		(IRQ_EP93XX_VIC0 + 7)
#define IRQ_EP93XX_DMAM2P1		(IRQ_EP93XX_VIC0 + 8)
#define IRQ_EP93XX_DMAM2P2		(IRQ_EP93XX_VIC0 + 9)
#define IRQ_EP93XX_DMAM2P3		(IRQ_EP93XX_VIC0 + 10)
#define IRQ_EP93XX_DMAM2P4		(IRQ_EP93XX_VIC0 + 11)
#define IRQ_EP93XX_DMAM2P5		(IRQ_EP93XX_VIC0 + 12)
#define IRQ_EP93XX_DMAM2P6		(IRQ_EP93XX_VIC0 + 13)
#define IRQ_EP93XX_DMAM2P7		(IRQ_EP93XX_VIC0 + 14)
#define IRQ_EP93XX_DMAM2P8		(IRQ_EP93XX_VIC0 + 15)
#define IRQ_EP93XX_DMAM2P9		(IRQ_EP93XX_VIC0 + 16)
#define IRQ_EP93XX_DMAM2M0		(IRQ_EP93XX_VIC0 + 17)
#define IRQ_EP93XX_DMAM2M1		(IRQ_EP93XX_VIC0 + 18)
#define IRQ_EP93XX_GPIO0MUX		(IRQ_EP93XX_VIC0 + 19)
#define IRQ_EP93XX_GPIO1MUX		(IRQ_EP93XX_VIC0 + 20)
#define IRQ_EP93XX_GPIO2MUX		(IRQ_EP93XX_VIC0 + 21)
#define IRQ_EP93XX_GPIO3MUX		(IRQ_EP93XX_VIC0 + 22)
#define IRQ_EP93XX_UART1RX		(IRQ_EP93XX_VIC0 + 23)
#define IRQ_EP93XX_UART1TX		(IRQ_EP93XX_VIC0 + 24)
#define IRQ_EP93XX_UART2RX		(IRQ_EP93XX_VIC0 + 25)
#define IRQ_EP93XX_UART2TX		(IRQ_EP93XX_VIC0 + 26)
#define IRQ_EP93XX_UART3RX		(IRQ_EP93XX_VIC0 + 27)
#define IRQ_EP93XX_UART3TX		(IRQ_EP93XX_VIC0 + 28)
#define IRQ_EP93XX_KEY			(IRQ_EP93XX_VIC0 + 29)
#define IRQ_EP93XX_TOUCH		(IRQ_EP93XX_VIC0 + 30)
#define EP93XX_VIC1_VALID_IRQ_MASK	0x7ffffffc

#define IRQ_EP93XX_VIC1			(IRQ_EP93XX_VIC0 + 32)

#define IRQ_EP93XX_EXT0			(IRQ_EP93XX_VIC1 + 0)
#define IRQ_EP93XX_EXT1			(IRQ_EP93XX_VIC1 + 1)
#define IRQ_EP93XX_EXT2			(IRQ_EP93XX_VIC1 + 2)
#define IRQ_EP93XX_64HZ			(IRQ_EP93XX_VIC1 + 3)
#define IRQ_EP93XX_WATCHDOG		(IRQ_EP93XX_VIC1 + 4)
#define IRQ_EP93XX_RTC			(IRQ_EP93XX_VIC1 + 5)
#define IRQ_EP93XX_IRDA			(IRQ_EP93XX_VIC1 + 6)
#define IRQ_EP93XX_ETHERNET		(IRQ_EP93XX_VIC1 + 7)
#define IRQ_EP93XX_EXT3			(IRQ_EP93XX_VIC1 + 8)
#define IRQ_EP93XX_PROG			(IRQ_EP93XX_VIC1 + 9)
#define IRQ_EP93XX_1HZ			(IRQ_EP93XX_VIC1 + 10)
#define IRQ_EP93XX_VSYNC		(IRQ_EP93XX_VIC1 + 11)
#define IRQ_EP93XX_VIDEO_FIFO		(IRQ_EP93XX_VIC1 + 12)
#define IRQ_EP93XX_SSP1RX		(IRQ_EP93XX_VIC1 + 13)
#define IRQ_EP93XX_SSP1TX		(IRQ_EP93XX_VIC1 + 14)
#define IRQ_EP93XX_GPIO4MUX		(IRQ_EP93XX_VIC1 + 15)
#define IRQ_EP93XX_GPIO5MUX		(IRQ_EP93XX_VIC1 + 16)
#define IRQ_EP93XX_GPIO6MUX		(IRQ_EP93XX_VIC1 + 17)
#define IRQ_EP93XX_GPIO7MUX		(IRQ_EP93XX_VIC1 + 18)
#define IRQ_EP93XX_TIMER3		(IRQ_EP93XX_VIC1 + 19)
#define IRQ_EP93XX_UART1		(IRQ_EP93XX_VIC1 + 20)
#define IRQ_EP93XX_SSP			(IRQ_EP93XX_VIC1 + 21)
#define IRQ_EP93XX_UART2		(IRQ_EP93XX_VIC1 + 22)
#define IRQ_EP93XX_UART3		(IRQ_EP93XX_VIC1 + 23)
#define IRQ_EP93XX_USB			(IRQ_EP93XX_VIC1 + 24)
#define IRQ_EP93XX_ETHERNET_PME		(IRQ_EP93XX_VIC1 + 25)
#define IRQ_EP93XX_DSP			(IRQ_EP93XX_VIC1 + 26)
#define IRQ_EP93XX_GPIO_AB		(IRQ_EP93XX_VIC1 + 27)
#define IRQ_EP93XX_SAI			(IRQ_EP93XX_VIC1 + 28)
#define EP93XX_VIC2_VALID_IRQ_MASK	0x1fffffff

#define NR_EP93XX_IRQS			(IRQ_EP93XX_VIC1 + 32 + 24)

#define EP93XX_BOARD_IRQ(x)		(NR_EP93XX_IRQS + (x))
#define EP93XX_BOARD_IRQS		32

#endif
