// { dg-do run { target c++17 } }

// Copyright (C) 2014-2023 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 3, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING3.  If not see
// <http://www.gnu.org/licenses/>.

// C++17 30.10.8.4.9 path decomposition [fs.path.decompose]

#include <filesystem>
#include <testsuite_hooks.h>
#include <testsuite_fs.h>

using std::filesystem::path;

void
test01()
{
  path p0;
  VERIFY( p0.parent_path() == p0 );
  path p1 = "foo";
  VERIFY( p1.parent_path() == p0 );
  path p2 = "foo/bar";
  VERIFY( p2.parent_path() == p1 );
  path p3 = "/foo/bar";
  VERIFY( p3.parent_path() == path("/foo") );
  VERIFY( p3.parent_path().parent_path() == path("/") );
  VERIFY( p3.parent_path().parent_path().parent_path() == path("/") );
  path p4 = "/";
  VERIFY( p4.parent_path() == p4 );
}

void
test02()
{
  for (const path p : __gnu_test::test_paths)
  {
    if (p.begin() == p.end())
      continue;
    if (p.has_relative_path())
    {
      path pp;
      for (auto i = p.begin(), end = --p.end(); i != end; ++i)
      {
	pp /= *i;
      }
      VERIFY( p.parent_path() == pp );
    }
    else
      VERIFY( p.parent_path() == p );
  }
}

void
test03()
{
  const std::string narrow = "there/are/no/wrong/turns/only/unexpected/paths";
  const path::string_type s(narrow.begin(), narrow.end());
  const auto s1 = s.substr(0, s.length() - 6);    // remove "/paths"
  const auto s2 = s1.substr(0, s1.length() - 16); // remove "/only/..."

  // PR libstdc++/99805
  path p = path::string_type(s);
  auto pp = p.parent_path();
  VERIFY( pp.native() == s1 );
  pp = pp.parent_path().parent_path();
  VERIFY( pp.native() == s2 );

  path from_lval(s);
  pp = from_lval.parent_path();
  VERIFY( pp.native() == s1 );
  pp = pp.parent_path().parent_path();
  VERIFY( pp.native() == s2 );
}

int
main()
{
  test01();
  test02();
  test03();
}
