﻿// Copyright (c) Microsoft.  All Rights Reserved.  Licensed under the MIT license.  See License.txt in the project root for license information.

using System.Threading;

#nullable enable

namespace Microsoft.CodeAnalysis.Tools.Tests.Utilities
{
    /// <summary>
    /// Loads MSBuild assemblies.
    /// </summary>
    public sealed class MSBuildRegistrar
    {
        private static int s_registered;

        private static string? s_msBuildPath;

        public static string RegisterInstance()
        {
            if (Interlocked.Exchange(ref s_registered, 1) == 0)
            {
                var msBuildInstance = Build.Locator.MSBuildLocator.RegisterDefaults();
                s_msBuildPath = msBuildInstance.MSBuildPath;
            }

            return s_msBuildPath!;
        }
    }
}
