#############################################################
#
# sysklogd
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
SYSKLOGD_SOURCE:=sysklogd.tar.gz
SYSKLOGD_SITE:=ftp://ftp.gnu.org/gnu/sysklogd
SYSKLOGD_CAT:=zcat
endif

SYSKLOGD_DIR:=$(BUILD_DIR)/sysklogd
SYSKLOGD_BINARY:=klogd
SYSKLOGD_TARGET_BINARY:=sbin/klogd

ifneq ($(USE_CVS),true)
sysklogd-fetch:
	 $(WGET) -P $(DL_DIR) $(SYSKLOGD_SITE)/$(SYSKLOGD_SOURCE)

sysklogd-source: $(DL_DIR)/$(SYSKLOGD_SOURCE)
else
sysklogd-source:
endif

SYSKLOGD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d sysklogd $(CVS_TAG) $(CVS_PREFIX)sysklogd

sysklogd-checkout: 
	@$(SYSKLOGD_CVSCO)

$(SYSKLOGD_DIR)/.unpacked: $(DL_DIR)/$(SYSKLOGD_SOURCE)
ifneq ($(USE_CVS),true)
	$(SYSKLOGD_CAT) $(DL_DIR)/$(SYSKLOGD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(SYSKLOGD_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(SYSKLOGD_DIR)/
	sed -i -e 's,500 -s,500,g' $(SYSKLOGD_DIR)/Makefile
	touch $(SYSKLOGD_DIR)/.unpacked

$(SYSKLOGD_DIR)/$(SYSKLOGD_BINARY): $(SYSKLOGD_DIR)/.unpacked
	$(MAKE) CC=$(TARGET_CC) -C $(SYSKLOGD_DIR)

$(TARGET_DIR)/$(SYSKLOGD_TARGET_BINARY): $(SYSKLOGD_DIR)/$(SYSKLOGD_BINARY)
	$(MAKE) MANDIR=$(TARGET_DIR)/usr/man BINDIR=$(TARGET_DIR)/sbin -C $(SYSKLOGD_DIR) install
	$(STRIP) $(TARGET_DIR)/sbin/klogd $(TARGET_DIR)/sbin/syslogd
	install -m0755 $(SYSKLOGD_DIR)/redhat/syslog.init $(TARGET_DIR)/etc/rc.d/init.d/syslog
	install -m0644 $(SYSKLOGD_DIR)/redhat/syslog.conf.rhs $(TARGET_DIR)/etc/syslog.conf
	if [ ! -d $(TARGET_LOGROTATE_DIR) ]; then \
		mkdir --mode=0755 -p $(TARGET_LOGROTATE_DIR); \
	fi
	install -m0644 $(SYSKLOGD_DIR)/redhat/syslog.log $(TARGET_DIR)/etc/logrotate.d/syslog
	$(SOURCE_DIR)/addservice $(TARGET_DIR) syslog
	install -d $(DOC_DIR)/doc/sysklogd
	@for f in COPYING NEWS README.1st README.linux ; do \
		install -m0644 $(SYSKLOGD_DIR)/$$f $(DOC_DIR)/doc/sysklogd/$$f ;\
	done

sysklogd: uclibc $(TARGET_DIR)/$(SYSKLOGD_TARGET_BINARY)

sysklogd-clean:
	-rm -f $(TARGET_DIR)/$(SYSKLOGD_TARGET_BINARY) \
		$(TARGET_DIR)/sbin/klogd
	-rm -f $(TARGET_DIR)/etc/rc.d/init.d/syslog \
		$(TARGET_DIR)/etc/syslog.conf \
		$(TARGET_DIR)/etc/logrotate.d/syslog
	-rm -f $(TARGET_DIR)/usr/man/man8/sysklogd.8 \
		$(TARGET_DIR)/usr/man/man8/syslogd.8 \
		$(TARGET_DIR)/usr/man/man8/klogd.8 \
		$(TARGET_DIR)/usr/man/man5/syslog.conf.5
	-rm -rf $(DOC_DIR)/doc/sysklogd
	-$(MAKE) -C $(SYSKLOGD_DIR) clean

sysklogd-dirclean:
	rm -rf $(SYSKLOGD_DIR)
endif

